def difference(x, y, a, b):

    return (y-(a*x+b))**2

def goodness(coords, a, b):

    """Return  the goodness  of fit  between the  given set  of planar
    coords, in the form [(x1, y1),...], and the line y=ax+b"""

    return sum([difference(x, y, a, b) for (x, y) in coords])

def regression(coords, throwaway=0):

    """Return the coefficients  of the line of best  fit to the points
    in coords, which should be a list of the form [(x1, y1),...]

    Repeatedly throw out the most

    Taken  rather uncritically  from Numerical  Recipes in  C, section
    15.2,  assuming a value  for 1  for all  errors sigma.   The hokey
    throwing  out of  points is  mine, though.   Also, I  reversed the
    meaning of a and b.  More natural for me, that way."""

    S = len(coords)
    Sx = sum([x for (x, y) in coords])
    Sy = sum([y for (x, y) in coords])
    Sxx = sum([x**2 for (x, y) in coords])
    Sxy = sum([x*y  for (x, y) in coords])
    delta = S*Sxx-Sx**2
    b, a = (Sxx*Sy - Sx*Sxy)/delta, (S*Sxy - Sx*Sy)/delta
    if not throwaway:
        return a, b, goodness(coords, a, b)
    assert (type(throwaway) == int) and (throwaway > 0)

    # Remove the most significant outlier
    coords.sort(key=lambda (x, y): difference(x, y, a, b))
    coords.pop()
    return regression(coords, throwaway-1)

