import sys

class Tee:

    """Present writeable file interface, with output split to multiple
    file  objects.

    Tee(fileobj) ->  fileobj2, with fileobj2.write  sending to fileobj
    and stdout.

    For later implementation:
    
    Tee(fileobj1, fileobj2,  [....]) -> fileobj0,  with fileobj0.write
    sending to all fileobj's passed to the constructor."""

    def __init__(self, *output):

        output = list(output)
        if len(output) == 0:
            raise TypeError, 'Requires at least one file object'
        if len(output) == 1:
            output.append(sys.stdout)
        self.fileobjs = output

    
    def write(self, output):

        for fileobj in self.fileobjs:
            fileobj.write(output)

    def flush(self):

        for fileobj in self.fileobjs:
            fileobj.flush()

    def close(self):

        for fileobj in self.fileobjs:
            fileobj.close()
