#!/usr/bin/env python

import sys, os, getopt
from pprint import pprint as pp
from pdb import set_trace as st

thisfile = sys.argv[0]
thisdir = os.path.dirname(os.path.realpath(thisfile))
packagedir = os.path.dirname(thisdir)
sys.path.append(packagedir)
sys.path.append(os.path.expanduser('~/repository'))

from tools.Sequences.files import Fasta_file
from RNA.MSARi.tests.general_test import score_msa
from RNA.MSARi.MSA.BaseMSA import BaseMSA

def usage():
    print >> sys.stderr, thisfile, '<fasta file> [--bfactor=<bonferroni factor>]'
    print >> sys.stderr, 'Print the MSARi score for the nucleotide alignment in <fasta file>.'
    sys.exit(1)

def main(iargs=sys.argv[1:]):
    opts, args = getopt.getopt(iargs, '',['bfactor='])
    if len(args) != 1:
        usage()
    fpath = args.pop()
    if not os.path.exists(fpath):
        usage()
    seqs = dict([t for t in Fasta_file(fpath)])
    if opts:
        if (len(opts) != 1) or (opts[0][0] != '--bfactor'):
            usage()
        try:
            BaseMSA.bonferroni_factor = float(opts[0][1])
        except ValueError:
            usage()
    elif len(seqs) == 10:
        BaseMSA.bonferroni_factor = 0.2
    elif len(seqs) == 15:
        BaseMSA.bonferroni_factor = 0.005
    print score_msa(seqs)

if __name__ == '__main__':
    main()
