class BasePair:

    def __init__(self, p1, p2, parent, window_length, children=None):

        self.p1, self.p2, self.parent = p1, p2, parent
        self.length = p2 - p1 - 1
        self.window_length = window_length
        if children is not None:
            self.children = children[:]
        else:
            self.children = []

    def find_parent(self, p1, p2):

        assert p1 < p2
        closest_approach = min(abs(p1 - self.p1), abs(p2 - self.p2))
        if closest_approach < self.window_length:
            return None
        if not (self.p1 < p1 < p2 < self.p2):
            return None
        
        for child in self.children:
            closest_approach = min(abs(p1 - child.p1),
                                   abs(p2 - child.p2))
            if closest_approach < self.window_length:
                return None
            if child.p1 < p1 < p2 < child.p2:
                return child.find_parent(p1, p2)
            if (p1 in (child.p1, child.p2)) or \
               (p2 in (child.p1, child.p2)) or \
               (p1 < child.p1 < p2 < child.p2) or \
               (child.p1 < p1 < child.p2 < p2):
                return None
        return self

    def valid_pair(self, p1, p2):

        return self.find_parent(p1, p2) is not None

    def add_child(self, p1, p2):

        self.find_parent(p1, p2)._add_child(p1, p2)

    def _add_child(self, p1, p2):

        grandchildren = []
        for child in self.children:
            assert not (child.p1 <= p1 <= child.p2)
            assert not (child.p1 <= p2 <= child.p2)
            if p1 < child.p1 < child.p2 < p2:
                grandchildren.append(child)
        newchild = BasePair(p1, p2, self, self.window_length,
                            grandchildren[:])
        for child in grandchildren:
            assert child in newchild.children
            self.children.remove(child)
        assert newchild not in self.children
        self.children.append(newchild)

    def number_pairs(self, maxsep):

        rv = (self.length**2 - max(self.length - maxsep, 0)**2)/2
        for child in self.children:
            child_mask_size = child.length**2
            child_mask_size -= max(child.length - maxsep, 0)**2
            child_mask_size /= 2
            rv += child.number_pairs(maxsep) - child_mask_size
        assert rv >= 0
        return rv

    def chosen_pairs(self):

        rv = [(self.p1, self.p2)]
        for child in self.children:
            rv.extend(child.chosen_pairs())
        return rv

class RNAStructure(BasePair):

    def __init__(self, length, window_length):

        BasePair.__init__(
            self, -window_length-1, length+window_length, None,
            window_length, None)


