"""Routines  for  converting   between  representations  of  secondary
structures."""

def stockholm_to_map(struc):

    """'struc'  should be  a parenthesis-based  representation  of the
    structure.   Returns  a list  the  length  of  the sequence  whose
    elements  contain either  None  or the  indices  of the  positions
    they're paired with."""

    strucmap = len(struc) * [None]
    open_parens = []
    for posidx, char in iterate(struc):
        if char in '<(':
            open_parens.append(posidx)
        elif char in '>)':
            matching_open = open_parens.pop()
            strucmap[matching_open] = posidx
            strucmap[posidx] = matching_open
    return strucmap

def stockholm_to_numeric(struc):

    """Convert  from the  stockholm, parenthetical  representation, to
    one where the matching helices have matching numbers/letters."""

    rv = len(struc) * ['.']

    # List of symbols we're going to use.
    import string
    helix_symbols = list(string.printable)
    helix_symbols.reverse()

    # The current symbol we should be using.
    helsym = helix_symbols.pop()
    
    # The collated positions of the open and close parens
    opens   = [op.start() for op in re.finditer('[<(]', struc)]

    strucmap = stockholm_to_map(struc)
    current_open = opens.pop(0)
    current_close = strucmap[current_open]
    rv[current_open] = rv[current_close] = helsym

    for openidx in opens:
        closeidx = strucmap[openidx]
        if (('>' in struc[current_open:  openidx]) or
            ('<' in struc[closeidx: current_close])):
            helsym = helix_symbols.pop()
        current_open, current_close = openidx, closeidx
        rv[current_open] = rv[current_close] = helsym
    return ''.join(rv)

if __name__ == '__main__':
    from RNA.structure import convert
    reload(convert)
    print convert.stockholm_to_numeric('<<<><>>>')
    
