def get_sequences():

    seqfilename = os.path.join(os.path.dirname(__file__),
                               'srprna_ali.widetext')
    seqfile = open(seqfilename)

    while not re.match('(\s+\d+)+\s+$', seqfile.readline()):
        pass

    sequences = {}

    seq_class = seqfile.readline().split('-')[1]
    while 1:
        assert seqfile.readline().startswith('pairmask')
        while 1:
            l = seqfile.readline()
            if not l: break
            if l.startswith('-'):
                seq_class = l.split('-')[1]
                break
            name, sequence = l.split()
            sequences.setdefault(seq_class, {})[name] = sequence
        if not l:
            break

    flat_sequences = {}
    for seq_class, class_sequences in sequences.items():
        for name, sequence in class_sequences.items():
            assert name not in flat_sequences
            flat_sequences[name] = sequence

    return sequences, flat_sequences

if __name__ == '__main__':
    from RNA.data.sequences import srp
else:
    sequences, flat_sequences = get_sequences()
