def get_sequences():

    alg_path = os.path.join(os.path.dirname(__file__),
                            'Frank-align.gb')
    alignments = [l.rstrip() for l in open(alg_path).readlines()]
    alignments = filter(None, alignments)

    sequences = {}

    while alignments:
        if alignments.count('//'):
            end = alignments.index('//')
            alignment = alignments[:end]
            alignments = alignments[end+1:]
        else:
            alignment = alignments
            alignments = []
        assert alignment[2].startswith('ORIGIN')
        sequence = re.sub('[0-9 ]*', '', ''.join(alignment[3:]))
        name = alignment[0].split()[1]
        length = int(re.search('([0-9]+) *bp', alignment[0]).groups()[0])
        if length != len(sequence):
            print 'warning: skipping %s as it seems to be the wrong length' % name
        else:
            sequences[name] = sequence
    return sequences

if __name__ == '__main__':
    from RNA.data.sequences import rnase
    reload(rnase)
else:
    sequences = get_sequences()
