#include "Python.h"
#include "arrayobject.h"
#include "tools/Sequences/_sequence.h"
#include "RNA/MSARi/MSA/tuples/_msa.h"

#define MAX_TUPLE_LENGTH 100

PyObject *msa5_longest_run(PyObject *self, PyObject *args) {

  char *s1, *s2, seq1[MAX_TUPLE_LENGTH], seq2[MAX_TUPLE_LENGTH];
  int len1, len2, start1, start2, longest, current_run1, current_run2;
  int offset, run_idx, seqidx, max_run, c1, c2;
  int min_tuple_length, max_tuple_length, best_offset=0;

  if (!PyArg_ParseTuple(args, "s#s#iiii",
			&s1, &len1, &s2, &len2, &start1, &start2,
			&min_tuple_length, &max_tuple_length)) {
    return NULL;
  }
  if ((max_tuple_length > MAX_TUPLE_LENGTH) ||
      (min_tuple_length > max_tuple_length)) {
    PyErr_Format(PyExc_ValueError,
		 "Last two arguments should be min and max tuple lengths.  min < max < %i",
		 MAX_TUPLE_LENGTH);
    return NULL;
  }
  for (seqidx = 0; seqidx < max_tuple_length; seqidx++) {
    seq1[seqidx] = _sequence_dna_char_num[(int)s1[start1+seqidx]];
    seq2[seqidx] = _sequence_dna_char_num[(int)s2[start2+max_tuple_length-1-seqidx]];
  }
  longest = 0;
  for (offset = 0; offset < max_tuple_length-min_tuple_length+1; offset++) {
    current_run1 = current_run2 = 0;
    max_run = max_tuple_length-offset;
    for (run_idx = 0; run_idx < max_run; run_idx++) {
      c1 = (int)seq1[run_idx];
      c2 = (int)seq2[run_idx+offset];
      if ((c1 != AA) && (c2 != AA) && (complements[c1][c2])) {
	current_run2++;
      } else {
	if (current_run2 > longest) {
	  longest = current_run2;
	  best_offset = offset;
	}
	current_run2 = 0;
      }
      if (offset > 0) {
	c1 = (int)seq1[run_idx+offset];
	c2 = (int)seq2[run_idx];
	if ((c1 != AA) && (c2 != AA) && (complements[c1][c2])) {
	  current_run1 ++;
	} else {
	  if (current_run1 > longest) {
	    longest = current_run1;
	    best_offset = -offset;
	  }
	  current_run1 = 0;
	}
      }
    }
    if (current_run1 > longest) {
      longest = current_run1;
      best_offset = -offset;
    }
    if (current_run2 > longest) {
      longest = current_run2;
      best_offset = offset;
    }
  }
  return Py_BuildValue("ii", longest, best_offset);
}

static PyMethodDef _msa5Methods[] = {
  {"longest_run",   msa5_longest_run,   METH_VARARGS},    
  {NULL, NULL}
};

void init_msa5(void) {
  (void)Py_InitModule("_msa5", _msa5Methods);
  import_array();
}
