#include "Python.h"
#include "arrayobject.h"
#include "tools/Sequences/_sequence.h"
#include "RNA/MSARi/MSA/tuples/_msa.h"

/* Uses definitions from mouse.sequences._sequencesmodule.c and
   mouse.rna.msa._msamodule.c */

PyObject *msa4_get_pair_odds(PyObject *self, PyObject *args) {

  PyArrayObject *pair_odds_dest, *single_odds;
  int length, i, j;
  float *pair_odds, *i_single_odds, *j_single_odds, current_odds;

  if (!PyArg_ParseTuple(args, "O!O!",
			&PyArray_Type, &pair_odds_dest,
			&PyArray_Type, &single_odds)) {
    return NULL;
  }
  if ((pair_odds_dest->nd != 2) || (single_odds->nd != 2)) {
    PyErr_SetString(PyExc_ValueError, "Should pass two-dimensional arrays");
    return NULL;
  }
  if ((pair_odds_dest->descr->type_num != PyArray_FLOAT) ||
      (single_odds->descr->type_num    != PyArray_FLOAT)) {
    PyErr_SetString(PyExc_ValueError, "Should pass arrays of floats");
    return NULL;
  }
  length = single_odds->dimensions[0];
  if ((pair_odds_dest->dimensions[0] != length) || \
      (pair_odds_dest->dimensions[1] != length) || \
      (single_odds->dimensions[1] != 4)) {
    PyErr_SetString(PyExc_ValueError, "Should pass a square array of size NxN, and an array of size Nx4");
    return NULL;
  }
  
  for (i = 0; i < length; i++) {
    pair_odds = (float *)(pair_odds_dest->data + i*(pair_odds_dest->strides[0]));
    i_single_odds = (float *)(single_odds->data + i*(single_odds->strides[0]));
    for (j = i; j < length; j++) {
      j_single_odds = (float *)(single_odds->data + j*(single_odds->strides[0]));
      current_odds = i_single_odds[DNA_A]*j_single_odds[DNA_T] + \
	i_single_odds[DNA_C]*j_single_odds[DNA_G] + \
	i_single_odds[DNA_G]*(j_single_odds[DNA_C] + j_single_odds[DNA_T]) + \
	i_single_odds[DNA_T]*(j_single_odds[DNA_A] + j_single_odds[DNA_G]);
      pair_odds[j] = current_odds;
    }
  }
  Py_INCREF(Py_None);
  return Py_None;
}

static PyMethodDef _msa4Methods[] = {
  {"get_pair_odds", msa4_get_pair_odds, METH_VARARGS},
  {NULL, NULL}
};

void init_msa4(void) {
  (void)Py_InitModule("_msa4", _msa4Methods);
  import_array();
}
