#include "Python.h"
#include "arrayobject.h"
#include "tools/Sequences/_sequence.h"
#include "RNA/MSARi/MSA/tuples/_msa.h"

#define MAX_TUPLE_LENGTH 100

/* Uses definitions from mouse.sequences._sequencesmodule.c and
   mouse.rna.msa._msamodule.c */

PyObject *msa3_longest_run(PyObject *self, PyObject *args) {

  char *s1, *s2, seq1[MAX_TUPLE_LENGTH], seq2[MAX_TUPLE_LENGTH];
  int len1, len2, start1, start2, longest, current_run1, current_run2;
  int offset, run_idx, seqidx, max_run, c1, c2;
  int min_tuple_length, max_tuple_length;

  if (!PyArg_ParseTuple(args, "s#s#iiii",
			&s1, &len1, &s2, &len2, &start1, &start2,
			&min_tuple_length, &max_tuple_length)) {
    return NULL;
  }
  if ((max_tuple_length > MAX_TUPLE_LENGTH) ||
      (min_tuple_length > max_tuple_length)) {
    PyErr_Format(PyExc_ValueError,
		 "Last two arguments should be min and max tuple lengths.  min < max < %i",
		 MAX_TUPLE_LENGTH);
    return NULL;
  }
  for (seqidx = 0; seqidx < max_tuple_length; seqidx++) {
    seq1[seqidx] = _sequence_dna_char_num[(int)s1[start1+seqidx]];
    seq2[seqidx] = _sequence_dna_char_num[(int)s2[start2+max_tuple_length-1-seqidx]];
  }
  longest = 0;
  for (offset = 0; offset < max_tuple_length-min_tuple_length+1; offset++) {
    current_run1 = current_run2 = 0;
    max_run = max_tuple_length-offset;
    for (run_idx = 0; run_idx < max_run; run_idx++) {
      c1 = (int)seq1[run_idx];
      c2 = (int)seq2[run_idx+offset];
      if ((c1 != AA) && (c2 != AA) && (complements[c1][c2])) {
	current_run2++;
      } else {
	if (current_run2 > longest) {
	  longest = current_run2;
	}
	current_run2 = 0;
      }
      if (offset > 0) {
	c1 = (int)seq1[run_idx+offset];
	c2 = (int)seq2[run_idx];
	if ((c1 != AA) && (c2 != AA) && (complements[c1][c2])) {
	  current_run1 ++;
	} else {
	  if (current_run1 > longest) {
	    longest = current_run1;
	  }
	  current_run1 = 0;
	}
      }
    }
    if (current_run1 > longest) {
      longest = current_run1;
    }
    if (current_run2 > longest) {
      longest = current_run2;
    }
  }
  return Py_BuildValue("i", longest);
}


PyObject *msa3_window_odds(PyObject *self, PyObject *args) {

  PyArrayObject *pair_odds;
  PyObject *rv, *py_odds;
  int posidx1, posidx2, seqidx, start1, start2, tuple_length, s2_pos;
  int min_tuple_length, max_tuple_length;
  float *_pair_odds[MAX_TUPLE_LENGTH];
  float current_odds, current_odds_sum;

  if (!PyArg_ParseTuple(args, "O!iiii",
			&PyArray_Type, &pair_odds, &posidx1, & posidx2,
			&min_tuple_length, &max_tuple_length)) {
    return NULL;
  }
  if ((max_tuple_length > MAX_TUPLE_LENGTH) ||
      (min_tuple_length > max_tuple_length)) {
    PyErr_Format(PyExc_ValueError,
		 "Last two arguments should be min and max tuple lengths.  min < max < %i",
		 MAX_TUPLE_LENGTH);
    return NULL;
  }
  if ((pair_odds->nd != 2) || \
      (pair_odds->dimensions[0] != pair_odds->dimensions[1]) || \
      (posidx1 >= pair_odds->dimensions[0]-max_tuple_length) || \
      (posidx2 >= pair_odds->dimensions[0]-max_tuple_length) || \
      (posidx1 < 0) || (posidx2 < 0) ||
      (pair_odds->descr->type_num != PyArray_FLOAT)) {
    PyErr_SetString(PyExc_ValueError, "arg 1 should be a square array of floats, and (arg2, arg3) should be positive indices into it.");
    return NULL;
  }
  if ((rv = PyList_New(max_tuple_length-min_tuple_length+1)) == NULL) {
    return NULL;
  }
  for (seqidx = 0; seqidx < max_tuple_length; seqidx++) {
    _pair_odds[seqidx] = (float *)(pair_odds->data + \
				   pair_odds->strides[0]*(posidx1+seqidx));
  }
  for (tuple_length = min_tuple_length; tuple_length <= max_tuple_length;
       tuple_length++) {
    current_odds_sum = 0;
    for (start1 = 0; start1 <= max_tuple_length-tuple_length; start1++) {
      for (start2 = 0; start2 <= max_tuple_length-tuple_length; start2++) {
	current_odds = 1;
	for (seqidx = 0; seqidx < tuple_length; seqidx++) {
	  s2_pos = posidx2+(max_tuple_length-1)-(start2+seqidx);
	  current_odds *= _pair_odds[start1+seqidx][s2_pos];
	}
	current_odds_sum += current_odds;
	if (current_odds_sum > 1) {
	  break;
	}
      }
      if (current_odds_sum > 1) {
	current_odds_sum = 1;
	break;
      }
    }
    if (!(py_odds = Py_BuildValue("f", current_odds_sum))) {
      Py_DECREF(rv);
      return NULL;
    }
    PyList_SET_ITEM(rv, tuple_length-min_tuple_length, py_odds);
  }
  return rv;
}

static PyMethodDef _msa3Methods[] = {
  {"longest_run",   msa3_longest_run,   METH_VARARGS},    
  {"window_odds",   msa3_window_odds,   METH_VARARGS},
  {NULL, NULL}
};

void init_msa3(void) {
  (void)Py_InitModule("_msa3", _msa3Methods);
  import_array();
}
