#include "Python.h"
#include "arrayobject.h"
#include "tools/Sequences/_sequence.h"
#include "RNA/MSARi/MSA/tuples/_msa.h"

/* Uses definitions from mouse.sequences._sequencesmodule.c and
   mouse.rna.msa._msamodule.c */

PyObject *longest_run(PyObject *self, PyObject *args) {

  char *s1, *s2, seq1[5], seq2[5];
  int len1, len2, start1, start2, longest, current_run1, current_run2;
  int offset, run_idx, seqidx, max_run, c1, c2;

  if (!PyArg_ParseTuple(args, "s#s#ii",
			&s1, &len1, &s2, &len2, &start1, &start2)) {
    return NULL;
  }
  for (seqidx = 0; seqidx < 5; seqidx++) {
    seq1[seqidx] = _sequence_dna_char_num[(int)s1[start1+seqidx]];
    seq2[seqidx] = _sequence_dna_char_num[(int)s2[start2+4-seqidx]];
  }
  longest = 0;
  for (offset = 0; offset < 3; offset++) {
    current_run1 = current_run2 = 0;
    max_run = 5-offset;
    for (run_idx = 0; run_idx < max_run; run_idx++) {
      c1 = (int)seq1[run_idx];
      c2 = (int)seq2[run_idx+offset];
      if ((c1 != AA) && (c2 != AA) && (complements[c1][c2])) {
	current_run2++;
      } else {
	if (current_run2 > longest) {
	  longest = current_run2;
	}
	current_run2 = 0;
      }
      if (offset > 0) {
	c1 = (int)seq1[run_idx+offset];
	c2 = (int)seq2[run_idx];
	if ((c1 != AA) && (c2 != AA) && (complements[c1][c2])) {
	  current_run1 ++;
	} else {
	  if (current_run1 > longest) {
	    longest = current_run1;
	  }
	  current_run1 = 0;
	}
      }
    }
    if (current_run1 > longest) {
      longest = current_run1;
    }
    if (current_run2 > longest) {
      longest = current_run2;
    }
  }
  return Py_BuildValue("i", longest);
}

PyObject *get_pair_odds(PyObject *self, PyObject *args) {

  PyArrayObject *pair_odds_dest, *single_odds;
  int length, i, j;
  float *pair_odds, *i_single_odds, *j_single_odds, current_odds;

  if (!PyArg_ParseTuple(args, "O!O!",
			&PyArray_Type, &pair_odds_dest,
			&PyArray_Type, &single_odds)) {
    return NULL;
  }
  if ((pair_odds_dest->nd != 2) || (single_odds->nd != 2)) {
    PyErr_SetString(PyExc_ValueError, "Should pass two-dimensional arrays");
    return NULL;
  }
  if ((pair_odds_dest->descr->type_num != PyArray_FLOAT) ||
      (single_odds->descr->type_num    != PyArray_FLOAT)) {
    PyErr_SetString(PyExc_ValueError, "Should pass arrays of floats");
    return NULL;
  }
  length = single_odds->dimensions[0];
  if ((pair_odds_dest->dimensions[0] != length) || \
      (pair_odds_dest->dimensions[1] != length) || \
      (single_odds->dimensions[1] != 4)) {
    PyErr_SetString(PyExc_ValueError, "Should pass a square array of size NxN, and an array of size Nx4");
    return NULL;
  }
  
  for (i = 0; i < length; i++) {
    pair_odds = (float *)(pair_odds_dest->data + i*(pair_odds_dest->strides[0]));
    i_single_odds = (float *)(single_odds->data + i*(single_odds->strides[0]));
    for (j = i; j < length; j++) {
      j_single_odds = (float *)(single_odds->data + j*(single_odds->strides[0]));
      current_odds = i_single_odds[DNA_A]*j_single_odds[DNA_T] + \
	i_single_odds[DNA_C]*j_single_odds[DNA_G] + \
	i_single_odds[DNA_G]*(j_single_odds[DNA_C] + j_single_odds[DNA_T]) + \
	i_single_odds[DNA_T]*(j_single_odds[DNA_A] + j_single_odds[DNA_G]);
      pair_odds[j] = current_odds;
    }
  }
  Py_INCREF(Py_None);
  return Py_None;
}

PyObject *window_odds(PyObject *self, PyObject *args) {

  PyArrayObject *pair_odds;
  int posidx1, posidx2, seqidx, start1, start2;
  float five_odds, four_odds, three_odds, *_pair_odds[5], current_odds;

  if (!PyArg_ParseTuple(args, "O!ii",
			&PyArray_Type, &pair_odds, &posidx1, & posidx2)) {
    return NULL;
  }
  if ((pair_odds->nd != 2) || \
      (pair_odds->dimensions[0] != pair_odds->dimensions[1]) || \
      (posidx1 >= pair_odds->dimensions[0]-5) || \
      (posidx2 >= pair_odds->dimensions[0]-5) || \
      (posidx1 < 0) || (posidx2 < 0) ||
      (pair_odds->descr->type_num != PyArray_FLOAT)) {
    PyErr_SetString(PyExc_ValueError, "arg 1 should be a square array of floats, and (arg2, arg3) should be positive indices into it.");
    return NULL;
  }
  for (seqidx = 0; seqidx < 5; seqidx++) {
    _pair_odds[seqidx] = (float *)(pair_odds->data + \
				   pair_odds->strides[0]*(posidx1+seqidx));
  }
  five_odds = 1;
  for (seqidx = 0; seqidx < 5; seqidx++) {
    five_odds *= _pair_odds[seqidx][posidx2+4-seqidx];
  }
  four_odds = five_odds;
  for (start1 = 0; start1 < 2; start1++){
    for (start2 = 0; start2 < 2; start2++) {
      current_odds = 1;
      for (seqidx = 0; seqidx < 4; seqidx++) {
	current_odds *= _pair_odds[start1+seqidx][posidx2+4-(start2+seqidx)];
      }
      four_odds += current_odds;
    }
  }
  if (four_odds > 1) {
    four_odds = 1;
  }
  three_odds = four_odds;
  for (start1 = 0; start1 < 3; start1++){
    for (start2 = 0; start2 < 3; start2++) {
      current_odds = 1;
      for (seqidx = 0; seqidx < 3; seqidx++) {
	current_odds *= _pair_odds[start1+seqidx][posidx2+4-(start2+seqidx)];
      }
      three_odds += current_odds;
    }
  }
  if (three_odds > 1) {
    three_odds = 1;
  }
  return Py_BuildValue("fff", three_odds, four_odds, five_odds);
}

static PyMethodDef _msa2Methods[] = {
  {"longest_run",   longest_run,   METH_VARARGS},
  {"get_pair_odds", get_pair_odds, METH_VARARGS},
  {"window_odds",   window_odds,   METH_VARARGS},
  {NULL, NULL}
};

void init_msa2(void) {
  (void)Py_InitModule("_msa2", _msa2Methods);
  import_array();
}
