class VarCount:

    """Keeps a  list of  binary-valued random variables,  and computes
    the probability that more than a certain number of them will yield
    'true'  from a single  sample of  all of  them, assuming  they are
    independant.  'Variables' are stored  simply as the probability of
    returning a true value."""

    def __init__(self, variables):

        self.variables = variables
        numvars = len(variables)

        # self.probs[lastvaridx, numtrue]  is the probability  that on
        # an independant  draw of  all the variables,  exactly numtrue
        # are true in the first lastvaridx+1 variables.
        self.probs = {}
        self.probs[0, 1] = self.variables[0]
        self.probs[0, 0] = 1-self.variables[0]
        for lastvaridx in range(1, numvars):
            p = self.probs[lastvaridx-1, 0]
            p *= 1-self.variables[lastvaridx]
            self.probs[lastvaridx, 0] = p
            for numtrue in range(1, lastvaridx+2):
                tprob = self.variables[lastvaridx]

                # Get  the probability  that there  are  numtrue trues
                # including the last.
                p = tprob * self.probs[lastvaridx-1, numtrue-1]

                # ...and  add the probability  that there  are numtrue
                # trues not including the last.
                if numtrue <= lastvaridx:
                    p += (1-tprob) * self.probs[lastvaridx-1, numtrue]
                self.probs[lastvaridx, numtrue] = p

        # self.significances[i]  is the  probability that  at  least i
        # variables come  up true on  an independant sample of  all of
        # them.    It's  computed   backwards,   then  reversed,   for
        # efficiency.
        self.significances = [self.probs[numvars-1, numvars]]
        
        for numtrue in range(numvars-1, -1, -1):
            p = self.significances[-1]
            p += self.probs[numvars-1, numtrue]
            self.significances.append(p)

        self.significances.reverse()
            
if __name__ == '__main__':

    from RNA.MSARi.MSA.Jaynes import count_prob
    reload(count_prob)
    t = count_prob.VarCount([0.5]*5)
    pp(t.significances)
