import RNA.structure.crude_structure
reload(RNA.structure.crude_structure)
from RNA.structure.crude_structure import RNAStructure
import sys, pdb

class BaseMSA:

    bonferroni_factor = 0.2

    def combined_odds(self, output=sys.stdout):
        matches = filter(lambda t: t[0] < 0.05, self.matches)
        self.structure = RNAStructure(self.lengths, self.winlength)
        prob = 1

        # Get as many pairs  as satisfy the constraint that constraint
        # that the "FDR" is at most 1.
        all_match_probs = []
        matches.sort()
        for s, (p1, p2) in matches:
            if s<(self.bonferroni_factor/(float(len(self.matches)))):
                all_match_probs.append((s, (p1, p2)))
            else:
                break

        # Greedily  combine these  pairs  into a  rough consensus  RNA
        # structure.
        for match_prob, (p1, p2)  in all_match_probs:
            if self.structure.valid_pair(p1, p2):
                prob *= match_prob
                self.structure.add_child(p1, p2)
                print >> output,  'New pair likelihood'
                print >> output,  p1, p2, match_prob
        return prob

    
