// Modified for new seq specs;

#include "tuples_tables.h"


main(int argc, char *argv[]) {
  cout << "Starting program Tuple Tables" << endl;
  int i=0,j=0,k=0;
  int MASK_REPEAT_TUPLES;
  char names[10][10] = { "Frame 0", "Frame 1", "Frame 2", "Introns", "NCExons", 
			 "ItoE", "EtoI", "CtoNC", "NCtoC", "Rest" };
  char filename[40]="dummy.TT";
  if (argc==2) {
    cout << "Attention: No output file specified." << endl;
    cout << "Results be saved in default file dummy.TT." << endl << endl;
  }
  else {
    strncpy(filename,argv[2],strlen(argv[2]));
    strncpy(filename+strlen(argv[2]),".TT", strlen(".TT"));
  }
  ofstream fout(filename);

  int l=0;
  while (l<=0) {
    cout << "Enter length of tuples: ";
    cin >> l;
    if (l<=0 || l>MAXPATTSZ) cout << "Invalid length entered." << endl;
  }
  int *skips = new int[l];
  cout << endl << "Enter array of skips: 1 for skip, 0 for no skip." << endl;
  cout << "SKIPS: ";
  int skipped=0; char dummychar='x';
  for (i=0; i<l; ++i) {
    cin >> dummychar;
    switch (dummychar) {
    case '0': skips[i]=0; break;
    case '1': skips[i]=1; skipped++; break;
    case 'a': skips[i]=(int)'a'; skipped++; break;
    case 'g': skips[i]=(int)'g'; skipped++; break;
    case 'c': skips[i]=(int)'c'; skipped++; break;
    case 't': skips[i]=(int)'t'; skipped++; break;
      
    default:
      cout << "WARNING: invalid entry" << skips[i] << "corrected." << endl;
      skips[i]=1;
      skipped++;
      break;
    }
  }
  int true_l = l-skipped;
  if (true_l<=0) {
    cout << "Bad skips array entered." << endl;
    exit(0);
  }
  cout << "Ignore Repeats ? (0==INCLUDE, 1==IGNORE)";
  cin  >> MASK_REPEAT_TUPLES;
  cout << endl << "Number of active positions: " << true_l << endl << endl;
  cout << "CREATING TABLE..." << endl;
  
  int economic = 0, **table;

  
  cout << "Economic (1), or full (0) table? ";
  cin >> economic;
  if (economic) table = economic_create_table(l,skips,argv[1], MASK_REPEAT_TUPLES);
  else          table =          create_table(l,skips,argv[1], MASK_REPEAT_TUPLES);
  
  int tsz = power(4,true_l);
  cout << endl;
  cout << "CREATED TABLE." << endl << endl;

  cout << endl;
  cout << "Total Number of Tuples in Each Category:" << endl;
  if (economic)
    cout << "Exons: " << table[0][tsz] << endl << "Introns: " << table[1][tsz];
  else 
    for (i=0; i<10; ++i)
      cout << names[i] << ": " << table[i][tsz] << endl;
  
  fout << "Length of tuples: " << l << endl;
  fout << "SKIPS:            ";
  for (i=0; i<l; ++i) {
    if (skips[i]==1) fout << "X ";
    else if (skips[i]) fout << ((char)skips[i]) << " ";
    else fout << ". ";
  }
  fout << endl << "Number of active positions: " << true_l << endl;
  fout << endl << endl;
  fout << endl;
  fout << "Total Number of Tuples in Each Category:" << endl;
  if (economic)
    fout << "Exons: " << table[0][tsz] << endl << "Introns: " << table[1][tsz];
  else 
    for (i=0; i<10; ++i)
      fout << names[i] << ": " << table[i][tsz] << endl;
  display_options();
  
  int continuation=1, option=0;
  while (continuation) {
    int verbose = 0;
    cout << "Enter Option: ";
    cin >> option;
    
    switch(option) {
    case -1:
      continuation = 0;
      break;
    case 0:
      display_options();
      break;
    case 6: {
      assert(!economic);
      char tablefile[100];
      cout << "Enter file to save table on: ";
      cin >> tablefile;
      strncpy(tablefile+strlen(tablefile),".FRAMETBL",strlen(".FRAMETBL"));
      int Scutoff=0, Wcutoff=0;
      double SfracE=0, SfracI=0, WfracE=0, WfracI=0;
      // Scutoff: strong signal minimum frequency;
      // SfracE:  strong signal maximum frequency in other frames: SfracE * Scutoff;
      // SfracI:  strong signal maximum frequency in introns: 10 * SfracI * Scutoff;
      do {
	cout << "Enter Strong Signal cutoff frequency: ";
	cin >> Scutoff;
      } while (Scutoff < 2);
      do {
	cout << "Enter Strong Signal maximum frequency fraction in other frames: ";
	cin >> SfracE;
      } while (SfracE >= 1);
      do {
	cout << "Enter Strong Signal maximum frequency fraction in introns: ";
	cin >> SfracI;
      } while (SfracI >= 1);
      do {
	cout << "Enter Weak Signal cutoff frequency: ";
	cin >> Wcutoff;
      } while (Wcutoff < 1 || Wcutoff > Scutoff);
      do {
	cout << "Enter Weak Signal maximum frequency fraction in other frames: ";
	cin >> WfracE;
      } while (WfracE > 1 || WfracE < SfracE);
      do {
	cout << "Enter Weak Signal maximum frequency fraction in introns: ";
	cin >> WfracI;
      } while (WfracI > 1 || WfracI < SfracI);
      ofstream fileftb(tablefile);
      fileftb << "Table for FrameHits" << endl;
      fileftb << "Length of tuples: " << l << endl;
      fileftb << "SKIPS:            ";
      for (i=0; i<l; ++i) {
	if (skips[i]==1) fileftb << "- ";
	else if (skips[i]) fileftb << nucl2char((Nucleotide)skips[i]) << " ";
	else fileftb << "x ";
      }
      fileftb << endl << "Number of active positions: " << true_l << endl;
      fileftb << "Strong Signal cutoffs: " << Scutoff << "  " << SfracE << "  " << SfracI << endl;
      fileftb << "Weak Signal cutoffs  : " << Wcutoff << "  " << WfracE << "  " << WfracI << endl;
      fileftb << "Table:" << endl;
      for (i=0; i<tsz; ++i)
	fileftb << frametablevalue(Scutoff,SfracE,SfracI,Wcutoff,WfracE,WfracI,table,i) << endl;
      cout << "Table Created" << endl;
      break;
    }
    case 7: {
      assert(!economic);
      char tablefl[100];
      cout << "Enter file to export table: ";
      cin >> tablefl;
      strncpy(tablefl+strlen(tablefl),".tupleTBL",strlen(".tupleTBL"));
      ofstream tupletbl(tablefl);
      assert(true_l > 2 && true_l < 11);
      tupletbl << l << endl;
      for (i=0; i<l; ++i) {
	if (skips[i]==1) tupletbl << "-";
	else if (skips[i]) tupletbl << nucl2char((Nucleotide)skips[i]) << "";
	else tupletbl << "x";
      }
      tupletbl << endl;
      for (i=0; i<4; ++i)
	tupletbl << table[i][tsz] << " ";
      tupletbl << endl;
      for (i=0; i<tsz; ++i) {
	for (j=0; j<4; ++j) tupletbl << table[j][i] << " ";
	tupletbl << endl;
      }
      cout << "Table Created" << endl;
      break;
    }

    case 8: {
      assert(!economic);
      char tablefl[100];
      cout << "Enter file to export table: ";
      cin >> tablefl;
      strncpy(tablefl+strlen(tablefl),".tupleRankTBL",strlen(".tupleRankTBL"));
      ofstream tupletbl(tablefl);
      assert(true_l > 2 && true_l < 11);
      tupletbl << l << endl;
      for (i=0; i<l; ++i) {
	if (skips[i]==1) tupletbl << "-";
	else if (skips[i]) tupletbl << nucl2char((Nucleotide)skips[i]) << "";
	else tupletbl << "x";
      }
      tupletbl << endl;
      for (i=0; i<4; ++i)
	tupletbl << tsz * (tsz-1) / 2 << " ";
      tupletbl << endl;

      int **indices = new (int*)[4], **tempTable = new (int*)[4];
      for (i=0; i<4; ++i) {
	tempTable[i] = new int[tsz];
	indices[i]   = new int[tsz];
	for (j=0; j<tsz; j++) {
	  indices[i][j]=j;
	  tempTable[i][j] = table[i][j];
	}
      }
      
      for (i=0; i<4; ++i)
	Quicksort(tempTable[i], indices[i], 0, tsz-1);
      int **trueIndices = new (int*)[4];
      for (i=0; i<4; ++i) {
	trueIndices[i] = new int[tsz];
	for (j=0; j<tsz;++j)
	  trueIndices[i][indices[i][j]] = j;
      }
      //       for (i=0; i<4; ++i)
      // 	for (j=0; j<tsz; ++j)
      // 	  for (int j2=j+1; j2<tsz; ++j2)
      // 	    if (trueIndices[i][j] > trueIndices[i][j2])
      // 	      assert(table[i][j] >= table[i][j2]);
      // 	    else assert(table[i][j] <= table[i][j2]);
      for (j=0; j<tsz; ++j) {
	for (i=0; i<4; ++i) {
	    tupletbl << trueIndices[i][j] << " ";
	}
	tupletbl << endl;
      }
      break;
    }
    case 5: {
      assert(!economic);
      int continuation5=1;
      while (continuation5) {
	cout << "Enter cutoff, or -1 to cancel: ";
	double cutoff5; cin >> cutoff5;
	if (cutoff5<0) break;
	fout << endl << endl
	     << "Statistics on where exactly the frequent patterns occur." << endl;
	fout << endl << "CUTOFF: " << cutoff5 << endl;
	cout << endl;
	cout << "Above " << cutoff5 << " in which type of regions ? " << endl;
	cout << "0: Frame 0;   1: Frame 1;   2: Frame 2; 3: Introns;" << endl;
	cout << "4: NC EXONS;  5: I to E;     6: E to I;    7: CtoNC" << endl;
	cout << "8: NCtoC;  9: Rest." << endl;
	cout << "-1: CANCEL." << endl;
	
	cout << endl << "Enter Now: ";
	int option5=0; cin >> option5;
	if (option5<0 || option5>9) {
	  cout << "Canceled" << endl;
	  fout << "Canceled" << endl;
	  break;
	}
	int freqnt_patt_cnt=0;
	int *statpointers = new int[tsz];
	for (i=0; i<tsz; ++i)
	  if (table[option5][i]>=cutoff5)
	    statpointers[i] = freqnt_patt_cnt++;
	  else statpointers[i]=-1;
	
	int **freqtbl = new (int*)[10];
	int overall_freqtbl[10];
	for (i=0; i<10; ++i) {
	  freqtbl[i]=new int[freqnt_patt_cnt];
	  overall_freqtbl[i]=0;
	}
	int *curr_occ_cnt = new int[freqnt_patt_cnt];
	double **avloctbl = new (double*)[10], *curr_avlocs = new double[freqnt_patt_cnt];
	double **devloctbl = new (double*)[10], *curr_devlocs = new double[freqnt_patt_cnt];
	for (i=0; i<10; ++i) {
	  avloctbl[i] = new double[freqnt_patt_cnt];
	  devloctbl[i] = new double[freqnt_patt_cnt];
	}
	for (j=0; j<10; ++j)
	  for (i=0; i<freqnt_patt_cnt; i++) {
	    curr_avlocs[i]=0; curr_devlocs[i]=0; curr_occ_cnt[i]=0;
	    freqtbl[j][i]=0; devloctbl[j][i]=0; avloctbl[j][i]=0;
	  }
	ifstream fin5(argv[1]);
	
	int marks5[MAXSEQLEN]; int index5=0;
	for (i=0; i<MAXSEQLEN; marks5[i++]=GARB);
	FilterSequence seq5; int seq_no5=0;
	cout << "Warning: this will take a while." << endl;
	while (fin5.good()) {
	  fin5 >> seq5;
	  seq_no5++;
	  
	  //	  if (seq_no5 == 120 || seq_no5 == 188 || seq_no5 == 191
	  //	      || seq_no5 == 213 || seq_no5 == 280) {
	  //	    continue;
	  //	  }
	
	  //	  if (seq5.get_fregion_num()<=2) {
	  //	    cout << seq5.get_fregion_num(); fflush(stdout);
	  //	    continue;
	  //	  }

	  if (MASK_REPEAT_TUPLES) {
	    cout << "*"; fflush(stdout); 
	    RepIdentify repIdObj;
	    vector<int> beginVec, endVec, regionVec;
	    vector<String> repeatVec;
	    repIdObj.rep_find(&seq5,beginVec, endVec, repeatVec, regionVec);
	    for (i=0; i<beginVec.size(); ++i)
	      for (j=beginVec[i]; j<=endVec[i]; ++j)
		seq5[j]=BASE_UNKNOWN;
	  }
	  else { cout << ":"; fflush(stdout); }
	  
	  
	  mark_sequence(seq5,l,marks5);
	
	  for (i=0; i<seq5.get_length(); ++i)
	    assert(marks5[i]<10);
	  int curr_mark5=-1; int curr_lend=0, curr_rend=0;
	
	  
	  int any_patt_occ=0;
	  for (i=0; i<=seq5.get_length()-l; ++i) {
	    if (i==1) {
	      curr_mark5=marks5[1];
	      if (curr_mark5<2) curr_mark5=2;
	    }
	    if (curr_mark5 != marks5[i]) 
	      if (curr_mark5 > 2 || marks5[i] > 2) {
		for (j=0; j<freqnt_patt_cnt; ++j) {
		  if (curr_occ_cnt[j]) {
		    if (curr_mark5<3) curr_mark5=2;
		    avloctbl[curr_mark5][j] += curr_avlocs[j]/ (double)curr_occ_cnt[j];
		    devloctbl[curr_mark5][j] += curr_devlocs[j]/ (double)curr_occ_cnt[j];
		  }
		  curr_avlocs[j]=curr_devlocs[j]=curr_occ_cnt[j]=0;
		}
		assert(curr_mark5>1);
		curr_lend = i;
		for (j=i+1; j<=seq5.get_length(); ++j)
		  if (marks5[j]!=marks5[i]) 
		    if (marks5[j] > 2 || marks5[i] > 2)
		      break;
		curr_rend=j-1;
		if (curr_rend<=curr_lend)
		  cout << "WARNING ! WE WANT TO EXAMINE *THIS*" << endl;
		curr_mark5=marks5[i]; if (curr_mark5<3) curr_mark5=2;
		any_patt_occ=0;
	      }
	    if (curr_rend>curr_lend) {
	      index5=tuple_to_index(i,l,seq5,skips);
	      if (statpointers[index5]>=0) {
		if (!any_patt_occ) {
		  any_patt_occ=1;
		  overall_freqtbl[curr_mark5]++;
		}
		if (!curr_occ_cnt[statpointers[index5]])
		  freqtbl[curr_mark5][statpointers[index5]]++;
		curr_occ_cnt[statpointers[index5]]++;
		double currloc=0;
		curr_avlocs[statpointers[index5]] += (currloc=((double)(i-curr_lend))/ ((double)(curr_rend-curr_lend)));
		curr_devlocs[statpointers[index5]] += MAX(.5-currloc,currloc-.5);
	      }
	    }
	  }
	}
	cout << endl;
	cout << "Tables show in how many regions pattern occurs," << endl;
	cout << " as well as what is the average location (fraction from beginning)," << endl;
	cout << " and average location deviation from middle." << endl;
	for (j=2; j<10; ++j) {
	  if (j==2) {
	    cout << "------------ FOR " << "Coding EXONS" << "------------" << endl;
	    fout << "------------ FOR " << "Coding EXONS" << "------------" << endl;
	  }
	  else {
	    cout << "------------ FOR " << names[j] << "------------" << endl;
	    fout << "------------ FOR " << names[j] << "------------" << endl;
	  }
	  int ptr5=0;
	  for (i=0; i<tsz; ++i) {
	    if ((ptr5=statpointers[i])>=0) {
	      char buffer5[MAXPATTSZ];
	      index_to_tuple(i,l,skips,buffer5);
	      cout << buffer5 << ": " << freqtbl[j][ptr5];
	      fout << buffer5 << ": " << freqtbl[j][ptr5];
	      if (freqtbl[j][ptr5]) {
		cout << "\t   " << avloctbl[j][ptr5]/freqtbl[j][ptr5]
		     << "\t   " << devloctbl[j][ptr5]/freqtbl[j][ptr5] << endl;
		fout << "\t   " << avloctbl[j][ptr5]/freqtbl[j][ptr5]
		     << "\t   " << devloctbl[j][ptr5]/freqtbl[j][ptr5] << endl;
	      }
	      else {
		cout << "\t   -           \t -  " << endl;
		fout << "\t   -           \t -  " << endl;
	      }
	    }
	  }
	  cout << "**** OVERALL OCCURS IN " << overall_freqtbl[j] << " REGIONS" << endl;
	  fout << "**** OVERALL OCCURS IN " << overall_freqtbl[j] << " REGIONS" << endl;
	}
	delete[] statpointers;
	for (i=0; i<10; ++i) {
	  delete[] freqtbl[i]; delete[] avloctbl[i]; delete[] devloctbl[i];
	} delete[] freqtbl; delete[] avloctbl; delete[] devloctbl;
	delete[] curr_occ_cnt; delete[] curr_avlocs; delete[] curr_devlocs;
      }
      break;
    }
    
    case 3:
      verbose = 1;
      cout << "Verbose: '-' denotes 0, '+' denotes 1." << endl;
    case 1: {
      int continuation1=1;
      while (continuation1) {
	if (verbose) cout << "(Verbose) ";
	cout << "Enter cutoff (-1 to cancel): ";
	double cutoff; cin >> cutoff;
	cout << "Enter exon upto cutoff (-1 for no cutoff)";
	int cutoffExon; cin >> cutoffExon;
	if (cutoffExon < 0) cutoffExon = 0;

	if (cutoff<0) break;
	fout << endl << endl << "Patterns occurring more times than cutoff." << endl;
	fout << endl << "CUTOFF: " << cutoff << endl;
	cout << endl;
	if (economic)
	  cout << "0: Exons;  1: Introns;" << endl;
	else {
	  cout << "0: Frame 0;   1: Frame 1;   2: Frame 2;" << endl;
	  cout << "3: INTRONS;   4: NC EXONS;  5: I to E;     6: E to I;" << endl;
	  cout << "7: C to NC;   8: NC to C;   9: Rest";
	  cout << "10: All Frames;  11: All except coding exons;" << endl;
	}
	cout << "-1: CANCEL." << endl;
	
	cout << endl << "Enter Now: ";
	int option1=0; cin >> option1;
	
	int views1[10];
	for (i=0; i<10; views1[i++]=0);
	switch (option1) {
	case 0: views1[0]=1; break;
	case 1: views1[1]=1; break;
	case 2: views1[2]=1; break;
	case 3: views1[3]=1; break;
	case 4: views1[4]=1; break;
	case 5: views1[5]=1; break;
	case 6: views1[6]=1; break;
	case 7: views1[7]=1; break;
	case 8: views1[8]=1; break;
	case 9: views1[9]=1; break;
	  
	case 10: views1[0]=views1[1]=views1[2]=1; break;
	case 11: views1[3]=views1[4]=views1[5]=views1[6]=views1[7]=views1[8]=views1[9]=1; break;
	case -1: continuation1=0; break;
	}
	if (economic) assert(option1 <= 1);

	int uptoCategory = (economic) ? 2 : 10;

	for (j=0; j<uptoCategory; ++j) 
	  if (views1[j]) {
	    if (economic) {
	      if (j==0) cout << " IN EXONS " << endl;
	      else      cout << " IN INTRONS " << endl;
	      if (j==0) fout << " IN EXONS " << endl;
	      else      fout << " IN INTRONS " << endl;
	    }
	    else {
	      cout << "------------ In " << names[j] << "------------" << endl;
	      fout << "------------ In " << names[j] << "------------" << endl;
	    }
	    if (verbose) {
	      cout << "Pattern:      ";
	      fout << "Pattern:      ";
	      for (k=10; k<l; ++k) {
		cout << " "; fout << " ";
	      }
	      if (economic) {
		if (j==0) cout << " EXONS " << endl;
		else      cout << " INTRONS " << endl;
		if (j==0) fout << " EXONS " << endl;
		else      fout << " INTRONS " << endl;
	      }
	      else {
		cout << names[j] << "\t";
		fout << names[j] << "\t";
	      }
	      if (!economic) {
		for (k=0; k<10; ++k)
		  if (k!=j) {
		    cout << names[k] << "\t";
		    fout << names[k] << "\t";
		  }
	      }
	      cout << endl; fout << endl;
	    }

	    int totals_above[10];
	    for (i=0; i<10; totals_above[i++]=0);

	    for (i=0; i<tsz; ++i)
	      if (table[j][i]>=cutoff && (!cutoffExon || table[0][i] <= cutoffExon)) {
		char patt[MAXPATTSZ];
		index_to_tuple(i,l,skips,patt);
		if (verbose) {
		  totals_above[j] += table[j][i];
		  cout << patt << " :  " << table[j][i];
		  fout << patt << " :  " << table[j][i];
		  for (k=0; k<uptoCategory; ++k)
		    if (k!=j) {
		      totals_above[k] += table[k][i];
		      cout << "     \t";
		      fout << "     \t";
		      if (table[k][i]>1) {
			cout << table[k][i];
			fout << table[k][i];
		      }
		      else if (table[k][i]) {
			cout << "+"; fout << "+";
		      }
		      else {
			cout << "-"; fout << "-";
		      }
		    }
		  cout << endl;
		  fout << endl;
		}
		else {
		  cout << patt << " :  " << table[j][i] << endl;
		  fout << patt << " :  " << table[j][i] << endl;
		}
	      }
	    if (verbose) {
	      cout << "Totals:" << endl;
	      fout << "Totals:" << endl;
	      for (i=0; i<uptoCategory; ++i) {
		if (economic) {
		  if (i==0) {
		    cout << "Exons: " << totals_above[0] << endl;
		    fout << "Exons: " << totals_above[0] << endl;
		  }
		  else {
		    cout << "Introns: " << totals_above[1] << endl;
		    fout << "Introns: " << totals_above[1] << endl;
		  }
		}
		else {
		  cout << names[i] << ":  " << totals_above[i] << endl;
		  fout << names[i] << ":  " << totals_above[i] << endl;
		}
	      }
	    }
	  }
      }
      break;
    }
    case 2: {
      assert(!economic);
      int patt[l];
      char dummychar;
      cout << "Enter pattern, using spaces between bases: ";
      for (i=0; i<l; ++i) {
	cin >> dummychar;
	switch (dummychar) {
	case 'a': patt[i]=0; break;
	case 'c': patt[i]=1; break;
	case 'g': patt[i]=2; break;
	case 't': patt[i]=3; break;
	default:
	  if (!skips[i]) cout << "Warning: invalid base entered" << endl;
	  patt[i]=0; break;
	}
      }
      int index2 = tuple_to_index(l,patt,skips);
      char buff[MAXPATTSZ];
      index_to_tuple(index2,l,skips,buff);
      cout << endl << buff << " occurs with the folowing frequencies: " << endl;
      fout << endl << endl << endl << buff << " occurs with the folowing frequencies: " << endl;
      for (j=0; j<10; ++j) {
	fout << "In " << names[j] << " : " << table[j][index2] << endl;
	cout << "In " << names[j] << " : " << table[j][index2] << endl;
      }
      cout << endl; fout << endl << endl << endl;
      break;
    }
    case 4: {
      assert(!economic);
      cout << endl << "Please note that this may be slow." << endl;
      cout << "Enter cutoff: ";
      int singlecutoff=0;
      cin >> singlecutoff;
      
      cout << "Currently only available for:" << endl;
      cout << "0. Introns;" << endl;
      cout << "Enter now: ";
      int choice4=0;
      cin >> choice4;
      do {
	if (choice4==-1) break;
      }
      while (choice4);
      if (choice4==-1) break;
      if (choice4) break;

      int frequent_table_l=0;
      int *frequent_patterns = new int[tsz];

      for (i=0; i<tsz; frequent_patterns[i++]=-1);
      
      for (i=0; i<tsz; ++i)
	if (table[3][i]>=singlecutoff)
	  frequent_patterns[i] = frequent_table_l++;

      int *current_patterns=new int[frequent_table_l], cpptr=0;
      int *fp_indices = new int[frequent_table_l];

      for (i=0; i<tsz; ++i)
	if (frequent_patterns[i]>0) fp_indices[frequent_patterns[i]] = i;
      
      int **pair_freq_matrix = new (int*)[frequent_table_l];
      for (i=0; i<frequent_table_l; ++i) {
	pair_freq_matrix[i] = new int[frequent_table_l];
	for (j=0; j<frequent_table_l; pair_freq_matrix[i][j++]=0);
      }
      
      ifstream fin4(argv[1]);
      
      int marks[MAXSEQLEN];
      for (i=0; i<MAXSEQLEN; marks[i++]=GARB);
      FilterSequence seq4;     
      int seq_no4=0;
      cout << " Frequent table length: " << frequent_table_l << endl;
      cout << "  l is " << l << endl;
      cout << " entering loop" << endl;
      
      while (fin4.good()) {
	fin4 >> seq4;
	seq_no4++;

	//	if (seq_no4 == 120 || seq_no4 == 188 || seq_no4 == 191
	//	    || seq_no4 == 213 || seq_no4 == 280) {
	//	  continue;
	//	}
	
	//	if (seq4.get_fregion_num()<=2) {
	//	  cout << seq4.get_fregion_num(); fflush(stdout);
	//	  continue;
	//	}
	

	cout << "."; fflush(stdout);
	mark_sequence(seq4,l,marks);
	
	for (i=0; i<seq4.get_length(); ++i)
	  assert(marks[i]<10);
	
	int index4=0;
	for (i=0; i<frequent_table_l; current_patterns[i++]=0);
	int current_mark=0;
	
	
	for (i=0; i<seq4.get_length(); ++i) {

	  switch (marks[i]) {
	  case 3:
	    
	    switch (current_mark) {
	    case 0: case 1: case 2: case 4: case 5: case 6: case 7: case 8: case 9:
	      for (j=0; j<frequent_table_l; current_patterns[j++]=0);
	      cpptr=0;
	      current_mark=3;
	    case 3:
	      index4=tuple_to_index(i,l,seq4,skips);
	      if (frequent_patterns[index4] < 0) break;
	      int found4=0;
	      for (j=0; j<cpptr; ++j)
		if (current_patterns[j]==index4) found4=1;
	      if (!found4) {
		current_patterns[cpptr++]=index4;
	      }
	      break;
	    }
	    break;
	  default:
	    switch (current_mark) {
	    case 3:
	      for (j=0; j<cpptr; ++j)
		for (k=j+1; k<cpptr; ++k) {
		  int idx1=0,idx2=0;
		  idx1=frequent_patterns[current_patterns[j]];
		  idx2=frequent_patterns[current_patterns[k]];
		  assert(idx1<frequent_table_l && idx2<frequent_table_l);
		  pair_freq_matrix[idx1][idx2]++;
		}
	      for (j=0; j<frequent_table_l; current_patterns[j++]=0);
	      assert(cpptr<=frequent_table_l);
	      cpptr=0;
	      current_mark=marks[i];
	      break;
	    }
	  }
	}
      }
      cout << " matrix is " << frequent_table_l << "x" << frequent_table_l << endl;
      cout << " Do you want to set cutoff and see the pair frequencies ?" << endl;
      cout << " Enter cutoff, -1 to cancel: ";
      int ctffinal=0;
      cin >> ctffinal;
      while (ctffinal!=-1) {
	if (ctffinal>0) {
	  
	  fout << "tuple FREQUENCIES ABOVE " << singlecutoff << endl;
	  fout << "PAIR FREQUENCIES ABOVE " << ctffinal << endl;
	  for (i=0; i<frequent_table_l; ++i)
	    for (j=i+1; j<frequent_table_l; ++j) {
	      if (pair_freq_matrix[i][j]>=ctffinal) {
		char buffer41[MAXPATTSZ], buffer42[MAXPATTSZ];
		index_to_tuple(fp_indices[i],l,skips,buffer41);
		index_to_tuple(fp_indices[j],l,skips,buffer42);
		cout << buffer41 << "  ,  " << buffer42 <<  "  in " << pair_freq_matrix[i][j]
		     << " introns." << endl;
		fout << buffer41 << "  ,  " << buffer42 <<  "  in " << pair_freq_matrix[i][j]
		     << " introns." << endl;
	      }
	    }
	}
	cout << " Enter new cutoff, -1 to cancel: ";
	cin >> ctffinal;
      }
            
      delete[] frequent_patterns; delete[] current_patterns;
      delete[] fp_indices;
      
      for (i=0; i<frequent_table_l; ++i)
	delete[] pair_freq_matrix[i];
      
      delete[] pair_freq_matrix;
      cout << "done with case 4" << endl;
      break;
    }
    default:
      cout << "Invalid option entered. Press 0 for help." << endl << endl; 
      break;
    }
  }
}









