#ifndef __TREE_H__
#define __TREE_H__

#include <fstream.h>
#include "seq.h"
#include "quads.h"


// Class Branch defines a branch of the Tree

class Branch {

 public: 

  Branch(int arraysize); 
  ~Branch();

  void addToCount(Nucleotide n, int index);
  void computeProbs(); 
  double getProb(Nucleotide n, int index);
  double getCount(Nucleotide n, int index);

  friend istream& operator>>(istream& cin, Branch& b);
  friend ostream& operator<<(ostream& cout, Branch& b);

  bool leaf;
  int size, count, indexOfNuc;
  Branch *left, *right;  
  Nucleotide branchRightOn1, branchRightOn2;

 protected:

  QProb **probtable;
};



// Class Tree defines a decision tree

class Tree {

 public: 

  Tree(int maxArraySize);
  ~Tree();
  
  void createTree(Nucleotide *nucs, long length);
  void copyTree(Tree *tree, Nucleotide *nucs, long length);
  void computeProb(Nucleotide tides[], double &probability);
  
  // Operator aliases
  friend istream& operator>>(istream& cin, Tree& tree);
  friend ostream& operator<<(ostream& cout, Tree& tree);
  
  int size;
  Branch *root;

 protected:

  void chi_squared(Nucleotide *nucs, long length, Nucleotide *consensus, 
		   double *values);
  void recursiveFormTree(Nucleotide *nucs, long length, Branch *branch, 
			 Nucleotide *consensus, bool seen[]);
  void recursiveCopy(Branch *thisbranch, Branch *thatbranch, Nucleotide *nucs,
		     long length, bool seen[]);
};

#endif

