#include <fstream.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "modules.h"


// This program reads in a table generate by exonPairs (in the exonStatFout.txt)
// file and makes from it a latex file.

main(int argc, char *argv[]) {
  
  ifstream tableFile("/data2/rosetta/results/mouse/exonStatFout.txt");
  ofstream latexFile("/data2/rosetta/output/exonStatFout.tex");
  
  int lengthsh[30],lengthsm[30],answers[30], i;
  double dna[30],protein[30];
  int numberh=0; // number of exons
  int numberm=0;
  String human,mouse;
  int counter=-1;
  
  // Prepare latex file
  latexFile << "\\documentstyle[rotate,11pt]{article}" << endl;
  latexFile << "\\begin{document}" << endl;
  latexFile << "\\pagestyle{empty}" << endl;
  
  while (tableFile.good()){
    counter++;
    if (counter%10==0){
      if (counter>0){
	latexFile << "\\hline " << endl;
	latexFile << "\\end{tabular}" << endl;
	latexFile << "\\end{minipage}}" << endl;
	latexFile << "\\newpage" << endl;
      }
      latexFile << "\\tiny" << endl;
      latexFile << "\\rotate{\\begin{minipage}{8in}" << endl;
      latexFile << "\\begin{tabular}{|l|l|l|";
      for (i=0; i<19; i++)
	latexFile << "l";
      latexFile << "}" << endl;
    }
    latexFile << "\\hline " << endl;
    tableFile >> human; tableFile >> numberh;
    latexFile << "{\\bf " << human << "} " << "&" << numberh << "&";
    for (i=0; i<numberh+1; i++){
      tableFile >> lengthsh[i]; 
      latexFile << lengthsh[i] << "&";
    }
    latexFile << "\\\\" << endl;
    
    tableFile >> mouse; tableFile >> numberm;
    latexFile << "{\\bf " << mouse << "} " << "&" << numberm << "&";
    for (i=0; i<numberm+1; i++){
      tableFile >> lengthsm[i]; 
      latexFile << lengthsm[i] << "&";
    }
    
    latexFile << "\\\\" << endl;
    latexFile << "DNA \\% & &";
    for (i=0; i<numberh+1; i++){
      tableFile >> dna[i];
      latexFile << dna[i] << "&";
    }
    
    latexFile << "\\\\" << endl;
    latexFile << "Protein \\% & &";
    
    for (i=0; i<numberh+1; i++){
      tableFile >> protein[i];
      latexFile << protein[i] << "&";
    }
    
    latexFile << "\\\\" << endl;
    latexFile << "Predictions & & &";
    
    for (i=0; i<numberh; i++){
      tableFile >> answers[i];
      if (answers[i]==1)
	latexFile << " $\\surd$ ";
      if (answers[i]==0)
	latexFile << " $\\times$  ";
      if (answers[i]==2)
	latexFile << " $\\surd - \\times$ ";
      if (answers[i]==4)
	latexFile << " $\\times - \\surd$ ";
      if (answers[i]==8)
	latexFile << " $\\times - \\times$ ";
      if (answers[i]==64)
	latexFile << " $\\times - \\times$ ";
	
      latexFile << "&";
    }
    latexFile << "\\\\" << endl;
  }
  
  // Terminate latex file
  latexFile << "\\hline " << endl;
  latexFile << "\\end{tabular}" << endl;
  latexFile << "\\end{minipage}}" << endl;
  latexFile << "\\end{document}" << endl;
}




