// C++ interface file

#ifndef __STATEVAL_H__
#define __STATEVAL_H__

#include "eval.h"
#include "seq.h"
#include "gseq.h"
#include "fseq.h"

#include "common.h"

#include "cluster.h"
#include "hameval.h"
#include "pyrtab.h"
#include "counttab.h"

#include <math.h>
#include "vector.h"
#include "splice.h"


#define INF HUGE_VAL
#define Infinity INF

#define LOW_SCORE -10000


// This is the interface of an evaluator class

class StatEvaluator {
  
  int from, to, smallFrom, smallTo;
  double alpha;
  
  HamEvaluator *hamEval0, *hamEval1, *hamEval2;
  ClusterSpace *cs1;

  Splice *AG, *GT;
  
 public:

  StatEvaluator();
  ~StatEvaluator();

  int evaluateStarts(FilterSequence *seq, double *scores, int*, int);
  int evaluateStops( FilterSequence *seq, double *scores, int*, int);

  // Deprecated!
  double burgeEvalAG(FilterSequence *seq, int pos, double &score1, double &score2, double &score3);
  double burgeEvalGT(FilterSequence *seq, int pos, double &score1, double &score2);

  void initializeBurge(ifstream &trainingFile, bool isAG) {
    if (isAG) {
      AG = new Splice(TRUE);
      trainingFile >> *AG;
    }
    else {
      GT = new Splice(FALSE);
      trainingFile >> *GT;
    }
    assert(AG || GT);
  }
};

extern ofstream stopsPass;

double scale(double,double,double);

#endif // __STATEVAL_H__


