// C++ code file

#include "stateval.h"

#include <math.h>
#include <assert.h>
#include <fstream.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>


StatEvaluator::StatEvaluator() {

  this->alpha=1;
  
  ifstream fstop("/data/tables/SpliceSites/startcounts.bin"), fstart("/data/tables/SpliceSites/stopcounts.bin");
  //  StopTab     = new countTable(fstop);
  //  NoStopTab   = new countTable(fstop);
  //  StartTab    = new countTable(fstart);
  //  NoStartTab  = new countTable(fstart);
  fstop.close();
  fstart.close();

  cs1 = new ClusterSpace;

  hamEval0 = new HamEvaluator(0);
  hamEval1 = new HamEvaluator(1);
  hamEval2 = new HamEvaluator(2);

  AG = 0;
  GT = 0;
}


StatEvaluator::~StatEvaluator() {

  delete hamEval0;
  delete hamEval1;
  delete hamEval2;
  
  delete cs1;

  if (AG) delete AG;
  if (GT) delete GT;
};


int LENIENT = 0; // 0, 1, or 2;

int StatEvaluator::evaluateStarts(FilterSequence *seq, double *scores, int *trueStarts, int tsc) {
  int i,j, seql = seq->get_length();

  arrayInit(-Infinity, scores, seql);
  int *startptr = new int[seql];  arrayZero(startptr, seql);
  int *leftnuc  = new int[seql];  arrayZero(leftnuc,  seql);
  int *rightnuc = new int[seql];  arrayZero(rightnuc, seql);
  int startcnt = 0;

  for (i=41; i<=seql-6; ++i)
    if (seq->get(i-2)==BASE_A && seq->get(i-1)==BASE_G) {
      startptr[startcnt] = i;
      leftnuc[startcnt]  = seq->get(i-3);
      rightnuc[startcnt] = seq->get(i);
      startcnt++;
    }
  
  PyrTable pt;
  
  for (i=0; i<startcnt; ++i) {
    
    double dummy1, dummy2;
    burgeEvalAG(seq, startptr[i], dummy1, dummy2, scores[startptr[i]]);
    switch (LENIENT) {
    case 0:
      continue;
      break;
    case 1: 
      if (scores[startptr[i]] < -4.8) scores[startptr[i]] = -Infinity;
      if (i>=1)
	if (scores[startptr[i]] < scores[startptr[i-1]] &&
	    startptr[i] - startptr[i-1] < 18)
	  scores[startptr[i]] = -Infinity;
      continue;
      break;
    case 2:
      if (scores[startptr[i]] < -3.5) scores[startptr[i]] = -Infinity;
      if (dummy2 < -3.5)              scores[startptr[i]] = -Infinity;
      if (i>=1)
	if (scores[startptr[i]] < scores[startptr[i-1]] &&
	    startptr[i] - startptr[i-1] < 20 &&
	    scores[startptr[i]] < 5)
	  scores[startptr[i]] = -Infinity;
      continue;
      break;
    case 3:
      if (scores[startptr[i]] < -4.5) scores[startptr[i]] = -Infinity;
      if (i>=1)
	if (scores[startptr[i]] < scores[startptr[i-1]] && startptr[i] - startptr[i-1] < 18)
	  scores[startptr[i]] = -Infinity;

      if (i>1 && (startptr[i] - startptr[i-2] <= 14) && scores[startptr[i]] < 5 &&
	  (leftnuc[i] != BASE_C || (rightnuc[i] != BASE_A && rightnuc[i] != BASE_G)))
	scores[startptr[i]] = -Infinity;

      if (i>=1 && leftnuc[i] == BASE_A && startptr[i] - startptr[i-1] < 30 && scores[startptr[i]] < 0)
	scores[startptr[i]] = -Infinity;
      continue;
      break;
    }
    continue;
    
    int isTrue = 0;
    for (j=0; j<tsc; ++j)
      if (trueStarts[j] == startptr[i]) {
	cout << "  true start " << startptr[i] << " detected." << endl;
	isTrue = 1;
      }
    if (leftnuc[i] == BASE_G) {
      int pyrt = pt.countPyr(seq,startptr[i]);
      if (pyrt < 15) {
	GAGbadPyr++;
	AGGoodRules[11]++;
	if (isTrue) {
	  AGfn << startptr[i] << "\t rule 0\t" << pyrt << endl;
	}
	continue;
      }
    }
    if (i>1 && (startptr[i] - startptr[i-2] <= 14) &&
	(leftnuc[i] != BASE_C || (rightnuc[i] != BASE_A && rightnuc[i] != BASE_G))) {
      if (isTrue) {
	AGfn << startptr[i] << "\t rule 1" << endl;
      }
      AGGoodRules[0]++;
      
      continue;
    }
    
    if (i < startcnt-1 && (leftnuc[i] == BASE_A || leftnuc[i] == BASE_G) && 
	(leftnuc[i+1] == BASE_C | leftnuc[i+1] == BASE_T) &&
	startptr[i+1] - startptr[i] < 5) {
      if (isTrue) {
	AGfn << startptr[i] << "\t rule 2" << endl;
      }
      AGGoodRules[1]++;
      
      continue;
    }
    if (i>0) {
      if ((leftnuc[i] == BASE_A || leftnuc[i] == BASE_G) &&
	  ( ( startptr[i] - startptr[i-1] <= 17)                               ||
	    
	    ( startptr[i] - startptr[i-1] <= 24 && 
	      ( (leftnuc[i-1] == BASE_C && pt.countPyr(seq,startptr[i]) < 13)  ||
		(rightnuc[i] == BASE_C || rightnuc[i] == BASE_T))))) {
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 3" << endl;
	  AGGoodRules[2]++;
	
	continue;
      }
      if (leftnuc[i] == BASE_T && 
	  ( (startptr[i] - startptr[i-1] <= 12)            ||
	    (startptr[i] - startptr[i-1] <= 17 &&
	     rightnuc[i] == BASE_C)) ) {
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 4" << endl;
	  AGGoodRules[3]++;
       
	continue;
      }
      if (leftnuc[i] == BASE_C)
	if (pt.countAG(seq,startptr[i]) > 2) {
	  if (isTrue)
	    AGfn << startptr[i] << "\t rule 6" << endl;
	  AGGoodRules[5]++;
	 
	  continue;
	}
	else if (rightnuc[i] != BASE_G && rightnuc[i] != BASE_A && leftnuc[i-1] == BASE_C &&
		 rightnuc[i-1] == BASE_G &&
		 (startptr[i]-startptr[i-1] < 20)) {
	  if (isTrue)
	    AGfn << startptr[i] << "\t rule 5" << endl;
	  AGGoodRules[4]++;
	  
	  continue;
	}
      scores[startptr[i]] = pt.countPyr(seq,startptr[i]);
      
      if (scores[startptr[i]] < 8) {
	scores[startptr[i]] = -Infinity;
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 7" << endl;
	AGGoodRules[6]++;
	
	continue;
      }
      else if (scores[startptr[i]] < 12 && (leftnuc[i] == BASE_A || leftnuc[i] == BASE_G))  {
	scores[startptr[i]] = -Infinity;
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 8" << endl;
	  AGGoodRules[7]++;
       
	continue;
      }
      else if (scores[startptr[i]] < 9  && leftnuc[i]  == BASE_T)           {
	scores[startptr[i]] = -Infinity;
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 9" << endl;
	  AGGoodRules[8]++;
	
	continue;
      }  
      else if (scores[startptr[i]] < 11 && rightnuc[i] == BASE_C)            {
	scores[startptr[i]] = -Infinity;
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 10" << endl;
	  AGGoodRules[9]++;
       
	continue;
      }  
      else if (scores[startptr[i]] < 11 && rightnuc[i] == BASE_T
	       && pt.countGA(seq,startptr[i]) > 0 && leftnuc[i] != BASE_C)   {
	scores[startptr[i]] = -Infinity;
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 11" << endl;
	  AGGoodRules[10]++;
       
	continue;
      }  
      else if (scores[startptr[i]] < 15 && leftnuc[i]  == BASE_A && 
	       (rightnuc[i] == BASE_C || 
		(rightnuc[i] != BASE_G && seq->get(i+1) == BASE_A)))          {
	scores[startptr[i]] = -Infinity;
	if (isTrue)
	  AGfn << startptr[i] << "\t rule 12" << endl;
	AGGoodRules[11]++;
	
	continue;
      }
      
      if (scores[startptr[i]] > -Infinity) {
	switch (rightnuc[i]) {
	case BASE_C: scores[startptr[i]] = 1; break;
	case BASE_T: scores[startptr[i]] = 2; break;
	case BASE_A: scores[startptr[i]] = 3; break;
	case BASE_G: scores[startptr[i]] = 4; break;
	}
	switch (leftnuc[i]) {
	case BASE_G: scores[startptr[i]]+=  0; break;
	case BASE_A: scores[startptr[i]]+=  4; break;
	case BASE_T: scores[startptr[i]]+=  8; break;
	case BASE_C: scores[startptr[i]]+= 12; break;
	}
      }
    }
  }
  AGeff << AGGoodRules[11] << " (" << GAGbadPyr << ") " ;
  
  for (i=0; i<11; ++i) {
    AGeff << AGGoodRules[i] << " ";
  }
  cout << endl;
  AGeff << endl;
  delete[] startptr;
  delete[] leftnuc;
  delete[] rightnuc;

  return 1;
}

int StatEvaluator::evaluateStops(FilterSequence *seq, double *scores, int *trueStops, int tsc) {
  int i,j, seql = seq->get_length();
  
  arrayInit(-Infinity, scores, seql);
  int *stopptr = new int[seql];  arrayZero(stopptr, seql);
  int *ham0    = new int[seql];  arrayZero(ham0,    seql);
  int *ranks   = new int[seql];  arrayZero(ranks,   seql);
  int stopcnt  = 0;

  ClusterSpace cs1;
  HamEvaluator hEval0(0), hEval1(1), hEval2(2);
  rankTable rt("/data/tables/SpliceSites/rank_istart.bin");

  for (i=22; i<seql-10; ++i)
    if (seq->get(i+1)==BASE_G && seq->get(i+2)==BASE_T) {
      stopptr[stopcnt] = i;
      /* exonLengths
      ham0[stopcnt]    = hEval0.evaluate(seq, i+1);
      ranks[stopcnt]   = rt.rank(seq, i);
      */
      stopcnt++;
    }
  
  for (i=0; i<stopcnt; ++i) {
    int pos = stopptr[i];
    
    /*exonLengths
    int dist[8];
    for (j=1; j<=8; ++j)
      if (i-j>=0) dist[j-1] = pos - stopptr[i-j];
      else dist[j-1] = 10000;
    */

    /* exonLengths
    int isTrue = 0;
    for (j=0; j<tsc; ++j)
      if (trueStops[j] == pos) {
	isTrue = 1;
      }
    */

    double burgeScore1=-1000, burgeScore2=-1000;
    burgeEvalGT(seq, pos, burgeScore1, burgeScore2);
    if (burgeScore2 < -5.5) { // Was -6.2;
      /*
	if (isTrue) GTfn << stopptr[i] << "\t Burge Rule" << endl;
	GTGoodRules[21]++;
      */
      
      //      continue;
    }
    
    
    /* exonLengths
    if (i < stopcnt-1 && stopptr[i+1] - pos < 60 && 
	( (ranks[i+1] == 1 && ham0[i] > 9) ||
	  (ranks[i+1] == 2 && ranks[i] > 2))) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 1" << endl;
      GTGoodRules[0]++;
     
      continue;
    }
    */
    /* Removed January 16;
       if (i < stopcnt-2 && stopptr[i+2] - pos < 60 && 
       (ranks[i+2] == 2 && ranks[i] > 2)) {
       if (isTrue)
       GTfn << stopptr[i] << "\t rule 2" << endl;
       GTGoodRules[1]++;
       
       continue;
       }
    */
    /* exonLengths
    if (i < stopcnt-1 && i > 0 && stopptr[i+2] - pos < 60 
	&& dist[0] < 60 && ham0[i] > 11 &&
	ranks[i+1] < ranks[i] && ranks[i-1] < ranks[i]) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 3" << endl;
	GTGoodRules[2]++;
     
      continue;
    }
    verbC("0, ",isTrue);
    if (i>0 && dist[0] < 30  && ham0[i] > ham0[i-1] && ranks[i] > 16) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 4" << endl;
	GTGoodRules[3]++;
     
      continue;
    }

    if (i>1 && dist[1] < 80 && ham0[i] > ham0[i-2] && ranks[i] > 30) {
      if (isTrue) 
	GTfn << stopptr[i] << "\t rule 5" << endl;
	GTGoodRules[4]++;
     
      continue;
    }

    if (i>2 && dist[2] < 140 && ham0[i] > ham0[i-3] && ranks[i] > 32) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 6" << endl;
	GTGoodRules[5]++;
     
      continue;
    }

    if (i>3 && dist[3] < 60  && ham0[i] > ham0[i-4] && ranks[i] > 32) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 7" << endl;
	GTGoodRules[6]++;
     
      continue;
    }

    if (i>4 && dist[4] < 80  && ham0[i] > ham0[i-5] && ranks[i] > 40) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 8" << endl;
	GTGoodRules[7]++;
     
      continue;
    }
    verbC("5, ",isTrue);
    if (i>5 && dist[5] < 120 && ham0[i] > ham0[i-6] && ranks[i] > 35) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 9" << endl;
	GTGoodRules[8]++;
     
      continue;
    }
    */
    /* removed January 16;
       if (i>6 && dist[6] < 80 && ham0[i] > ham0[i-7] && ranks[i] > 16) { // was dist[6]<150: relaxed dec 16;
       if (isTrue) 
       GTfn << stopptr[i] << "\t rule 10" << endl;
       GTGoodRules[9]++;
       continue;
       }
       
    */
    /* exonLengths
    if (i>7 && dist[7] < 150 && ham0[i] > ham0[i-8] && ranks[i] > 24) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 11" << endl;
      GTGoodRules[10]++;
      
      continue;
    }

    int ham1 = hEval1.evaluate(seq,pos+1);
    if (ham0[i] > 14 && ham1 > 0) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 12" << endl;
	GTGoodRules[11]++;
     
      continue;  // Rule 2;
    } 
    double minCluster = cs1.getMinClusterScore(seq, pos);
    if (minCluster > 2) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 13" << endl;
      GTGoodRules[12]++;
      
      continue;  // Rule 6.a;
    }
    int    ham2       = hEval2.evaluate(seq,pos+1);
    double score12    = smallEvaluate(seq, pos);
    assert(score12 < 100000);

    if (score12 < -3.2 && ham0[i] > 10 && ham1 > 0
	&& ham2 > 0 && minCluster > 0 && ranks[i] > 10 ) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 14" << endl;
      GTGoodRules[13]++;
      continue;  // Rule 3;
    } 
    double score80    = largeEvaluate(seq,pos);
    if (ranks[i] > 8 && ham0[i] > 7 && 
	minCluster > 1 && score12 < 0) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 15" << endl;
      GTGoodRules[14]++;
      
      continue;  // Rule 5;
    }
    if (score80 > -Infinity && score80 < -47 && ham0[i] > 9) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 16" << endl;
      GTGoodRules[15]++;
      
      continue;  // Rule 4;
    }
    if (ranks[i] >= 45 && score80 < 40 && ham0[i] > 9 &&
	minCluster > 0 && ham2 > 0) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 17" << endl;
      GTGoodRules[16]++;
      
      continue;   // Old Rule, added;
    }
    if (score80 > -Infinity && score80 < -60) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 18" << endl;
      GTGoodRules[17]++;
      
      continue;
    }
    */
    /* Removed January 16;
       if (ranks[i] > 5 && score12 > -Infinity && score12 < -6.4) {
       if (isTrue)
       GTfn << stopptr[i] << "\t rule 19" << endl;
       GTGoodRules[18]++;
       
       continue;
       }
    */
    /* Removed January 16;
       if (score80 < -27 && ranks[i] > 5 && ham0[i] >= 14) {
       if (isTrue)
       GTfn << stopptr[i] << "\t rule 20" << endl;
       GTGoodRules[19]++;
       
       continue;
       }
    */
    /* exonLengths
    if (score80 == -Infinity && minCluster > 0 &&
	ham0[i] > 9 && ranks[i] > 5) {
      if (isTrue)
	GTfn << stopptr[i] << "\t rule 21" << endl;
	GTGoodRules[20]++;
     
      continue;
    }
    verbC("14, ",isTrue);

    */
    scores[pos] = burgeScore2;
  }
  /* exonLengths
  for (i=0; i<=21; ++i) {
    cout << GTGoodRules[i] << " ";
    GTeff << GTGoodRules[i] << " ";
  }
  
  GTeff << endl;
  */
  cout << endl;

  delete[] stopptr;
  delete[] ham0;
  delete[] ranks;

  return 1;
}




/*************************** Utilities  ******************************/

double scale(double num, double fac1, double fac2) {
  if (num == -Infinity)
    return 0;
  if (num==Infinity)
    return 1;
  else
    return (num+fac1)/fac2;
}
  
/***********************************************************************/


/** Deprecated! **/  



double StatEvaluator::burgeEvalAG(FilterSequence *seq, int pos, double &score1, 
				  double &score2, double &score3) {
  
  // if the first bases match, let's compute...
  if (!AG || 
      (seq->get(pos-2) != BASE_A || seq->get(pos-1) != BASE_G) ||
      pos < 39 || pos > seq->get_length()-3)
    {
      score1 = score2 = score3 = (double)LOW_SCORE;
      return score3;
    }
  
  double sprob = 1.0, pprob = 1.0, bprob = 1.0;
  double nsprob = 1.0, npprob = 1.0, nbprob = 1.0;
  int counter = 0;
  Nucleotide previous_base = seq->get(pos - 39);
  
  // figure out the probabilities
  for (long index = pos - 38; index < pos + 3; index++) {
    
    Nucleotide base = seq->get(index);
    
    sprob *= AG->singles[counter]->getProb(base);
    nsprob *= AG->Nsingles[counter]->getProb(base);
    
    // first pairs entry isn't really a pair -- it's a single
    if (counter == 0) {
      
      double temp = 0.0, ntemp = 0.0;
      for (int j=0; j < 4; j++) {
	temp += AG->pairs[0]->getProb((Nucleotide)j, base);
	ntemp += AG->Npairs[0]->getProb((Nucleotide)j, base);
      }
      
      pprob = temp;
      npprob = ntemp;
    }
    else {
      pprob *= AG->pairs[counter]->getProb(previous_base, base);
      npprob *= AG->Npairs[counter]->getProb(previous_base, base);
    }
    
    // *** DO WE DO THE SAME THING HERE AS WE DID FOR THE FIRST PAIRS
    // ***  ENTRY???  MAYBE WE SHOULD....
    if (counter < 18) { // branchpoint region
      Nucleotide otherbase = seq->get(index-2);
      bprob *= AG->branchpoint[counter]->getProb(otherbase, previous_base,
						 base);
      nbprob *= AG->Nbranchpoint[counter]->getProb(otherbase, previous_base,
						   base);
    }
    else {
      bprob *= AG->branchnormal[counter-18]->getProb(previous_base, base);
      nbprob *= AG->Nbranchnormal[counter-18]->getProb(previous_base, base);
    }
    
    counter++;
    previous_base = base;
  }
  
  score1 = log(sprob / nsprob);
  score2 = log(pprob / npprob);
  score3 = log(bprob / nbprob);
  
  return score3;
}



double StatEvaluator::burgeEvalGT(FilterSequence *seq, int pos, 
				  double &score1, double &score2) {
  
  // if the first bases match, let's compute...
  if (!GT || 
      (seq->get(pos+1) != BASE_G || seq->get(pos+2) != BASE_T) ||
      pos < 3 || pos > seq->get_length()-6)
    {
      score1 = score2 = (double)LOW_SCORE;
      return score2;
    }

  int i=pos+1;
  double probability, badprob = 1.0;
  Nucleotide bpM3 = seq->get(i-3);  
  Nucleotide bpM2 = seq->get(i-2);
  Nucleotide bpM1 = seq->get(i-1);
  Nucleotide bp3 = seq->get(i+2);
  Nucleotide bp4 = seq->get(i+3);
  Nucleotide bp6 = seq->get(i+5);
  
  if (seq->get(i+4) != BASE_G) {
    
    probability = 197.0 / 1254.0;
    probability *= GT->H5table[0][bpM3];
    probability *= GT->H5table[1][bpM2];
    probability *= GT->H5table[2][bpM1];
    probability *= GT->H5table[3][bp3];
    probability *= GT->H5table[4][bp4];
    probability *= GT->H5table[5][bp6];
    badprob = (GT->Ntotcount - GT->NH5count) / GT->Ntotcount;
    badprob *= GT->NH5table[0]->getProb(bpM3);
    badprob *= GT->NH5table[1]->getProb(bpM2);
    badprob *= GT->NH5table[2]->getProb(bpM1);
    badprob *= GT->NH5table[3]->getProb(bp3);
    badprob *= GT->NH5table[4]->getProb(bp4);
    badprob *= GT->NH5table[5]->getProb(bp6);
  }
  
  // else bp 5 == G
  else {
    
    probability = 1057.0 / 1254.0;
    badprob = GT->NH5count / GT->Ntotcount;
    
    if (bpM1 != BASE_G) {
      
      probability *= 234.0 / 1057.0;
      probability *= GT->HM1table[0][bpM3];
      probability *= GT->HM1table[1][bpM2];
      probability *= GT->HM1table[2][bp3];
      probability *= GT->HM1table[3][bp4];
      probability *= GT->HM1table[4][bp6];
      badprob *= (GT->NH5count - GT->NHM1count) / GT->NH5count;
      badprob *= GT->NHM1table[0]->getProb(bpM3);
      badprob *= GT->NHM1table[1]->getProb(bpM2);
      badprob *= GT->NHM1table[2]->getProb(bp3);
      badprob *= GT->NHM1table[3]->getProb(bp4);
      badprob *= GT->NHM1table[4]->getProb(bp6);
    }
    
    // else bp -1 == G
    else {
      
      probability *= 823.0 / 1057.0;
      badprob *= GT->NHM1count / GT->NH5count;
      
      if (bpM2 != BASE_A) {
	
	probability *= 336.0 / 823.0;
	probability *= GT->HM2table[0][bpM3];
	probability *= GT->HM2table[1][bp3];
	probability *= GT->HM2table[2][bp4];
	probability *= GT->HM2table[3][bp6];
	badprob *= (GT->NHM1count - GT->NHM2count) / GT->NHM1count;
	badprob *= GT->NHM2table[0]->getProb(bpM3);
	badprob *= GT->NHM2table[1]->getProb(bp3);
	badprob *= GT->NHM2table[2]->getProb(bp4);
	badprob *= GT->NHM2table[3]->getProb(bp6);
      }
      
      // else bp -2 == A
      else {
	
	probability *= 487.0 / 823.0;
	badprob *= GT->NHM2count / GT->NHM1count;
	
	if (bp6 != BASE_T) {
	  
	  probability *= 310.0 / 487.0;
	  probability *= GT->H6atable[0][bpM3];
	  probability *= GT->H6atable[1][bp3];
	  probability *= GT->H6atable[2][bp4];
	  badprob *= (GT->NHM2count - GT->NH6count) / GT->NHM2count;
	  badprob *= GT->NH6atable[0]->getProb(bpM3);
	  badprob *= GT->NH6atable[1]->getProb(bp3);
	  badprob *= GT->NH6atable[2]->getProb(bp4);
	}
	
	// else bp 6 == T
	else {
	  
	  probability *= 177.0 / 487.0;
	  probability *= GT->H6btable[0][bpM3];
	  probability *= GT->H6btable[1][bp3];
	  probability *= GT->H6btable[2][bp4];
	  badprob *= GT->NH6count / GT->NHM2count;
	  badprob *= GT->NH6btable[0]->getProb(bpM3);
	  badprob *= GT->NH6btable[1]->getProb(bp3);
	  badprob *= GT->NH6btable[2]->getProb(bp4);
	}
      }
    }
  }
  
  double otherbadprob = .25 * .25 * .25 * .25 * .25 * .25 * .25;
  
  score1 = log(probability / otherbadprob); 
  score2 = log(probability / badprob); 
  
  return score2;
}
