// C++ interface file

#ifndef __STATEVAL_H__
#define __STATEVAL_H__

#include "eval.h"
#include "seq.h"
#include "gseq.h"
#include "fseq.h"

#include "common.h"

#include "pairtable.h"
#include "cluster.h"
#include "hameval.h"
#include "pyrtab.h"
#include "counttab.h"

#include <math.h>
#include "vector.h"
#include "splice.h"
#include "tree.h"


#define INF HUGE_VAL
#define Infinity INF

#define LOW_SCORE -10000


// This is the interface of an evaluator class

class StatEvaluator {
  
  Splice *AGsite, *GTsite, *ATGsite;
  
 public:

  StatEvaluator();
  ~StatEvaluator();

  int evaluateStarts(FilterSequence *seq, double *scores);
  int evaluateStops( FilterSequence *seq, double *scores);

  double burgeEvalAG(char *seqchar, int pos, double &score1, double &score2, double &score3);
  double burgeEvalAG(FilterSequence *seq, int pos, double &score1, double &score2, double &score3);

  double burgeEvalGT(FilterSequence *seq, int pos, double &score1, double &score2);

  double burgeEvalATG(FilterSequence *seq, int pos, double &score1, double &score2);

  void initializeBurge(ifstream &trainingFile, SpliceSite site) {
    
    switch (site) {
      
    case AG_S:
      AGsite = new Splice(AG_S);
      trainingFile >> *AGsite;
      break;
      
    case GT_S:
      GTsite = new Splice(GT_S);
      trainingFile >> *GTsite;
      break;
      
    case ATG_S:
      ATGsite = new Splice(ATG_S);
      trainingFile >> *ATGsite;
      break;
    }

    assert(AGsite || GTsite || ATGsite);
  }
};

extern ofstream stopsPass;

double scale(double,double,double);

#endif // __STATEVAL_H__


