#ifndef __SPLICE_H__
#define __SPLICE_H__

#include "String.h"
#include "seq.h"
#include "quads.h"

// Class Site defines a possible splice site within a sequence

class Site {

 public: 

  Site(double prob1, double prob2, double prob3, char *loc, long bp, bool ts, 
       int sn) {
    singleprob = prob1;
    pairprob = prob2;
    branchprob = prob3;
    strcpy(locus, loc);
    basepair = bp;
    trueSite = ts;
    seqNum = sn;
  }

  Site(double prob1, char *loc, long bp, bool ts, int sn) {
    singleprob = prob1;
    pairprob = 0.0;
    branchprob = 0.0;
    strcpy(locus, loc);
    basepair = bp;
    trueSite = ts;
    seqNum = sn;
  }

  double singleprob, pairprob, branchprob;
  char locus[500];
  int seqNum;
  long basepair;
  bool trueSite;
};



// Class Splice defines the splicing region between an intron and an
//  exon.  Specifically, it deals with the region from -38 to -1 of the
//  intron and +1 to +3 of the exon. 

class Splice {

 public: 

  Splice() { Splice(TRUE); }
  Splice(bool flag);
  ~Splice();
  void findSplices(GeneSequence *seq);
  void testSplices(GeneSequence *seq, ostream& outfile);
  void computations();
  
  
  // Operator aliases
  friend istream& operator>>(istream& cin, Splice& splice);
  friend ostream& operator<<(ostream& cout, Splice& splice);
  
  // is it an acceptor or donor splice site?
  bool acceptor;
  
  // we'll need QuadProb's for each of the given positions plus pseudos
  QProb *singles[41], *Nsingles[41];
  QuadProb *pairs[41], *Npairs[41];
  QuadProb *branchnormal[23], *Nbranchnormal[23];
  Quad4Prob *branchpoint[18], *Nbranchpoint[18];
  
  double H5table[6][4], HM1table[5][4], HM2table[4][4], H6atable[3][4], 
    H6btable[3][4];
  double Ntotcount, NH5count, NHM1count, NHM2count, NH6count;
  QProb *NH5table[6], *NHM1table[5], *NHM2table[4], *NH6atable[3], 
    *NH6btable[3];
  
 protected: 
  
  void findAcceptorSplices(GeneSequence *seq);
  void findDonorSplices(GeneSequence *seq);
  void testAcceptorSplices(GeneSequence *seq, ostream& outfile);
  void testDonorSplices(GeneSequence *seq, ostream& outfile);
  void initTables();
  
  Site **sites;
  int maxsites, numsites;  
};

#endif // __SPLICE_H__

