#ifndef __SPLICE_H__
#define __SPLICE_H__

#include <fstream.h>
#include "String.h"
#include "fseq.h"
#include "tree.h"
#include "quads.h"


enum SpliceSite { AG_S, GT_S, ATG_S };


// Class Splice defines the splicing region between an intron and an
//  exon.  Specifically, it deals with the region from -38 to -1 of the
//  intron and +1 to +3 of the exon (acceptor) or -3 to +6 (donor). 
//  Also, there are site for the first coding exon (ATG).

class Splice {

 public: 

  Splice() { Splice(AG_S); }
  Splice(SpliceSite site);
  ~Splice();
  void findSplices(GeneSequence *seq);
  void testSplices(GeneSequence *seq, ostream& outfile);
  void computations();
  
  // Operator aliases
  friend istream& operator>>(istream& cin, Splice& splice);
  friend ostream& operator<<(ostream& cout, Splice& splice);
  
  // what type of splice site is it?
  SpliceSite SiteType;
  
  // we'll need QuadProb's for each of the given positions plus pseudos
  QProb *singles[41], *Nsingles[41];
  QuadProb *pairs[41], *Npairs[41];
  QuadProb *branchnormal[23], *Nbranchnormal[23];
  Quad4Prob *branchpoint[18], *Nbranchpoint[18];
  
  Tree *decisionTree, *NdecisionTree;
  
 protected: 
  
  void findAcceptorSplices(GeneSequence *seq);
  void findDonorSplices(GeneSequence *seq);
  void findATGSplices(GeneSequence *seq);
  void testAcceptorSplices(GeneSequence *seq, ostream& outfile);
  void testDonorSplices(GeneSequence *seq, ostream& outfile);
  void testATGSplices(GeneSequence *seq, ostream& outfile);

  Nucleotide *counts, *Ncounts;
  long countnum, maxcount, Ncountnum, Nmaxcount;
};

#endif // __SPLICE_H__

