#ifndef _PROXY_H_ /* Guard against multiple inclusion */
#define _PROXY_H_ 1

#include "common.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <ctype.h>
#include <signal.h>
 
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
 
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/file.h>
 
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netdb.h>

#include <arpa/inet.h>

#include "async.h"
#include "mainprog.h"
#include <String.h>

#define LISTENPORT            8000
#define MAXFD                 64
#define MAXCONNECTIONS        (MAXFD - 9)
#define MAXMESSAGE            4096


int numberofconnections, listen_socket;
String* ipAddr[MAXCONNECTIONS];

/* Error messages */
char *toolarge_error;
char *server_error;
char *request_error;
char *connect_error;

struct fcon {
  int fd_client;               /* client socket */
  
  int client_give_pos;    /* position of server_get already given to client */
  int client_get_len;     /* total length of message from client */
  int client_get_pos;     /* position of client_get read in from client */
  int answer_len; 

  char *answer_get;       /* client and answer messages */
  char *client_get;   

  int one_newline;
};


void do_error(struct fcon *fc, char *error);
void fcon_free (struct fcon *fc);
int tcpserver(int port); 
void accept_client(void *);
void process_request(int client_socket); 

void read_client (void *_fc); 
void write_client(void *_fc); 

/* parsing routines */
void parse_client_message (struct fcon *fc); 
/* int main_program(char *request, char **answer); */

#endif /* !_PROXY_H_ */









