#include "server.h"
    
void do_error(struct fcon *fc, char *error) {
  
  int length = strlen(error); 
  
  fc->answer_get = (char*)xmalloc(length);
  memcpy(fc->answer_get, error, length);
  fc->answer_len = length;
  cb_add(fc->fd_client, 1, write_client, fc);  
}

void fcon_free (struct fcon *fc) {
  if (fc->fd_client >= 0) {
    close (fc->fd_client);
    numberofconnections--;
  }

  if (fc->client_get) 
    xfree (fc->client_get);      /* destroy the messages */  

  delete[] fc->answer_get;
  xfree (fc);
  
  /* enable accepting in case it was turned off */
  cb_add(listen_socket, 0, accept_client, NULL);
}

int main() {
  
  /* Error messages */
  toolarge_error = "Message is too large for this server.\n";
  server_error = "Server problem encountered.\n";
  request_error = "Bad Request.\n";
  connect_error = "Problem connecting to server.\n";
  
  numberofconnections = 0;


  /* prevent SIGPIPE signals */
  signal (SIGPIPE, SIG_IGN);

  
  /* Create a socket to listen for clients */
  listen_socket = tcpserver(LISTENPORT);
  if (listen_socket < 0)
    exit(-1);
  make_async(listen_socket);
  cb_add(listen_socket, 0, accept_client, NULL);  


  /* loop forever accepting clients */  
  for (;;) {
    cb_check();    
  }

}



/* function to create a listening socket */

int tcpserver(int port) {

  struct sockaddr_in server_in;  
  int listen_socket, n;

  /* initialize the address of the socket */
  bzero(&server_in, sizeof(server_in));
  server_in.sin_family = AF_INET;
  server_in.sin_port = htons(port);               

  /* listen to all IP addresses this machine has */ 
  server_in.sin_addr.s_addr = htonl(INADDR_ANY);  

  listen_socket = socket (AF_INET, SOCK_STREAM, 0);
  if (listen_socket < 0) {
    perror("socket");
    return -1;
  }

  /* allow program to run even if there are old connections in TIME_WAIT */
  n = 1;
  if (setsockopt (listen_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&n, 
		  sizeof(n)) < 0) {
    perror("SO_REUSEADDR");
    close(listen_socket);
    return -1;
  }

  /* prevent programs that we execute from inheriting the TCP server file */
  /*  descriptor by setting the close-on-exec bit of the fd               */
  fcntl(listen_socket, F_SETFD, 1);

  if (bind (listen_socket, (struct sockaddr *) &server_in, 
	    sizeof (server_in)) < 0) {
    fprintf(stderr, "TCP port %d: %s\n", port, strerror (errno));
    close(listen_socket);
    return -1;
  }

  if (listen (listen_socket, 5) < 0) {
    perror("listen");
    close(listen_socket);
    return -1;
  }

  return listen_socket;
}


/* function to accept clients trying to connect to us */

void accept_client(void *trash) {
  trash=trash; // To eliminate compiler warning message.
  int client_socket;
  struct sockaddr_in server_in;  
  unsigned int server_in_length;
  

  /* don't create more file descriptors than we are allotted */
  if (numberofconnections >= MAXCONNECTIONS) {
    /* stop accepting if we're full */
    cb_free(listen_socket, 0);
    return;
  }  

  server_in_length = sizeof (server_in);
  client_socket = accept (listen_socket, (struct sockaddr *) &server_in,
			  &server_in_length);
  
  /* for good connections */
  if (client_socket >= 0) {
    ipAddr[client_socket]=new String(inet_ntoa(server_in.sin_addr));
    printf("connection from %s\n", inet_ntoa(server_in.sin_addr));
    make_async(client_socket);
    numberofconnections++;
    process_request(client_socket);
  }
  
  else if (errno != EWOULDBLOCK) {
    /* because it is blocking, accept returns -1 when there are  */ 
    /*  no connections to accept                                 */
    perror("accept");
  }

  return;  
}


/* function to initialize everything once a connection to client is made */

void process_request(int client_socket) {

  struct fcon *fc;

  fc = (fcon*)xmalloc( sizeof(*fc));
  bzero(fc, sizeof(*fc));

  fc->fd_client = client_socket;
  
  /* set this one as a check to make sure the connection is established */
  cb_add(fc->fd_client, 1, write_client, fc);
}


/* functions to take care of reading and writing from clients and servers */

void read_client (void *_fc) {

  struct fcon *fc = (fcon*)_fc;
  int i, n;


  if (fc->client_get_pos == fc->client_get_len) {

    /* make sure we haven't exceeded bounds */
    if (fc->client_get_len > MAXMESSAGE) {  
      /* stop reading from client */    
      cb_free(fc->fd_client, 0);  
      do_error(fc, toolarge_error);
      return;
    }

    /* if first time, initialize to 512;  else, do a bitwise shift      */
    /*                                      (ie. multiply length by 2)  */
    fc->client_get_len = fc->client_get_len ? fc->client_get_len << 1 : 512;
    /* reallocate the memory to fit new length */
    fc->client_get = (char*)xrealloc (fc->client_get, fc->client_get_len);
  }

  
  n = read (fc->fd_client, fc->client_get + fc->client_get_pos, 
	    fc->client_get_len - fc->client_get_pos);
  
  for (i=0; i < n; i++) {
    
    if (*(fc->client_get + fc->client_get_pos + i) == '\n') {
      
      /* if there's already been a newline */
      if (fc->one_newline) {
	
	/* stop reading from client and parse his message */    
	cb_free(fc->fd_client, 0);  
	fc->client_get_pos += i+1;
	parse_client_message(fc);
      }      
      else
	fc->one_newline = 1; 
      
    }
    
    else if (*(fc->client_get + fc->client_get_pos + i) != '\r') 
      fc->one_newline = 0;
    
  }  
  
  if (n == 0) {
    /* quit if there was no message */
    if (fc->client_get_pos == 0) {
      cb_free(fc->fd_client, 0);
      fcon_free(fc);
    }
    return;
  }
  else if (n < 0) {
    if (errno == EAGAIN)
      return;
    else
      perror ("read from client");
    cb_free(fc->fd_client, 0);
    fcon_free (fc);
    return;
  }
  
  fc->client_get_pos += n;

}


void parse_client_message (struct fcon *fc) {

  char *to_program;

  int length = strlen(fc->client_get) - 2;    // ignore the last 2 newlines
  to_program = (char*)xmalloc(length+1);
  memcpy(to_program, fc->client_get, length);
  to_program[length] = '\0';
  fc->answer_len = main_program(ipAddr[fc->fd_client], 
				to_program, &(fc->answer_get));
  delete ipAddr[fc->fd_client];
  xfree(to_program);
  cb_add(fc->fd_client, 1, write_client, fc);

  return;
  
}


void write_client(void *_fc) {

  struct fcon *fc = (fcon*)_fc;
  int n;
 
  /* don't write if there's nothing to write */
  if (fc->answer_len - fc->client_give_pos == 0) {

    /* if we're finished writing we're all done! */
    if (fc->answer_len) {
      cb_free(fc->fd_client, 1);
      printf("Finished writing to socket...\n");
      fcon_free(fc);              
    }
    /* otherwise, we've just begun */
    else {
      cb_free(fc->fd_client, 1);
      cb_add(fc->fd_client, 0, read_client, fc);
    }

    return;
  }  

  n = write (fc->fd_client, fc->answer_get + fc->client_give_pos, 
	     fc->answer_len - fc->client_give_pos);

  if (n <= 0) {
    if (n == 0 || errno != EAGAIN) {
      fprintf (stderr, "EOF\n");       /* client quit responding */
      cb_free(fc->fd_client, 1);
      fcon_free (fc);
      return;
    }
    return;
  }

  fc->client_give_pos += n;
}


// int main_program(char *request, char **answer) {

//   /* here's a temporary database file */

//   char *message = "0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n0 1 .2 .2 .5\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n1 2 .8 .3 .4\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n2 0 .2 .9 .3\n";

//   int length = strlen(message) +1;
  
//   *answer = xmalloc(length);
//   memcpy(*answer, message, length);
  
//   return length;
// }






