#include "seq.h"
#include <fstream>
#include "common.h"

main(int argc, char *argv[]) {
  if (argc != 3) {
    cout << "Usage: ./seq_to_fasta <inputfile> <outputfile>" << endl;
    exit(0);
  }
    
  ifstream fin(argv[1]);
  ofstream fout(argv[2]);

  Sequence s;
  fin >> s;
  fout << ">" << s.get_locus() << endl;

  for (int i=1; i<=s.get_length(); ++i) {
    fout << nucl2char(s.get(i));
    if (!(i%60))
      fout << endl;
  }

  cout << "done" << endl;
}
