#ifndef __REGISTRY_H__
#define __REGISTRY_H__

#include "vector.h"
#include <String.h>
#include "common.h"

#define MAX_REGISTRY_SIZE 300

class Registry {
public:
  // Overview: The registry is a map that contains all of the 
  //           configuration information for the main program.
  //
  // AF(c)=U forall(i) {c.keys[i]:c.values[i]}
  //
  // I(c)=(c.keys.length()==c.values.length())

  String *keys, *values;
  int size;

  // Constructor/Destructor;
  Registry() {
    keys=new String[MAX_REGISTRY_SIZE];
    values=new String[MAX_REGISTRY_SIZE];
    size=0;
  }

  void copy(Registry* reg) {
    for(int i=0;i<reg->size;i++) {
      keys[i]=reg->keys[i];
      values[i]=reg->values[i];
    }
    size=reg->size;
  }

  ~Registry() {
    delete[] keys;
    delete[] values;
  }
  
  friend istream& operator>>(istream& in, Registry& reg);

  friend ostream& operator<<(ostream& out, Registry& reg);

  String lookupVal(String key, int num=1) 
  // Effects: Returns the numTH value associated with "key" in "this".
  //          If there is no value associated with "key", returns "".
  //          If num>number of occurances of "key" in "this", then
  //          "lookupVal" will return the last occurance.
  {
    int i;
    int found=0;
    for (i=0;(i<size)&&(found<num);) { 
      if (keys[i]==key) found++;
      if (found<num) i++;
    }
      
    if (found==0) return ""; 
    else return values[i];
  }

  void erase(String key) 
  // Modifies: "this"
  // Effects: Deletes all values associated with "key"
  {
    int i=0;
    while (i<size)
      if (keys[i]==key) {
	size--;
	for(int j=i;j<size;j++) {
	  keys[j]=keys[j+1];
	  values[j]=values[j+1];
	}
	keys[size]=values[size]="";
      } else i++;
  }

  inline void add(String key, String value) 
  // Modifies: "this"
  // Effects: Adds {key:value} to "this"
  {
    assert(size<MAX_REGISTRY_SIZE);
    keys[size]=key;
    values[size]=value;
    size++;
  }

  inline void change(String key, String value)
  // Modifies: "this"
  // Effects: Changes the value associated with key.  If multiple values are 
  //          associated with key, sets to one value.
  {
    erase(key);
    add(key,value);
  }
};

istream& operator>>(istream& in, Registry& reg);

ostream& operator<<(ostream& out, Registry& reg);


#endif






























