#include "registry.h"

istream& operator>>(istream& in, Registry& reg)
  // Requires: valid "reg";
  // Modifies: "in", "reg";
  // Effects: Fills "reg" with information read from "in";
  //          "key=value\n" -> {reg.key,reg.value};
  //          Any line not containing a "=" is ignored;
  {    
    String inputLine;
    while (readline(in,inputLine)) 
      if (inputLine.contains("="))
	reg.add(inputLine.before("="),inputLine.after("="));
    return in;
  }
  
ostream& operator<<(ostream& out, Registry& reg) 
  // Requires: valid "out", "reg"
  // Modifies: "out"
  // Effects: Outputs all key/value pairs in reg to "out".
  //          {reg.key,reg.value} -> "key=value\n"
  {
    for (int i=0;i<reg.size;i++) 
      out << reg.keys[i] << "=" << reg.values[i] << endl;
    return out;
  }

