#ifndef __QUADS_H__
#define __QUADS_H__

#include "seq.h"

// Class QProb defines the 4 probabilities for the nucleotides at a
//  given position within the sequence.

class QProb {
  
 public:

  QProb();
  void addToCount(Nucleotide i);
  void computeProb();
  double getProb(Nucleotide i);
  double getCount(Nucleotide i);

  // Operator aliases
  friend istream& operator>>(istream& cin, QProb& q);
  friend ostream& operator<<(ostream& cout, QProb& q);
  
 protected: 
  double probs[4];  
  double counts[4];
  double totalcount;

};


// Class QuadProb defines the 4 probabilities for the nucleotides at a
//  given position within the sequence, given the nucleotide before it.

class QuadProb {
  
 public:

  QuadProb();
  void addToCount(Nucleotide before_i, Nucleotide i);
  void computeProb();
  double getProb(Nucleotide before_i, Nucleotide i);
  double getCount(Nucleotide before_i, Nucleotide i);

  // Operator aliases
  friend istream& operator>>(istream& cin, QuadProb& q);
  friend ostream& operator<<(ostream& cout, QuadProb& q);

 protected: 
  double probs[4][4];
  double counts[4][4];
  double totalcount;

};


// Class Quad4Prob is just like QuadProb, but it allows for triplets 

class Quad4Prob {
  
 public:

  Quad4Prob();
  void addToCount(Nucleotide before2, Nucleotide before1, Nucleotide i);
  void computeProb();
  double getProb(Nucleotide before2, Nucleotide before1, Nucleotide i);
  double getCount(Nucleotide before2, Nucleotide before1, Nucleotide i);

  // Operator aliases
  friend istream& operator>>(istream& cin, Quad4Prob& q);
  friend ostream& operator<<(ostream& cout, Quad4Prob& q);

 protected: 
  double probs[16][4];
  double counts[16][4];
  double totalcount;

};


#endif // __QUADS_H__

