#ifndef __PYRTAB_H__
#define __PYRTAB_H__

#include "fseq.h"
#include "gseq.h"

class PyrTable {
  int cutoff, window, startFrom, startTo;

public:

  PyrTable(int cutoff=0, int window=20, int from=-33, int to=-13);
  ~PyrTable();

  int evaluate(FilterSequence*, int);
  int evaluateAG(FilterSequence*, int);

  int countAG(FilterSequence*, int, int window=20);
  int countGA(FilterSequence*, int, int window=20);
  int countPyr(FilterSequence*, int);

  int cagNeighbor(FilterSequence*, int, int window=20);
  
};

#endif
