#include <fstream.h>
#include <iostream.h>
#include <string.h>
#include <String.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "pyrtab.h"

PyrTable::PyrTable(int cutoff, int window, int from, int to) {
  this->cutoff = cutoff;
  this->window = window;
  this->startFrom = from;
  this->startTo = to;
}

PyrTable::~PyrTable() {
}

int PyrTable::evaluate(FilterSequence* seq, int pos) {
  int maxCount=0, count = 0, size = startTo - startFrom + window;
  bool pyr[size];
  
  assert(pos + startFrom > 0 &&
	 pos + startTo + window <= seq->get_length());

  for (int i=startFrom; i < startTo+window; i++) {
    if (seq->get(pos+i) == BASE_C || seq->get(pos+i) == BASE_T)
      pyr[i - (startFrom)] = true;
    else
      pyr[i - (startFrom)] = false;
  }

  for (int n=0; n < (startTo - startFrom); n++) {
    for (int i=n; i<window+n; i++) {
      if (pyr[i])
	count++;
    }
    if (count > maxCount)
      maxCount = count;
    count = 0;
  }

  return maxCount;
}

int PyrTable::evaluateAG(FilterSequence* seq, int pos) {
  int count = 0, size = startTo - startFrom + window;
  bool pyr[size];
  
  assert(pos + startFrom > 0 &&
	 pos + startTo + window <= seq->get_length());

  for (int i=startFrom; i < startTo+window; i++) {
    if (seq->get(pos+i) == BASE_A || seq->get(pos+i) == BASE_G)
      pyr[i - (startFrom)] = true;
    else
      pyr[i - (startFrom)] = false;
  }

  for (int i=0; i<window; i++) {
      if (pyr[i])
	count++;
    }
  
  return count;
}


int PyrTable::countAG(FilterSequence *seq, int pos, int window) {

  int count=0;

  for (int i=-(window+1); i<-1; i++) {
    if (seq->get(pos+i+1) == BASE_G) {
      if (seq->get(pos+i) == BASE_A) {
	count++;
      }
    } else {
      i++;
    }

  }

  return count;
}



int PyrTable::countGA(FilterSequence *seq, int pos, int window) {

  int count=0;

  for (int i=-(window+1); i<-1; i++) {
    if (seq->get(pos+i+1) == BASE_A) {
      if (seq->get(pos+i) == BASE_G) {
	count++;
      }
    } else {
      i++;
    }
    
  }

  return count;
}

int PyrTable::countPyr(FilterSequence *seq, int pos) {

  int count=0;

  for (int i=-21; i<-1; i++)
    if (seq->get(pos+i) == BASE_C ||
	seq->get(pos+i) == BASE_T)
      count++;

  return count;
}
     
int PyrTable::cagNeighbor(FilterSequence *seq, int pos, int window) {

  
  for (int i=-3; i > -(window+1); i--) {
    if (seq->get(pos+i) == BASE_G)
      if (seq->get(pos+i-1) == BASE_A)
	if (seq->get(pos+i-2) == BASE_C)
	  return i+1;
  }

  return 0;
}
