// C++ interface file

#ifndef __PAIRTABLE_H__
#define __PAIRTABLE_H__

#include "seq.h"
#include "fseq.h"
#include "seval.h"


// This is the interface of a statistics table class

class PairTable {
public:
  PairTable(int afrom1, int ato1, int afrom2, int ato2);
  PairTable(istream& cin);
  PairTable(istream& cin, FilterSequence*, char*); /* Minus One Option Only!! */
  virtual ~PairTable();

  void minusOne(FilterSequence*, char*);
  
  const PairTable& operator/=(PairTable &p);

  bool add_data(Sequence *seq, long pos1, long pos2);
  bool add_data(Sequence *seq, long pos1, long prevpos1, long nextpos1, long pos2, long prevpos2, long nextpos2);
 
  bool remove_data(Sequence *seq, long pos1, long pos2);
       
  void unparse_table(ostream& cout);
  void unparse(ostream& cout);

  void store(ostream&);
  void write_text(ostream&);
  void store_write(ostream&, ostream&);

  int getHeight() { return len1; }
  int getWidth() { return len2; }
  int getSize();
  
  long& single_count1(long idx, Nucleotide n);
  long& single_total1(long idx);
  long& single_count2(long idx, Nucleotide n);
  long& single_total2(long idx);
  
  long& double_count(long idx1, long idx2, Nucleotide n1, Nucleotide n2);
  long& double_total(long idx1, long idx2);

  void calculate_probabilities();

  double& single_prob_log1(long idx, Nucleotide n);
  double& single_prob_log2(long idx, Nucleotide n);
  double& double_prob_log(long idx1, long idx2, Nucleotide n1, Nucleotide n2);
  
private:
  int from1, to1, len1, from2, to2, len2;
  long total;

  long *single_counts1, *single_totals1;
  long *single_counts2, *single_totals2;
  long *double_counts, *double_totals;
  double *double_probs_log;
  double *single_probs_log1, *single_probs_log2;
  
  long* create_table(long tlen);
  
  void write_long(ostream& ostr, long l);
  long read_long(istream& istr);
  
};


#endif // __PAIRTABLE_H__
