
#ifndef __VECTOR_H__
#define __VECTOR_H__

#include <assert.h>

template <class T>
class vector {
public:
  
  vector() {
    data=new (T*)[length=4];
    filled=0;
  };
  
  vector(vector<T>& vec) {
    data=new (T*)[length=vec.length];
    filled=vec.filled;
    for(int i=0;i<filled;i++) {
      data[i]=new T;
      (*(data[i]))=(*(vec.data[i]));
    } 
  }
    
  ~vector() {
    for(int i=0;i<size();i++) delete data[i];
    delete[] data;
  }
  
  inline T& operator[](int idx) {
    if ((0>idx)||(idx>=size())) {
      cout << endl;
      cout << "Vector index out of bounds: " << idx << " size=" << size() << endl;
      cout << endl;
    }
    assert((0<=idx)&&(idx<size()));
    return (*(data[idx]));
  } 
  
  vector<T>& operator=(const vector<T>& vec) {
    for(int i=0;i<size();i++) delete data[i];
    delete[] data;
    data=new (T*)[length=vec.length];
    filled=vec.filled;
    for(int i=0;i<filled;i++) {
      data[i]=new T;
      (*(data[i]))=(*(vec.data[i]));
    }
    return *this;
  }
  
  void push_back(T elt) {
    if (filled>=length) {
      T** newdata=new (T*)[2*length];
      for(int i=0;i<filled;i++) newdata[i]=data[i];
      delete[] data;
      data=newdata;
      length*=2;
    } 
    data[filled]=new T;
    (*(data[filled++]))=elt;
  }
  
  void erase(int idx) {
    if (filled<1) 
      cout << "Vector already empty - can't erase" << endl;
    assert(filled>=1);
    
    if (filled<(length/4)) length/=2;
    T** newdata=new (T*)[length];
    
    for(int i=0;i<idx;i++) newdata[i]=data[i];
    for(int i=idx+1;i<filled;i++) newdata[i-1]=data[i];
    filled--;
    delete[] data;
    data=newdata;
  }
  
  inline int begin() { return 0; }
  inline int end() { return filled-1; }
  inline int size() { return filled; }
  
  void clear() { 
    for(int i=0;i<filled;i++) delete data[i];
    filled=0;
    delete[] data;
    data=new (T*)[length=4];
  }

private:
  int length;
  T** data;
  int filled;
};

#endif










