#include "common.h"
#include <string.h>
#include "fseq.h"
#include "matrix.h"
#include "nucleotable.h"
#include "stateval.h"
#include "hameval.h"
#include "registry.h"
#include "rep_identify.h"
#include "dictionary.h"
#include "align.h"
#include "makeranks.h"

#ifndef __MODULES_H__
#define __MODULES_H__

// In order to use any dictionary method, DICTIONARY_MODE has to be true;

const int DICTIONARY_MODE = 0;

typedef vector<int> Parse;

enum ParseAssumptions { SINGLE_GENE = 0, PARTIAL_GENE = 1, MULTI_GENES = 2 };

enum Method         { Perk       = 0,  Min      =1,  Max        = 2,  MinIndex   =3,  SPerk = 4,  MaxIndex =5,  PerkIndex  = 6,  SPerkIndex =7 };
enum TupleMethod    { Everywhere = 0,  Relevant =1,  TupleFreqs = 2                   };
enum NormalMethod   { None       = 0,  Length   =1,  Absolute   = 2                   };
enum FProbMethod    { Normal     = 0,  Log      =1                                    };
enum StatEvalMethod { Eval       = 0,  Meta     =1                                    };

enum EndPointsType  { START       = 1,  STOP         = 2,  ATG   = 4,  STOP_CODON=8, BEGIN_SEQ = 16 };
enum DPEndPoints    { BEGINNING   = 0,  START_CODING = 1,  AG    = 2,  GT=3, STOP_CODING = 4, END = 5 };
enum BPtrType       { ENDPTR      = 0,  ENDPTRTYPE   = 1,  FRAME = 2                  };

enum myDataVals { SEG_REMOVED = 0, TWO_FRAME_EXONS = 1, EXON_POS_COVERED = 2, EXON_POS_UNCOV = 3, INTRON_POS_COVERED = 4, INTRON_POS_UNCOV = 5 };

class Modules {

 public:
  Modules(FilterSequence *seq, Registry *reg);
  ~Modules();
  
  TupleTable* loadTupleTable(const char* fileName, Registry* reg);

  void readMethods(Registry* reg, Method& frameM, Method& scoreM, NormalMethod& normM);

  void setStatEvaluators(StatEvaluator *startEval, StatEvaluator *stopEval, StatEvaluator *ATGcodon);

  void loadStartStop();

  void computeDictionaryInfo(Registry *reg);
  void computeWindowFrameScores(Registry *reg);

  LongTupleTable *ltt;
  int  computeIntronSignals(LongTupleTable*);

  void computeEndPtrs(Registry *reg);
  
  void frameScoreMatrixFind(Registry* reg);

  void fprobFind(Method scoreM, Registry* reg);

  void frameNFind(int start, int stop, Method FrameM, Method ScoreM,
		  NormalMethod NormM, int& frame, double& score, int scoreFramesPossible, 
		  int frameFramesPossible, double factor);
  // Requires: The "FrameMatrix" and "ScoreMatrix" associated with the "tth" have already;
  //                                                                         been created;
  //           Probabilities already calculated in fprob;
  // Modifies: "this" (modifies the "FrameMatrix" and "ScoreMatrix" associated with "tth");
  // Effects: Finds the frame and score info using "FrameM" and "ScoreM" associated with the;
  //          region (start->stop) and outputs to the appropriate frame/score matrices;
  //          Returns false iff is definitely NOT an exon;
  
  void frameDictionaryFind(int start, int stop, int frame, double &score,
			   int maxMismatchInExon);
  // Computes the dictionary score for the GIVEN frame;
  int  framesPossible(int regionA, int regionB);

  void atgFind();
  void startStopFind(Registry* reg);
  void startStopFind();  
  
  void setImages(ifstream &, ifstream &);
  void setHumImg(ifstream &fin);
  void setMouseImg(ifstream &fin);
  
  void setRepeats(ifstream &fin);
  void setRepeats(ifstream &finHuman, ifstream &finMouse);

  int *repeatBeginh, *repeatEndh, *repeatRegionh, *repeatIntronScoreh, *repeatExonScoreh;
  String *repeatTypeh;
  int *repeatBeginm, *repeatEndm, *repeatRegionm, *repeatIntronScorem, *repeatExonScorem;
  String *repeatTypem;
  int repeatNumberh, repeatNumberm;
  
  Parse* mouseGeneratePartialParse(Modules *mouseModule, Registry *reg);
  Parse* newGenerateParse(Registry* reg);

  double maxFrameWindowScore(int start, int stop);

  void printResults(ostream& out, Parse* parsetot[2], int numparses, Registry *reg);
  //  void printAnswer(ostream& out, Parse* parse, Registry *reg);

  void outputParse(Parse *parse);
  void mouseOutputParse(Parse *parse, ofstream &fout);
  void mouseOutputParseRevComp(Parse *parse, ofstream &fout);
  void outputParse(Parse *parse, Registry *reg);
  void outputParse(Parse *parse, Registry *reg,
		   int& argTotalOverlap, int& argTotalNonOverlap, 
		   int& argTotalPerfect, int& argTotalMatch,
		   int& argTotalMiss, int& argTotalExons,
		   int& argTotalPExons,
		   vector<int> *argNucData,
		   vector<int> *argTotalFrame, vector<double> *argGCInfo);


  int intronSignalHits(int start, int stop, int window);


  double computeIntronExonProb();
  
  SparseMatrix<int>*    getStopMatrix()   { return  stopMatrix;    }
  SparseMatrix<int>*    getFrameMatrix()  { return  matrixFrame;   }
  SparseMatrix<double>* getScoreMatrix()  { return  matrixScore;   }
  FullMatrix<double>*   getFProb()        { return  matrixFProb;   }  
  TupleTable*           getTupleTable()   { return  theTupleTable; }
  FilterSequence*       getSequence()     { return  m_seq;         }

  char* sequenceToChar(bool complement);   // Also masks repeats etc;
  char* sequenceSplice(char *seqText);

  int *starts, *stops, *stopCodons, *atgCodons;  // potential starts and stops of introns;
  double *startScores, *stopScores, *atgScores;  // and their respective scores;
  int startCount, stopCount, stopCodonCount, atgCodonCount, endcnt;

  FilterSequence *mouseSeq;
  int alignCount, *alignStarts, *alignStops, *alignStartsTo, *alignStopsTo;
  int *humSeqInt, *mouseSeqInt, *humImg, *mouseImg, mouseSeql;
  int seql;
  int codingl, parseOffset, mouseParseOffset;
  
  int *alignGaps, *alignMatches, *alignMismatches;
  double *alignmentScores;
  double *intexProb;

  double exonPairScore(int hstart, int hstop, int hfr, int mstart, int mstop, int mfr, int rType);
  
  double aveIntronExonProb(int start, int stop);
  void cumulativeAlignScore(double match, double mismatch, double gap);
  
  int exonImagesToTry(Modules *mouseModule, int hstart, int hstop, int *mstarts, int *mstops, int rType);

  double*  getEndpointStartScore() { return endpointStartScore; }
  double*  getEndpointStopScore()  { return endpointStopScore;  }
  int*     getEndpointType()       { return endpointType;       }
  TupleTable *theTupleTable;

  void computeStopMatrix(Registry* reg);
  void outputValidPositions(ofstream &fout);
  void setAligningRegions(ifstream &fin);
  FilterSequence *m_seq;

 private:
  
  double *myData; // temporary for the RECOMB statics;
  
  double stopScore(Nucleotide, Nucleotide, int);
  double frameMethod(double *frame, Method FrameM, int framesPossible);
  void setHumReps(ifstream &fin);
  void setMouseReps(ifstream &fin);


  double **pamMat;
  double ***hcodonMat, ***mcodonMat;

  int *endpointType, *endpoints, *endptrType, *endptrs, *endptrsInv;
  double *endpointStartScore, *endpointStopScore, *endpointATGScore;
  long unsigned int *proteinHits, *cDNAHits;
  int *proteinCumulativeHits, *proteinCumulativeHitPositions, *proteinMaskedIntronsCumulativeHits;
  int *proteinSeglenHits, *proteinCumulativeSeglenHits;
  int *proteinAccessions;
  
  double *proteinCumulativeLogs;

  char *DNAToProtein0, *DNAToProtein1, *DNAToProtein2;

  int *intronSignals;
  int *aligningBegins, *aligningEnds;
  int alignRegcnt;

  int *validPositions; // all positions of a coding exon have to be valid. For instance repeats are not valid positions;
  int *cumulativeInvalidPositions;

  // array of length seq->get_length() that has cumulative 12tuple intron signals;
  
  SparseMatrix<int>    *stopMatrix;
  SparseMatrix<double> *matrixScore;
  SparseMatrix<int>    *matrixFrame;
  FullMatrix<double>   *matrixFProb;
  double *wfscores;
  int    *wframes;
  StatEvaluator *startCodon, *stopCodon, *ATGcodon;

  vector<String> htmlFile;
};



#endif
