#include "modules.h"

main(int argc, char* argv[]) {
  register int i,j;

  Registry *reg=new Registry();  // Read in the registry
  ifstream regfile(argv[1]);
  regfile >> *reg;
  regfile.close();
  char hseqfname[100], mseqfname[100];
  strcpy(hseqfname, reg->lookupVal("geneDatabase"));
  strcpy(mseqfname, reg->lookupVal("mouseGeneDatabase"));

  ifstream hseqf(reg->lookupVal("geneDatabase"));
  ifstream mseqf(reg->lookupVal("mouseGeneDatabase"));

  int seqno  = atoi(reg->lookupVal("firstSequence"));
  FilterSequence *hseq = new FilterSequence();
  FilterSequence *mseq = new FilterSequence();
  for(i=0;i<(seqno);i++) hseqf >> *hseq;
  for(i=0;i<(seqno);i++) mseqf >> *mseq;
  String s=hseq->get_locus();
  String sm=mseq->get_locus();
  
  cout << "Processing gene " << i << ". HUMAN LOCUS: " << s << "; MOUSE LOCUS: " << sm <<  endl;
  int mseql = mseq->get_length(), hseql = hseq->get_length();
  assert(mseql && hseql);
  char hallalignbuf[100], mallalignbuf[100];
  strcpy(hallalignbuf, "/data2/rosetta/output/");
  strcpy(mallalignbuf, "/data2/rosetta/output/");
  
  strcpy(hallalignbuf+strlen(hallalignbuf), toa(i));            strcpy(hallalignbuf+strlen(hallalignbuf), "_");
  strcpy(mallalignbuf+strlen(mallalignbuf), toa(i));            strcpy(mallalignbuf+strlen(mallalignbuf), "_");
  strcpy(hallalignbuf+strlen(hallalignbuf), hseq->get_locus()); strcpy(hallalignbuf+strlen(hallalignbuf), "_Global_Alignment_H");
  strcpy(mallalignbuf+strlen(mallalignbuf), mseq->get_locus()); strcpy(mallalignbuf+strlen(mallalignbuf), "_Global_Alignment_M");
  char mouseBuf[100];
  strcpy(mouseBuf, "/data2/rosetta/output//");
  strcpy(mouseBuf+strlen(mouseBuf), toa(i));
  strcpy(mouseBuf+strlen(mouseBuf), "_");
  strcpy(mouseBuf+strlen(mouseBuf), s);
  strcpy(mouseBuf+strlen(mouseBuf), "_Visual_Alignment");
  ifstream visalign(mouseBuf);
  char houtbuf[100];
  strcpy(houtbuf, "/data2/rosetta/output/");
  strcpy(houtbuf+strlen(houtbuf), toa(i)); 
  strcpy(houtbuf+strlen(houtbuf), "_");
  strcpy(houtbuf+strlen(houtbuf), hseq->get_locus()); 
  strcpy(houtbuf+strlen(houtbuf), "_Parse");
  ifstream prexon(houtbuf);
  ifstream halignFin(hallalignbuf), halignFinCopy(hallalignbuf);
  ifstream malignFin(mallalignbuf), malignFinCopy(mallalignbuf); 
  Modules *hmod = new Modules(hseq, reg);
  Modules *mmod = new Modules(mseq, reg);
  hmod->setImages(halignFin, malignFin);
  mmod->setImages(malignFinCopy, halignFinCopy);
  hmod->setAligningRegions(halignFin);
  mmod->setAligningRegions(malignFin);

  ifstream hexon(argv[2]);
  ifstream mexon(argv[3]);
    
  int *hpos = new int[hseql + mseql+2];
  int *mpos = new int[hseql + mseql+2];
  int *sim  = new int[hseql + mseql+2];
  int *hex  = new int[hseql + mseql+2];
  int *mex  = new int[hseql + mseql+2];
  int *prex = new int[hseql + mseql+2];
 
  arrayZero(hpos, hseql+ mseql+2);
  arrayZero(mpos, hseql+ mseql+2);
  arrayZero(sim,  hseql+ mseql+2);
  arrayZero(hex,  hseql+ mseql+2);
  arrayZero(mex,  hseql+ mseql+2);
  arrayZero(prex, hseql+ mseql+2);

  int *dummyhex = new int[hseql+1];
  int *dummymex = new int[mseql+1];
  int *dummyprex = new int[hseql+1];

  arrayZero(dummyhex, hseql+1);
  arrayZero(dummymex, mseql+1);
  arrayZero(dummyprex, hseql+1);

  int regbegin=0, regend, regframe, regdir;
  do {
    hexon >> regbegin;
    hexon >> regend;
    hexon >> regframe;
    hexon >> regdir;
    if (regbegin >= 0) {
      assert(regend > regbegin);
      for (i=regbegin; i<=regend; ++i) 
	dummyhex[i] = (regdir == 1) ? 1 : -1;
    }
  } while (regbegin >= 0);
  do {
    mexon >> regbegin;
    mexon >> regend;
    mexon >> regframe;
    mexon >> regdir;
    if (regbegin >= 0) {
      assert(regend > regbegin);
      for (i=regbegin; i<=regend; ++i) 
	dummymex[i] = (regdir == 1) ? 1 : -1;
    }
  } while (regbegin >= 0);
  do {
    prexon >> regbegin;
    prexon >> regend;
    prexon >> regframe;
    if (regbegin >= 0) {
      assert(regend > regbegin);
      for (i=regbegin; i<=regend; ++i) 
	dummyprex[i] = 1;
    }
  } while (regbegin >= 0);
  
  int *dummyhsim = new int[hseql+1];
  int *dummymsim = new int[mseql+1];
  arrayZero(dummyhsim, hseql+1);
  arrayZero(dummymsim, hseql+1);
  
  int currmatch;
  for (i=1; i<hseql+1; ++i) {
    currmatch = 0;
    for (j=MAX(1,i-20); j<=MIN(i+20, hseql); ++j) 
      currmatch += (hmod->humImg[j] >= 0) ? ((hmod->m_seq->get(j) == mmod->m_seq->get(hmod->humImg[j])) ? 1 : 0) : 0;
    dummyhsim[i] = currmatch;
  }
  for (i=1; i<mseql+1; ++i) {
    currmatch = 0;
    for (j=MAX(1,i-20); j<=MIN(i+20, mseql); ++j) 
      currmatch += (mmod->humImg[j] >= 0) ? ((mmod->m_seq->get(j) == mmod->m_seq->get(mmod->humImg[j])) ? 1 : 0) : 0;
    dummymsim[i] = currmatch;
  }

  i=0;
  char buf[100];
  int hptr = 0, mptr = 0;
  bool nogap;
  while (visalign.good()) {
    nogap = true;
    visalign >> buf;
    if (!visalign.good()) break;
    if (buf[0] == '|') {
      visalign >> buf;
      assert(buf[0] == 'a' || buf[0] == 'c' || buf[0] == 'g' || buf[0] == 't');
      visalign >> buf;

      assert(++mptr == atoi(buf));
      
      hpos[i] = hptr;
      mpos[i] = mptr;
      sim[i] = dummymsim[mptr];
      hex[i] = (dummyhex[hptr] && (hptr < hseql) && dummyhex[hptr+1]) ? dummyhex[hptr] : 0;
      mex[i] = dummymex[mptr];
      prex[i] = (dummyprex[hptr] && (hptr < hseql) && dummyprex[hptr+1]) ? dummyprex[hptr] : 0;
      nogap = false;
    }
    else {
      assert(++hptr == atoi(buf));

      visalign >> buf;
      assert(buf[0] == 'a' || buf[0] == 'c' || buf[0] == 'g' || buf[0] == 't');
      visalign >> buf;
      if (buf[0] == '-') visalign >> buf;

      if (buf[0] == '|') {
	hpos[i] = hptr;
	mpos[i] = mptr;
	sim[i] = dummyhsim[hptr];
	hex[i] = dummyhex[hptr];
	mex[i] = (dummymex[mptr] && (mptr < mseql) && dummymex[mptr+1]) ? dummymex[mptr] : 0;
	prex[i] = dummyprex[hptr];
	nogap = false;
      }
      else {
	visalign >> buf;
	assert(++mptr == atoi(buf));
	hpos[i] = hptr;
	mpos[i] = mptr;
	sim[i] = (1+dummyhsim[hptr]+dummymsim[mptr])/2;
	hex[i] = dummyhex[hptr];
	mex[i] = dummymex[mptr];
	prex[i] = dummyprex[hptr];
      }
    }
    if (nogap) cout << hpos[i] << '\t' << mpos[i] << '\t' << sim[i] << '\t' << hex[i] << '\t'
		    << mex[i] << '\t' << prex[i] << endl;
    i++;
  }
}







