#include "/cpp/users/val/Dictionary/current_version/dictionary.h"

int main (void)
{
  Dictionary *repbase, *owl;
  char name[128], *seq = (char *) malloc (SEQ_BUFFER_LEN);

  if (!seq) 
    {
      printf ("Out of memory!\n");
      exit (1);
    }

  repbase = new Dictionary ("/data/dictionaries/repbase/allProtein", name);
  if (name[0])
    {
      printf ("Problem with repbase dictionary: %s\n", name);
      exit (1);
    }

  owl = new Dictionary ("/data/databases/dbOWL/owl", name);
  if (name[0])
    {
      printf ("Problem with owl dictionary: %s\n", name);
      exit (1);
    }

  const unsigned long int numseq = owl->numSequences ();

  for (unsigned long int i = 0; i < numseq; i++)
    {
      ivector<unsigned long int> acc, len, poss, posp;

      owl->getSequenceName (i, name);
      owl->getSequence (i, seq);
      repbase->Segments (seq, strlen (seq), 8, poss, posp, len, acc);
      for (unsigned long int q = 0; q < len.size (); q++)
	memset (seq + poss[q], '-', len[q]);

      printf ("%s\n%s\n\n", name, seq);
    }

  delete (repbase);
  delete (owl);
  free (seq);
}



