#include "makeranks.h"

Dictionary *owl;
char *seq; // = (char *) malloc (1 << 22);

// char aa_char_num[256] = {
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA,  A, AA,  C,  D,  E,  F,  G,  H,  I, AA,  K,  L,  M,  N, AA,
//   P,  Q,  R,  S,  T, AA,  V,  W, AA,  Y, AA, AA, AA, AA, AA, AA,
//   AA,  A, AA,  C,  D,  E,  F,  G,  H,  I, AA,  K,  L,  M,  N, AA,
//   P,  Q,  R,  S,  T, AA,  V,  W, AA,  Y, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA,
//   AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA, AA
//};

inline unsigned long int numtup (char *str, unsigned long int n, unsigned long int bad)
{
  unsigned long int index = 0;

  for (unsigned long int j = 0; j < n; j++)
    if (str[j] == AA)
      return (bad);
    else
      index = (index * 20) + str[j];  

  return (index);
}

void makeranks (unsigned long int n, char *fname)
{  
  unsigned long int last = 1, *array, index;
  for (unsigned long int i = 0; i < n; i++) last *= 20;

  FILE *f = fopen (fname, "w");
  if (!f) { printf ("Could not open file.\n"); exit (1); }

  if (!(array = (unsigned long int *) malloc (last * 4))) 
    { printf ("Out of memory!\n"); exit (1); }

  memset (array, 0, last * 4);  

  for (unsigned long int q = 0; q < owl->numSequences (); q++)
    {
      owl->getSequence (q, seq);
      unsigned long int i, len = strlen (seq);

      if (len >= n)
	{
	  for (i = 0; i < len; i++) seq[i] = aa_char_num[seq[i]];
	  for (i = 0; i < len - n + 1; i++)
	    if ((index = numtup (seq+i, n, last)) != last)
	      array[index]++;
	}
    }

  fwrite (array, 4, last, f);
  free (array);
  fclose (f);
}

unsigned long int tupfreq (char *tup, unsigned long int n, FILE *f)
{
  unsigned long int t = numtup (tup, n, ULONG_MAX);
  if (t != ULONG_MAX)
    {
      fseek (f, t << 2, SEEK_SET);
      fread (&t, 1, 4, f);
    }

  return (t);
}

/*
int main (void)
{

  cout.precision(15);
  
    if (!seq) { printf ("Out of memory.\n"); exit (1); }
    owl = new Dictionary ("/data/tmp/owl", seq);
    if (seq[0]) { printf ("%s\n", seq); exit (1); }
    
    makeranks (4, "rank.four");
    makeranks (5, "rank.five");
    
    delete (owl);
    free (seq);
 

  FILE *ranks4 = fopen("rank.four","r");
  FILE *ranks5 = fopen("rank.five","r");

  int totals = 0;
  int tsz = power(20,4);
  for (int i=0; i<tsz; ++i) {
    int t=i;
    fseek(ranks4, t<<2, SEEK_SET);
    fread(&t, 1, 4, ranks4);
    t = max(t,1);
    totals += t;
  }
  cout << "Computed totals for 4tuples: " << totals << endl;
  double totSums = 0;
  for (int i=0; i<tsz; ++i) {
    int t=i;
    fseek(ranks4, t<<2, SEEK_SET);
    fread(&t, 1, 4, ranks4);
    t = max(t,1);
    totSums += ((double)t/(double)totals) * log((double)t/(double)totals);
  }
  cout << "Computed total sum plogp for 4tuples: " << totSums << endl;


  totals = 0;
  tsz = power(20,5);
  for (int i=0; i<tsz; ++i) {
    int t=i;
    fseek(ranks5, t<<2, SEEK_SET);
    fread(&t, 1, 4, ranks5);
    totals += max(t,1);
  }
  cout << "Computed totals for 5tuples: " << totals << endl;
  totSums = 0;
  int totalZeros = 0;
  for (int i=0; i<tsz; ++i) {
    int t=i;
    fseek(ranks5, t<<2, SEEK_SET);
    fread(&t, 1, 4, ranks5);
    if (t==0) totalZeros++;
    t = max(t,1);
    totSums += ((double)t/(double)totals) * log((double)t/(double)totals);
  }
  cout << "Computed total sum plogp for 5tuples: " << totSums << endl;
  cout << "Total Entries that are 0: " << totalZeros << endl;
}






*/
