

#ifndef __MAINPROG_CC_
#define __MAINPROG_CC_

#include "mainprog.h"

int allow(String* ip) {
//   Registry *reg=new Registry();
//   ifstream regfile("paramsfile3");
//   regfile >> (*reg);
//   regfile.close();
//   ifstream allowList(reg->lookupVal("allowList"));
//   String ipAllowString;
//   while(readline(allowList,ipAllowString)) {
//     Regex ipAllowed(ipAllowString.chars());
//     if (ip->matches(ipAllowed)) return true;
//   }
//   return false;
  ip=ip;
  return true;
}


int main_program(String* ip, char *request, char **answer) {

  if (!allow(ip)) {
    cout << "Connection DENIED!" << endl;
    *answer = new char[1];
    *answer[0]='\254';
    return 1;
  }  

  cout << "ID: " << (int)(((unsigned char*)request)[0]) << endl;
  cout << "Request: " << (int)(((unsigned char*)request)[1]) << endl;
  // cout << "Message: " << request+2 << endl;
  
  // request 1 handles a registry request from the client;
  
  if (((unsigned char*)request)[1]==1) {
    
    Registry *reg=new Registry();
    ifstream regfile("paramsfile3");
    regfile >> (*reg);
    regfile.close();    
    
    String s,temp;
    ifstream configfile(reg->lookupVal("javaConfigFile"));
    while (readline(configfile,temp)) s+=temp+'\n';
    configfile.close();
    delete reg;

    *answer=new char[s.length()+3];
    memcpy(*answer,s.chars()-2,s.length()+3);
    (*answer)[0]=0;
    (*answer)[1]=request[1];
    (*answer)[s.length()+2]='\0';
    return s.length()+3;

  }

  // request 2 handles a gene request from the client;
  if (((unsigned char*)request)[1]==2) {
  
    Registry *reg=new Registry();
    ifstream regfile("paramsfile3");
    regfile >> (*reg);
    regfile.close();

    String args(request+2);
    String newargs, thisarg;
    while (args!="") {
      if (args.contains(" ")) thisarg=args.before(" ");
      else thisarg=args;
      newargs+=thisarg+"\n";
      reg->erase(thisarg.before("="));
      (*reg).add(thisarg.before("="),thisarg.after("="));
      args=args.after(" ");
    }
 
    ofstream currRegFile("currRegFile");
    currRegFile << (*reg);
    currRegFile.close();

    ifstream seqfile(reg->lookupVal("geneDatabase"));
    FilterSequence *fseq=new FilterSequence();
    cout << "Reading " << reg->lookupVal("geneDatabase") << "... " << endl;
    if(reg->lookupVal("selectType").contains("number")){
      for(int i=0;i<atoi(reg->lookupVal("sequenceNumber"));i++) 
	if (!(seqfile >> *fseq).good()) {
	  delete fseq;
	  delete reg;
	  *answer = new char[1];
	  *answer[0]='\254';
	  return 1;
	}
    }
    else {
       seqfile >> *fseq;
       while((String)fseq->get_locus()!=reg->lookupVal("geneLocus"))
	 seqfile >> *fseq;
    }
    if(reg->lookupVal("geneOrientation").contains("ReverseComplement")){
      fseq->reverse_complement();
    }
    // cout << *fseq;
    Modules *module=new Modules(fseq,reg);
    module->loadTupleTable(reg->lookupVal("tupleTable").chars(),reg); 
    cout << "Running windowframe... " << endl;
    module->computeWindowFrameScores(reg);
    cout << "Computing Intron vs. Exon Probabilities... " << endl;
    module->computeIntronExonProb();
    
    module->frameScoreMatrixFind(reg); // Calculate frameScore matrix
    
    Parse **parsetot = new (Parse*)[2];
    parsetot[0]=parsetot[1]=NULL;
    int numparses=2;
    
    //module->outputWindowFrame(reg);
    
    // Parse generation decision are made here;
    
    if (reg->lookupVal("generateParse").contains("frametest")) {
      numparses=3;
      parsetot[0]=module->newGenerateParse(reg); // Generate a parse
      reg->change("frameTestWeightIntron","0");
      reg->change("penalty","1");
      reg->change("scoreMethod","Max");
      module->frameScoreMatrixFind(reg); // Calculate frameScore matrix
      parsetot[1]=module->newGenerateParse(reg); // Generate a parse
      module->outputParse(parsetot[0],reg);
    }
    
    if (reg->lookupVal("generateParse").contains("protein") || reg->lookupVal("generateParse").contains("cDNA")){
      numparses=2;
      parsetot[0]=module->newGenerateParse(reg); // Generate a parse
      module->outputParse(parsetot[0],reg);
    }
    
    if (reg->lookupVal("generateParse").contains("both")) {
      numparses=3;
      reg->change("generateParse","frametest");
      parsetot[0]=module->newGenerateParse(reg);
      reg->change("generateParse","protein");
      parsetot[1]=module->newGenerateParse(reg); 
      module->outputParse(parsetot[0],reg);
    }
    
    if (reg->lookupVal("generateParse").contains("mouse")) {
      numparses=2;
      
      ifstream mouseSeqF(reg->lookupVal("mouseGeneDatabase"));
      /* FilterSequence *mouseSeq=new FilterSequence();
      cout << "Reading " << reg->lookupVal("mouseGeneDatabase") << "... " << endl;
            if(reg->lookupVal("selectType").contains("number"))
	for(int i=0;i<atoi(reg->lookupVal("sequenceNumber"));i++) 
	  if (!(mouseSeqF >> *mouseSeq).good()) assert(FALSE);
      */
      //parsetot[0]=module->mouseGenerateParse(reg);
      module->outputParse(parsetot[0],reg);
    }
    
    if (reg->lookupVal("generateParse").contains("none")) {
      numparses=2;
      parsetot[0]=new Parse;
    }
    
    cout << "Outputting to java program..." << endl;
    ostrstream javaOutput;
    ofstream foobar("foobar.txt");
    module->printResults(javaOutput, parsetot, numparses, reg);
    foobar.close();

    cout << "Done outputting to java program..." << endl;
    *answer=new char[javaOutput.pcount()+2];
    memcpy(*answer,javaOutput.str()-2,javaOutput.pcount()+1);
    (*answer)[javaOutput.pcount()+1]='\0';
    (*answer)[0]=request[0];
    (*answer)[1]=request[1];

    ofstream javaOutputFile(reg->lookupVal("javaOutputFile"));
    javaOutputFile << *answer << endl;
    javaOutputFile.close();
  
    delete parsetot[0];
    delete parsetot[1];
    delete[] parsetot;
    delete module;
    delete reg;
    delete fseq;

    cout << "Size of file: " << javaOutput.pcount()+2 << endl;
    return javaOutput.pcount()+2;
  }
  
  *answer=new char[1];
  *answer[0]='\253';
  return 1;
}
#endif










