#ifndef __IVECTOR_H
#define __IVECTOR_H

/*

===============================
iVector Class v6.03, April 1999
Valentin I. Spitkovsky (val@theory.lcs.mit.edu)

MIT Laboratory for Computer Science
Theory of Computation: Computational Biology
Gene Recognition Group
======================

*/

//#define IDEBUG

#define IV0 32

template <class T> class ivector 
{

private:

  static const unsigned long int sz = sizeof (T);
  unsigned long int n, slots;
  T *array;

 public:

  inline ivector (void)
    {
      n = 0;
      array = (T *) malloc ((slots = IV0) * sz);
      #ifdef IDEBUG 
      if (!array) printf ("iVector Constructor: Out of Memory!\n"); 
      #endif
    }

  inline ~ivector (void)
    {
      #ifdef IDEBUG 
      if (array)
      #endif
      free (array);
    }

  inline unsigned long int size (void) const 
    { 
      return (n); 
    }

  inline T& operator[] (const unsigned long int index) const
    {
      #ifdef IDEBUG 
      if (index > n) printf ("iVector []: Out of Bounds!\n");
      #endif
      return (array[index]);
    } 

  inline void push_back (const T element)
    {
      if (n == slots) array = (T *) realloc (array, (slots <<= 1) * sz);
      #ifdef IDEBUG 
      if (!array) printf ("iVector Constructor: Out of Memory!\n"); 
      #endif      
      array[n++] = element;
    }

  inline T* address (const unsigned long int index) const
    {
      return (array + index);
    }
  
  inline void clear (void) 
    {
      #ifdef IDEBUG 
      if (array) 
      #endif
      free (array);

      n = 0;
      array = (T *) malloc ((slots = IV0) * sz);            

      #ifdef IDEBUG 
      if (!array) printf ("iVector Constructor: Out of Memory!\n"); 
      #endif 
    }
};

#endif
