#ifndef __IBITS_H
#define __IBITS_H

/*

=====================================
iBits Class v6.03, April 1999
Valentin I. Spitkovsky (val@theory.lcs.mit.edu)

MIT Laboratory for Computer Science
Theory of Computation: Computational Biology
Gene Recognition Group
======================

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "internals.h"

//#define NOBITS

class iBits
{

private:

  FILE *f;
  int bbits;
  const int sbits;
  const char mask8;
  unsigned long int buffer;
  const unsigned long int mask32;

public:

  int write8 (const unsigned long int n, 
	      unsigned char *a);

  int write32 (const unsigned long int n, 
	       unsigned long int *a);
  
  int read8 (const unsigned long int n, 
	     unsigned char *a,
	     const unsigned long int offset) const;

  int read32 (const unsigned long int n, 
	      unsigned long int *a,
	      const unsigned long int offset) const;

  int flush8 (void);
  int flush32 (void);

  iBits (const char bits, const FILE *fptr);
  ~iBits ();

  static void binstr (const unsigned long int n, 
		      unsigned int len,
		      char *str);

  static unsigned int cap2 (const unsigned long int n);
};

#endif

