#include "ibits.h"

#define CALL_WRITE_BODY(MASK,BLOCK) \
WRITE_BODY(MASK,BLOCK,(int)((1<<BLOCK)-1),(int)(BLOCK-3),(int)(1<<BLOCK))

#define WRITE_BODY(MASK,WDTH,ONES,BYTS,MAXM) \
{ \
  unsigned long int i = 0, cur = 1; \
\
  for (; i < n && cur; i++) \
    { \
      const int now = MAXM - bbits; \
\
      if (sbits <= now) \
        { \
          buffer |= ((a[i]&MASK) << (now - sbits)); \
          bbits += sbits; \
        } \
      else \
        { \
	  bbits = sbits - now; \
  	  buffer |= (a[i] >> bbits); \
	  if (!(fwrite (&buffer, 1 << BYTS, 1, f))) return (-1); \
          a[cur = 0] = a[i] << (MAXM - bbits); \
        } \
    } \
\
  if (!cur) \
    { \
      for (; i < n; i++) \
        { \
          const int now = MAXM - bbits; \
\
          if (sbits <= now) \
            { \
              a[cur] |= ((a[i]&MASK) << (now - sbits)); \
              bbits += sbits; \
            } \
          else \
            { \
	      bbits = sbits - now; \
  	      a[cur++] |= (a[i] >> bbits); \
              a[cur] = a[i] << (MAXM - bbits); \
            } \
        } \
\
      buffer = a[cur]; \
      return (cur ? fwrite (a, 1 << BYTS, cur, f) != cur : 0); \
    } \
\
  return (0); \
}

#define CALL_READ_BODY(MASK,BLOCK) \
READ_BODY(MASK,BLOCK,(int)((1<<BLOCK)-1),(int)(BLOCK-3),(int)(1<<BLOCK))

#define READ_BODY(MASK,WDTH,ONES,BYTS,MAXM) \
{ \
  unsigned long int i; \
  const int shift = ((offset & ONES) * sbits) & ONES, shiftc = MAXM - shift; \
  const long double off = (long double)(offset) * (long double)(sbits) / (long double)(1 << WDTH); \
  const unsigned long int load = shift + n * sbits, sz = ((load&ONES) > 0) + (load >> WDTH), ok = iMIN(sz,n); \
\
  if (fseek (f, (unsigned long int)(off) << BYTS, SEEK_SET) || fread (a, 1 << BYTS, ok, f) != ok) return (-1); \
\
  if (shift) \
    { \
      const unsigned long int okm = ok - 1; \
\
      for (i = 0; i < okm; i++) a[i] = (a[i] << shift) | (a[i+1] >> shiftc); \
      a[okm] <<= shift; \
\
      if (ok < sz) \
        { \
          i = a[okm]; \
          if (!fread (a + okm, 1 << BYTS, 1, f)) return (-1); \
          a[okm] = i | (a[okm] >> shiftc); \
        } \
    } \
\
  unsigned long int pos = (i=n) * sbits; while (i--) \
    { \
      const unsigned long int index = (pos -= sbits) >> WDTH, bit = pos & ONES, now = MAXM - bit; \
      const long int later = sbits - now; \
      a[i] = (later <= 0 ? a[index] >> (now - sbits) : (a[index] << later) | (a[index+1] >> (MAXM - later))) & MASK; \
    } \
\
  return (0); \
}

int iBits::write8 (const unsigned long int n, 
		   unsigned char *a)
#ifdef NOBITS
{ return (n != fwrite (a, 1, n, f)); }
#else
CALL_WRITE_BODY(mask8,3)
#endif

int iBits::write32 (const unsigned long int n, 
		    unsigned long int *a)
#ifdef NOBITS
{ return (n != fwrite (a, 4, n, f)); }
#else
CALL_WRITE_BODY(mask32,5)
#endif

int iBits::read8 (const unsigned long int n, 
		  unsigned char *a,
		  const unsigned long int offset) const
#ifdef NOBITS
{ return (fseek (f, offset, SEEK_SET) || (n != fread (a, 1, n, f))); }
#else
CALL_READ_BODY(mask8,3)
#endif

int iBits::read32 (const unsigned long int n, 
		   unsigned long int *a,
                   const unsigned long int offset) const
#ifdef NOBITS
{ return (fseek (f, offset<<2, SEEK_SET) || (n != fread (a, 4, n, f))); }
#else
CALL_READ_BODY(mask32,5)
#endif

#define CALL_FLUSH_BODY(MASK,BLOCK) \
FLUSH_BODY(MASK,BLOCK,(int)((1<<BLOCK)-1),(int)(BLOCK-3),(int)(1<<BLOCK))

#define FLUSH_BODY(MASK,WDTH,ONES,BYTS,MAXM) \
{ \
  if (bbits) \
    { \
      if (!(fwrite (&buffer, 1 << BYTS, 1, f))) return (-1); \
      buffer = bbits = 0; \
    } \
\
  return (0); \
}


int iBits::flush8 (void)
#ifdef NOBITS
{ return (fflush (f)); }
#else
CALL_FLUSH_BODY(mask8,3)
#endif

int iBits::flush32 (void)
#ifdef NOBITS
{ return (fflush (f)); }
#else
CALL_FLUSH_BODY(mask32,5)
#endif

iBits::iBits (const char bits, const FILE *fptr) :
  sbits(bits),
  mask8((1<<bits)-1),
  mask32((1<<bits)-1)
{
  bbits = buffer = 0;
  f = (FILE *)fptr;
}

iBits::~iBits ()
{
  flush32 ();
}

void iBits::binstr (const unsigned long int n, 
		    const unsigned int len, 
		    char *str)
{
  memset (str, '0', len);
  str[len] = '\0';

  for (unsigned int k = 0; k < len; k++)
    str[len-(k+1)] += ((n >> k) & 1);
}

unsigned int iBits::cap2 (const unsigned long int n)
{
  unsigned int k;
  for (k = 0; n > (unsigned long int)(1<<k); k++);
  return (k);
}
