#include <fstream.h>
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "hameval.h"

HamEvaluator::HamEvaluator(int type) {

  switch (type) {
  case 0: {
    from = -3;
    to = 5;
    break;
  }
  case 1: {
    from = -1;
    to = 4;
    break;
  }
  case 2: {
    from = -1;
    to = 4;
    break;
  }
  default: break;
  }
  
  HamMatrix = generateMatrix(type);
  
}

int HamEvaluator::evaluate(Sequence* seq1, long pos1) {

  int score=0;
  Nucleotide nuc;

  if ((pos1+from <= 0 || pos1+to > seq1->get_length()))
    return (int)INF;
  
  for (int i=from; i<=to; i++) {
    if ((nuc = seq1->get(pos1+i)) != BASE_UNKNOWN)
      score += HamMatrix[nuc][i-from];
  }

  return score;
}


int** HamEvaluator::generateMatrix(int type) {

  switch (type) {

  case 0: {
    int **  matrixData = new (int*)[4];
    for (int i=0; i<4; i++) {
      matrixData[i] = new int[9];
    }

    matrixData[0][0]=0;
    matrixData[1][0]=0;
    matrixData[2][0]=1;
    matrixData[3][0]=1;
    
    matrixData[0][1]=0;
    matrixData[1][1]=1;
    matrixData[2][1]=1;
    matrixData[3][1]=1;
    
    matrixData[0][2]=5;
    matrixData[1][2]=5;
    matrixData[2][2]=0;
    matrixData[3][2]=5;
    
    matrixData[0][3]=1000;
    matrixData[1][3]=1000;
    matrixData[2][3]=0;
    matrixData[3][3]=1000;
    
    matrixData[0][4]=1000;
    matrixData[1][4]=1000;
    matrixData[2][4]=1000;
    matrixData[3][4]=0;
    
    matrixData[0][5]=0;
    matrixData[1][5]=7;
    matrixData[2][5]=7;
    matrixData[3][5]=7;
    
    matrixData[0][6]=0;
    matrixData[1][6]=1;
    matrixData[2][6]=0;
    matrixData[3][6]=1;
    
    matrixData[0][7]=4;
    matrixData[1][7]=4;
    matrixData[2][7]=0;
    matrixData[3][7]=4;
    
    matrixData[0][8]=1;
    matrixData[1][8]=1;
    matrixData[2][8]=1;
    matrixData[3][8]=0;
    
    return matrixData;
    break;
  }
  case 1: {

    int** matrixData = new (int*)[4];
    for (int i=0; i<4; i++)
      matrixData[i] = new int[6];

    matrixData[0][0] = 0;
    matrixData[1][0] = 1;
    matrixData[2][0] = 0;
    matrixData[3][0] = 1;

    matrixData[0][1] = 1;
    matrixData[1][1] = 1;
    matrixData[2][1] = 0;
    matrixData[3][1] = 1;

    matrixData[0][2] = 1;
    matrixData[1][2] = 1;
    matrixData[2][2] = 1;
    matrixData[3][2] = 0;
    
    matrixData[0][3] = 0;
    matrixData[1][3] = 1;
    matrixData[2][3] = 0;
    matrixData[3][3] = 1;

    matrixData[0][4] = 0;
    matrixData[1][4] = 1;
    matrixData[2][4] = 1;
    matrixData[3][4] = 1;

    matrixData[0][5] = 1;
    matrixData[1][5] = 1;
    matrixData[2][5] = 0;
    matrixData[3][5] = 1;

    return matrixData;
    break;
  }
  case 2: {
    int** matrixData = new (int*)[4];
    for (int i=0; i<4; i++)
      matrixData[i] = new int[6];

    matrixData[0][0] = 0;
    matrixData[1][0] = 1;
    matrixData[2][0] = 0;
    matrixData[3][0] = 1;

    matrixData[0][1] = 1;
    matrixData[1][1] = 1;
    matrixData[2][1] = 0;
    matrixData[3][1] = 1;

    matrixData[0][2] = 1;
    matrixData[1][2] = 1;
    matrixData[2][2] = 1;
    matrixData[3][2] = 0;
    
    matrixData[0][3] = 0;
    matrixData[1][3] = 1;
    matrixData[2][3] = 0;
    matrixData[3][3] = 1;

    matrixData[0][4] = 0;
    matrixData[1][4] = 0;
    matrixData[2][4] = 0;
    matrixData[3][4] = 0;

    matrixData[0][5] = 1;
    matrixData[1][5] = 1;
    matrixData[2][5] = 0;
    matrixData[3][5] = 1;
    return matrixData;
    break;
  }
  default: break;
  }

  return NULL;

}


HamEvaluator::~HamEvaluator() {

  for (int i=0; i<4; i++)
    delete[] HamMatrix[i];
  delete[] HamMatrix;
  
}











