#include "align.h"
#include "common.h"


const int the_tupLengths[14]  = { 45, 36, 30, 25, 20, 16, 12, 11, 10,  9,  8,  7,  6,  5 };
const int the_extnLengths[14] = { 10, 11, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 14 };
const int the_extnCutoffs[14] = {  4,  4,  5,  5,  5,  5,  5,  5,  3,  3,  3,  3,  3,  4 };


main(int argc, char *argv[]) {

  assert(argc == 3);

  ifstream hfile(argv[1]);
  ifstream mfile(argv[2]);

  FilterSequence *hseq, *mseq;
  hseq = new FilterSequence();
  mseq = new FilterSequence();

  hfile >> *hseq;
  mfile >> *mseq;

  int i;

  String hlocus = hseq->get_locus();
  String mlocus = mseq->get_locus();

  int mseql = mseq->get_length(), hseql = hseq->get_length();
  assert(mseql && hseql);
  fixUnknownNuc(hseq); fixUnknownNuc(mseq);
  
  int *humSeqInt   = new int[hseql+1]; seq2int(hseq, humSeqInt);
  int *mouseSeqInt = new int[mseql+1]; seq2int(mseq, mouseSeqInt);
    
  int *humImg   = new int[hseql+1]; arrayInit(-1,humImg,  hseql+1);
  int *mouseImg = new int[mseql+1]; arrayInit(-1,mouseImg,mseql+1);
  char *inval_hpos = new char[hseql+1]; arrayInit((char)0, inval_hpos, hseql+1);
  char *inval_mpos = new char[mseql+1]; arrayInit((char)0, inval_mpos, mseql+1);
  
  
  int minl = MIN(hseql, mseql);
  int phaseCount = 8;
  for (i=0; i<=6; ++i) if ( (16000 << i) > minl) break;
  phaseCount+= i;
  assert(phaseCount <= 14);
  
  int tupLengths[14], extnLengths[14], extnCutoffs[14];
  for (i=0; i<phaseCount; ++i) {
    tupLengths[i] = the_tupLengths[i+14-phaseCount];
    extnLengths[i] = the_extnLengths[i+14-phaseCount];
    extnCutoffs[i] = the_extnCutoffs[i+14-phaseCount];
   }
  
  /*
   
  int phaseCount = 9;
  int tupLengths[10]  = { 30, 25, 20, 16, 12,  9,  7,  6,  5};
  int extnLengths[10] = { 12, 12, 12, 12, 12, 12, 13, 13, 13};
  int extnCutoffs[10] = {  5,  5,  5,  3,  3,  3,  3,  3,  4};
  */


  //  phaseAlign(hseq, mseq, humSeqInt, mouseSeqInt, phaseCount, tupLengths, extnLengths, extnCutoffs, humImg, mouseImg);
  phaseAlign(hseq, mseq, humSeqInt, mouseSeqInt, phaseCount, tupLengths, extnLengths, extnCutoffs, humImg, mouseImg,
	     inval_hpos, inval_mpos, 1000000);
  for (i=1; i<=hseql; ++i) if (humImg[i] > 0) assert(humImg[i] <= mseql && mouseImg[humImg[i]] == i);

  char mouseBuf[100];
  /*
  strcpy(mouseBuf, hlocus); strcpy(mouseBuf+strlen(mouseBuf), "_");
  strcpy(mouseBuf+strlen(mouseBuf), mlocus);
  strcpy(mouseBuf+strlen(mouseBuf), "_Visual_Alignment");
  */
  
  strcpy(mouseBuf,"result");
  
  ofstream alignMouse(mouseBuf);
  outputAlignment(alignMouse, hseq, mseq, humImg, mouseImg);
}
