// This is a C++ header file

#ifndef __FSEQ_H__
#define __FSEQ_H__

#include <iostream.h>
#include <String.h>
#include "gseq.h"


// FilterSequence interface

// A DNA/RNA sequence with extended testing information

class FilterSequence : public GeneSequence {

public:

  // Construct and load from a stream
  FilterSequence(istream& cin);
 
  // Generic constructor/destructor
  FilterSequence();
  virtual ~FilterSequence();
  
  // Information finders
  bool CDS_Accurate(void);
  bool Region_Accurate(void);
  bool stops_In_Exon(void);
  double GC_percentage(void);
  
  double GC_exon_percentage(void);
  double GC_intron_percentage(void);
  double Minimum_Exon_Length(void);
  double Minimum_Intron_Length(void);


  bool CDS_matches(char *cds_file);

  void Filter_N_Entries(char *ifile, istream& cin, char *ofile, int N);
  void Filter_N_Entries(char *ifile, char *fdata, char *ofile, int N);
  void Filter_Database(char *ifile, istream& cin, char *ofile);
  void Filter_Database(char *ifile, char *fdata, char *ofile);
  void SortDatabase(char *infile, char *outfile, char *seqfile);
  void Create_Database(char *infile, char *outfile, istream& cin);
  void Create_Database(char *infile, char *outfile, char *datafile);
  void AccessionToLocus(char *infile, char *outfile, char *seqfile);
  char PT_lookup(const char* vals);
  char* DNAToProtein(const char* DNA);

protected:

  void initialize(void);
  void initialize_PT(void);
  void check_cds(void);
  void check_stops(void);
  void check_gc(void);
  void check_gc_exon(void);
  void check_gc_intron(void);
  void check_regions(void);
  bool PT_lookup(char, int[]);
  void unparse_header(ostream& cout);
  void parse(istream& cin);
  void filter_function(char *ifile, ostream& cout);
  bool filter(char *buf);
  bool filter_test(char *arg1, String arg2);
  bool found_good_locus(char *temploc);
  void check_minimum_exon_length(void);
  void check_minimum_intron_length(void);


private:

  bool CDS_accurate, stop_in_exon, region_accurate;
  double gc_percent;
  double gc_exon_percent;
  double gc_intron_percent;
  double minimum_exon_length;
  double minimum_intron_length;

  int numberof_loci;

  char ProteinTable[4][4][4];  // Table of "names" for each basepair triplet
  char **Loci;
  bool *found_this;
};

#endif // __FSEQ_H__

// End of header file




