#include "modules.h"


main(int argc, char* argv[]) {


  int i=0,j=0;
  
  FilterSequence *seq;

  ifstream fin(argv[1]);

  int *allCoding = new int[800000]; arrayInit(-1,allCoding,800000);
  int *allIntron = new int[800000]; arrayInit(-1,allIntron,800000);
  int cptr    = 0, iptr = 0;
  int genecnt = 0;
  int addedC  = 0;

  while (fin.good()) {
    seq = new FilterSequence();
    fin >> *seq;
    int codingl=0;
    for (i=1; i<=seq->get_region_num(); ++i)
      if (seq->get_region(i)->type == REGION_CEXON) codingl += seq->get_region(i)->length();
    
    cout << "Copying gene: " << ++genecnt;
    if (codingl%3) {
      cout << "  ...Bad gene" << endl;
      continue;
    }
    else cout << endl;

    while (cptr%3) {
      allCoding[cptr++] = BASE_C;
      addedC++;
    }
    for (i=1; i<=seq->get_region_num(); ++i) {
      Region *r = seq->get_region(i);
      if (r->type == REGION_CEXON) {
	int upto;
	if (isStopCodon(seq->get(r->stop-2), seq->get(r->stop-1), seq->get(r->stop))) upto = r->stop-3;
	else                                                                          upto = r->stop;
	
	for (j=r->start; j<=upto; ++j) {
	  if ( (allCoding[cptr] = seq->get(j)) == BASE_UNKNOWN) allCoding[cptr] = BASE_C;
	  cptr++;
	}
      }
      else if (r->type == REGION_INTRON && (rand()%4==0))
	for (j=r->start; j<=r->stop; ++j) {
	  if ( (allIntron[iptr] = seq->get(j)) == BASE_UNKNOWN) allIntron[iptr] = BASE_C;
	  iptr++;
	}
    }
    delete seq;
  }
  cout << "Done, number of coding nucleotides: " << cptr << "  (added " << addedC << " BASE_C nucleotides)." << endl;
  cout << "      number of intron nucleotides: " << iptr << endl;

  int fixed = 0;
  for (i=0; i<cptr-3; i+= 3)
    if (isStopCodon(allCoding[i], allCoding[i+1], allCoding[i+2])) {
      allCoding[rand()%3 + i] = BASE_C;
      fixed++;
    }
  cout << "Fixed " << fixed << " positions." << endl;
  for (i=0; i<cptr-3; i+= 3) 
    assert(! isStopCodon(allCoding[i], allCoding[i+1], allCoding[i+2]));
  cout << "Data looks good." << endl;

  ifstream tin("bigclean6tuples.tupleTBL");

  TupleTable tt(tin);
  cout << "Loaded tuple table." << endl;

  double *freqs0 = new double[cptr]; 
  double *freqs1 = new double[cptr];
  double *freqs2 = new double[cptr];
  double *freqsI = new double[cptr];

  double *Ifreqs0 = new double[iptr]; 
  double *Ifreqs1 = new double[iptr];
  double *Ifreqs2 = new double[iptr];
  double *IfreqsI = new double[iptr];

  int skips[6] = { 0, 0, 0, 0, 0, 0 };
  
  double totals0=0,  totals1=0,  totals2=0,  totalsI=0;
  double Itotals0=0, Itotals1=0, Itotals2=0, ItotalsI=0;

  for (i=0; i<=cptr-6; ++i) {
    int index = tuple_to_index(6, allCoding+i, skips);
    totals0 += (freqs0[i] = tt.tupleProbMinusOne(i%3 , index));
    totals1 += (freqs1[i] = tt.tupleProb((1+i) % 3   , index));
    totals2 += (freqs2[i] = tt.tupleProb((2+i) % 3   , index));
    totalsI += (freqsI[i] = tt.tupleProb(3           , index));
    
  }

  for (i=0; i<=iptr-6; ++i) {
    int index = tuple_to_index(6, allIntron+i, skips);
    Itotals0 += (Ifreqs0[i] = tt.tupleProb(i%3       , index));
    Itotals1 += (Ifreqs1[i] = tt.tupleProb((1+i) % 3 , index));
    Itotals2 += (Ifreqs2[i] = tt.tupleProb((2+i) % 3 , index));
    ItotalsI += (IfreqsI[i] = tt.tupleProbMinusOne(3 , index));
  }
  cout << "Calculated frequencies" << endl;
  cout << "totals: " << totals0 << "; " << totals1 << "; " << totals2 << "; " << totalsI << "; " << endl;
  cout << "Itotals: " << Itotals0 << "; " << Itotals1 << "; " << Itotals2 << "; " << ItotalsI << "; " << endl;
  
  int *cumStops0 = new int[cptr];
  int *cumStops1 = new int[cptr];
  int *cumStops2 = new int[cptr];

  int *IcumStops0 = new int[iptr];
  int *IcumStops1 = new int[iptr];
  int *IcumStops2 = new int[iptr];
  
  cumStops0[0] = cumStops1[0] = cumStops1[2] = 0;
  for (i=1; i<cptr; i++)
    if (i>cptr-6 || freqs0[i]>0) cumStops0[i] = cumStops0[i-1];
    else {
      cumStops0[i] = cumStops0[i-1]+1;
      int index = tuple_to_index(6, allCoding+i, skips);
      cout << "Wrong frequency=0 in index: " << index << "  , position: " << i << endl;
    }

  for (i=1; i<cptr; i++) 
    if (i>cptr-6 || freqs1[i]>0) cumStops1[i] = cumStops1[i-1];
    else                         cumStops1[i] = cumStops1[i-1]+1;

  for (i=1; i<cptr; i++) 
    if (i>cptr-6 || freqs2[i]>0) cumStops2[i] = cumStops2[i-1];
    else                         cumStops2[i] = cumStops2[i-1]+1;
  
  cout << "Cumulative stops: " << cumStops0[cptr-1] << " " << cumStops1[cptr-1] << " " << cumStops2[cptr-1] << endl;

  IcumStops0[0] = IcumStops1[0] = IcumStops1[2] = 0;
  for (i=1; i<iptr; i++) 
    if (i>iptr-6 || Ifreqs0[i]>0) IcumStops0[i] = IcumStops0[i-1];
    else                          IcumStops0[i] = IcumStops0[i-1]+1;
  
  for (i=1; i<iptr; i++) 
    if (i>iptr-6 || Ifreqs1[i]>0) IcumStops1[i] = IcumStops1[i-1];
    else                          IcumStops1[i] = IcumStops1[i-1]+1;

  for (i=1; i<iptr; i++) 
    if (i>iptr-6 || Ifreqs2[i]>0) IcumStops2[i] = IcumStops2[i-1];
    else                          IcumStops2[i] = IcumStops2[i-1]+1;
  
  cout << "ICumulative stops: " << IcumStops0[iptr-1] << " " << IcumStops1[iptr-1] << " " << IcumStops2[iptr-1] << endl;

  double *cumF0sums = new double[cptr]; cumF0sums[0] = freqs0[0];
  double *cumF1sums = new double[cptr]; cumF1sums[0] = freqs1[0];
  double *cumF2sums = new double[cptr]; cumF2sums[0] = freqs2[0];
  double *cumFIsums = new double[cptr]; cumFIsums[0] = freqsI[0];
  
  for (i=1; i<=cptr-6; ++i) {
    cumF0sums[i] = cumF0sums[i-1] + freqs0[i];
    cumF1sums[i] = cumF1sums[i-1] + freqs1[i];
    cumF2sums[i] = cumF2sums[i-1] + freqs2[i];
    cumFIsums[i] = cumFIsums[i-1] + freqsI[i];
  }
  for (; i<cptr; ++i) {
    cumF0sums[i] = cumF0sums[i-1];
    cumF1sums[i] = cumF1sums[i-1];
    cumF2sums[i] = cumF2sums[i-1];
    cumFIsums[i] = cumFIsums[i-1];
  }
  cout << "Computed cumulative frequency sums: " << cumF0sums[cptr-1] << " " << cumF1sums[cptr-1]
       << " " << cumF2sums[cptr-1] << " " << cumFIsums[cptr-1] << endl;


  double *IcumF0sums = new double[iptr]; IcumF0sums[0] = Ifreqs0[0];
  double *IcumF1sums = new double[iptr]; IcumF1sums[0] = Ifreqs1[0];
  double *IcumF2sums = new double[iptr]; IcumF2sums[0] = Ifreqs2[0];
  double *IcumFIsums = new double[iptr]; IcumFIsums[0] = IfreqsI[0];
  
  for (i=1; i<=iptr-6; ++i) {
    IcumF0sums[i] = IcumF0sums[i-1] + Ifreqs0[i];
    IcumF1sums[i] = IcumF1sums[i-1] + Ifreqs1[i];
    IcumF2sums[i] = IcumF2sums[i-1] + Ifreqs2[i];
    IcumFIsums[i] = IcumFIsums[i-1] + IfreqsI[i];
  }
  for (; i<iptr; ++i) {
    IcumF0sums[i] = IcumF0sums[i-1];
    IcumF1sums[i] = IcumF1sums[i-1];
    IcumF2sums[i] = IcumF2sums[i-1];
    IcumFIsums[i] = IcumFIsums[i-1];
  }
  cout << "Computed Icumulative frequency sums: " << IcumF0sums[iptr-1] << " " << IcumF1sums[iptr-1]
       << " " << IcumF2sums[iptr-1] << " " << IcumFIsums[iptr-1] << endl;

  double *cumF0logs = new double[cptr]; cumF0logs[0] = log(freqs0[0]);
  double *cumF1logs = new double[cptr]; cumF1logs[0] = log(freqs1[0]);
  double *cumF2logs = new double[cptr]; cumF2logs[0] = log(freqs2[0]);
  double *cumFIlogs = new double[cptr]; cumFIlogs[0] = log(freqsI[0]);

  for (i=1; i<=cptr-6; ++i) {
    cumF0logs[i] = (cumStops0[i] > cumStops0[i-1]) ? 0 : cumF0logs[i-1] + log(freqs0[i]);
    cumF1logs[i] = (cumStops1[i] > cumStops1[i-1]) ? 0 : cumF1logs[i-1] + log(freqs1[i]);
    cumF2logs[i] = (cumStops2[i] > cumStops2[i-1]) ? 0 : cumF2logs[i-1] + log(freqs2[i]);
    cumFIlogs[i] =                                       cumFIlogs[i-1] + log(freqsI[i]);

    assert(cumF0logs[i] + cumF1logs[i] + cumF2logs[i] + cumFIlogs[i] > -Infinity);
  }

  for (; i<cptr; ++i) {
    cumF0logs[i] = cumF0logs[i-1];
    cumF1logs[i] = cumF1logs[i-1];
    cumF2logs[i] = cumF2logs[i-1];
    cumFIlogs[i] = cumFIlogs[i-1];
  }
  cout << "Computed cumulative frequency logs: " << cumF0logs[cptr-1] << "  " << cumF1logs[cptr-1]
       << cumF2logs[cptr-1] << "  " << cumFIlogs[cptr-1] << endl;

  double *IcumF0logs = new double[iptr]; IcumF0logs[0] = log(Ifreqs0[0]);
  double *IcumF1logs = new double[iptr]; IcumF1logs[0] = log(Ifreqs1[0]);
  double *IcumF2logs = new double[iptr]; IcumF2logs[0] = log(Ifreqs2[0]);
  double *IcumFIlogs = new double[iptr]; IcumFIlogs[0] = log(IfreqsI[0]);

  for (i=1; i<=iptr-6; ++i) {
    IcumF0logs[i] = (IcumStops0[i] > IcumStops0[i-1]) ? 0 : IcumF0logs[i-1] + log(Ifreqs0[i]);
    IcumF1logs[i] = (IcumStops1[i] > IcumStops1[i-1]) ? 0 : IcumF1logs[i-1] + log(Ifreqs1[i]);
    IcumF2logs[i] = (IcumStops2[i] > IcumStops2[i-1]) ? 0 : IcumF2logs[i-1] + log(Ifreqs2[i]);
    IcumFIlogs[i] =                                         IcumFIlogs[i-1] + log(IfreqsI[i]);

    assert(IcumF0logs[i] + IcumF1logs[i] + IcumF2logs[i] + IcumFIlogs[i] > -Infinity);
  }

  for (; i<iptr; ++i) {
    IcumF0logs[i] = IcumF0logs[i-1];
    IcumF1logs[i] = IcumF1logs[i-1];
    IcumF2logs[i] = IcumF2logs[i-1];
    IcumFIlogs[i] = IcumFIlogs[i-1];
  }
  cout << "Computed Icumulative frequency logs: " << IcumF0logs[iptr-1] << "  " << IcumF1logs[iptr-1]
       << IcumF2logs[iptr-1] << "  " << IcumFIlogs[iptr-1] << endl;


  double *cumF0invs = new double[cptr]; cumF0invs[0] = 1/freqs0[0];
  double *cumF1invs = new double[cptr]; cumF1invs[0] = 1/freqs1[0];
  double *cumF2invs = new double[cptr]; cumF2invs[0] = 1/freqs2[0];

  for (i=1; i<=cptr-6; ++i) {
    cumF0invs[i] = (cumStops0[i] > cumStops0[i-1]) ? 0 : cumF0invs[i-1] + 1/freqs0[i];
    cumF1invs[i] = (cumStops1[i] > cumStops1[i-1]) ? 0 : cumF1invs[i-1] + 1/freqs1[i];
    cumF2invs[i] = (cumStops2[i] > cumStops2[i-1]) ? 0 : cumF2invs[i-1] + 1/freqs2[i];

    assert(cumF0invs[i] + cumF1invs[i] + cumF2invs[i] < Infinity);
  }

  for (; i<cptr; ++i) {
    cumF0invs[i] = cumF0invs[i-1];
    cumF1invs[i] = cumF1invs[i-1];
    cumF2invs[i] = cumF2invs[i-1];
  }
  cout << "Computed cumulative frequency invs: " << cumF0invs[cptr-1] << "  " << cumF1invs[cptr-1] << "  "
       << cumF2invs[cptr-1] << endl;

  double *IcumF0invs = new double[iptr]; IcumF0invs[0] = 1/Ifreqs0[0];
  double *IcumF1invs = new double[iptr]; IcumF1invs[0] = 1/Ifreqs1[0];
  double *IcumF2invs = new double[iptr]; IcumF2invs[0] = 1/Ifreqs2[0];

  for (i=1; i<=iptr-6; ++i) {
    IcumF0invs[i] = (IcumStops0[i] > IcumStops0[i-1]) ? 0 : IcumF0invs[i-1] + 1/Ifreqs0[i];
    IcumF1invs[i] = (IcumStops1[i] > IcumStops1[i-1]) ? 0 : IcumF1invs[i-1] + 1/Ifreqs1[i];
    IcumF2invs[i] = (IcumStops2[i] > IcumStops2[i-1]) ? 0 : IcumF2invs[i-1] + 1/Ifreqs2[i];

    assert(IcumF0invs[i] + IcumF1invs[i] + IcumF2invs[i] < Infinity);
  }

  for (; i<iptr; ++i) {
    IcumF0invs[i] = IcumF0invs[i-1];
    IcumF1invs[i] = IcumF1invs[i-1];
    IcumF2invs[i] = IcumF2invs[i-1];
  }
  cout << "Computed Icumulative frequency invs: " << IcumF0invs[iptr-1] << "  " << IcumF1invs[iptr-1] << "  "
       << IcumF2invs[iptr-1] << endl;

  double *ftprobs0 = new double[cptr]; for (i=0; i<cptr; ++i) ftprobs0[i] = cumF0sums[i] - cumFIsums[i];
  double *ftprobs1 = new double[cptr]; for (i=0; i<cptr; ++i) ftprobs1[i] = cumF1sums[i] - cumFIsums[i];
  double *ftprobs2 = new double[cptr]; for (i=0; i<cptr; ++i) ftprobs2[i] = cumF2sums[i] - cumFIsums[i];

  cout << "Computed cumulative frametest fi-I: " << ftprobs0[cptr-1] << "  " << ftprobs1[cptr-1] << "  "
       << ftprobs2[cptr-1] << endl;
    
  double *Iftprobs0 = new double[iptr]; for (i=0; i<iptr; ++i) Iftprobs0[i] = IcumF0sums[i] - IcumFIsums[i];
  double *Iftprobs1 = new double[iptr]; for (i=0; i<iptr; ++i) Iftprobs1[i] = IcumF1sums[i] - IcumFIsums[i];
  double *Iftprobs2 = new double[iptr]; for (i=0; i<iptr; ++i) Iftprobs2[i] = IcumF2sums[i] - IcumFIsums[i];

  cout << "Computed Icumulative frametest fi-I: " << Iftprobs0[iptr-1] << "  " << Iftprobs1[iptr-1] << "  "
       << Iftprobs2[iptr-1] << endl;
    
  double *ftrels0 = new double[cptr]; ftrels0[0] = (freqs0[0] - freqsI[0]) / (freqs0[0] + freqs1[0] + freqs2[0]);
  double *ftrels1 = new double[cptr]; ftrels1[0] = (freqs1[0] - freqsI[0]) / (freqs0[0] + freqs1[0] + freqs2[0]);
  double *ftrels2 = new double[cptr]; ftrels2[0] = (freqs2[0] - freqsI[0]) / (freqs0[0] + freqs1[0] + freqs2[0]);
  
  for (i=1; i<=cptr-6; ++i) {
    ftrels0[i] = (freqs0[i] - freqsI[i]) / (freqs0[i] + freqs1[i] + freqs2[i]) + ftrels0[i-1];
    ftrels1[i] = (freqs1[i] - freqsI[i]) / (freqs0[i] + freqs1[i] + freqs2[i]) + ftrels1[i-1];
    ftrels2[i] = (freqs2[i] - freqsI[i]) / (freqs0[i] + freqs1[i] + freqs2[i]) + ftrels2[i-1];
  }
  for (; i<cptr; ++i) {
    ftrels0[i] = ftrels0[i-1];
    ftrels1[i] = ftrels1[i-1];
    ftrels2[i] = ftrels2[i-1];
  }
  cout << "Computed cumulative frametest relative: " << ftrels0[cptr-1] << "  " << ftrels1[cptr-1] << "  "
       << ftrels2[cptr-1] << endl;


  double *Iftrels0 = new double[iptr]; Iftrels0[0] = (Ifreqs0[0] - IfreqsI[0]) / (Ifreqs0[0] + Ifreqs1[0] + Ifreqs2[0]);
  double *Iftrels1 = new double[iptr]; Iftrels1[0] = (Ifreqs1[0] - IfreqsI[0]) / (Ifreqs0[0] + Ifreqs1[0] + Ifreqs2[0]);
  double *Iftrels2 = new double[iptr]; Iftrels2[0] = (Ifreqs2[0] - IfreqsI[0]) / (Ifreqs0[0] + Ifreqs1[0] + Ifreqs2[0]);
  
  for (i=1; i<=iptr-6; ++i) {
    Iftrels0[i] = (Ifreqs0[i] - IfreqsI[i]) / (Ifreqs0[i] + Ifreqs1[i] + Ifreqs2[i]) + Iftrels0[i-1];
    Iftrels1[i] = (Ifreqs1[i] - IfreqsI[i]) / (Ifreqs0[i] + Ifreqs1[i] + Ifreqs2[i]) + Iftrels1[i-1];
    Iftrels2[i] = (Ifreqs2[i] - IfreqsI[i]) / (Ifreqs0[i] + Ifreqs1[i] + Ifreqs2[i]) + Iftrels2[i-1];
  }
  for (; i<iptr; ++i) {
    Iftrels0[i] = Iftrels0[i-1];
    Iftrels1[i] = Iftrels1[i-1];
    Iftrels2[i] = Iftrels2[i-1];
  }
  cout << "Computed Icumulative frametest relative: " << Iftrels0[iptr-1] << "  " << Iftrels1[iptr-1] << "  "
       << Iftrels2[iptr-1] << endl;

  delete[] allCoding;
  delete[] allIntron;

  delete[] freqs0;
  delete[] freqs1;
  delete[] freqs2;
  delete[] freqsI;
  delete[] Ifreqs0;
  delete[] Ifreqs1;
  delete[] Ifreqs2;
  delete[] IfreqsI;

  delete[] cumF0sums;
  delete[] cumF1sums;
  delete[] cumF2sums;
  delete[] cumFIsums;
  delete[] IcumF0sums;
  delete[] IcumF1sums;
  delete[] IcumF2sums;
  delete[] IcumFIsums;


  ofstream fout("frametestResultsAllperk.dat");
  fout.precision(10);

  for (int l = 9; l<=999; l += 9) {
    if (true) {
      cout << endl;
      cout << "Log freqs sums" << endl;
      double *ft1scoresE = new double[cptr];
      double *ft1scoresI = new double[iptr]; 
      int failedE[3] = {0, 0, 0}, failedI[3] = {0, 0, 0};
      int failedAllE = 0, failedAllI = 0;
      int wrongFrameGuesses=0;
      
      for (i=1; i<cptr-l; ++i) {
	if (cumStops0[i+l] - cumStops0[i-1]) {
	  failedE[0]++;
	  ft1scoresE[i] = -Infinity;
	}
	else ft1scoresE[i] = (cumF0logs[i+l] - cumF0logs[i-1]) + (cumFIlogs[i+l] - cumFIlogs[i-1]);
	
	if (cumStops1[i+l] - cumStops1[i-1]) failedE[1]++;
	else ft1scoresE[i] = MAX((cumF1logs[i+l] - cumF1logs[i-1]) + (cumFIlogs[i+l] - cumFIlogs[i-1]), ft1scoresE[i]);
	
	if (cumStops2[i+l] - cumStops2[i-1]) failedE[2]++;
	else ft1scoresE[i] = MAX((cumF2logs[i+l] - cumF2logs[i-1]) + (cumFIlogs[i+l] - cumFIlogs[i-1]), ft1scoresE[i]);
	
	if (ft1scoresE[i] == -Infinity) failedAllE++;
	if (ft1scoresE[i] > (cumF0logs[i+l] - cumF0logs[i-1]) + (cumFIlogs[i+l] - cumFIlogs[i-1])) wrongFrameGuesses++;
      }
      ft1scoresE[0] = ft1scoresE[1];
      
      for (i=1; i<iptr-l; ++i) {
	if (IcumStops0[i+l] - IcumStops0[i-1]) {
	  failedI[0]++;
	  ft1scoresI[i] = -Infinity;
	}
	else ft1scoresI[i] = (IcumF0logs[i+l] - IcumF0logs[i-1]) + (IcumFIlogs[i+l] - IcumFIlogs[i-1]);
	
	if (IcumStops1[i+l] - IcumStops1[i-1]) failedI[1]++;
	else ft1scoresI[i] = MAX((IcumF1logs[i+l] - IcumF1logs[i-1]) + (IcumFIlogs[i+l] - IcumFIlogs[i-1]), ft1scoresI[i]);
	
	if (IcumStops2[i+l] - IcumStops2[i-1]) failedI[2]++;
	else ft1scoresI[i] = MAX((IcumF2logs[i+l] - IcumF2logs[i-1]) + (IcumFIlogs[i+l] - IcumFIlogs[i-1]), ft1scoresI[i]);
	
	if (ft1scoresI[i] == -Infinity) failedAllI++;
      }
      ft1scoresI[0] = ft1scoresI[1];
      
      double minft1scoreE=Infinity, maxft1scoreE=-Infinity, avgE = 0;
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft1scoresE[i])) {
	  avgE += ft1scoresE[i];
	  minft1scoreE = MIN(minft1scoreE, ft1scoresE[i]);
	  maxft1scoreE = MAX(maxft1scoreE, ft1scoresE[i]);
	}
      
      double minft1scoreI=Infinity, maxft1scoreI=-Infinity, avgI = 0;
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft1scoresI[i])) {
	  avgI += ft1scoresI[i];
	  minft1scoreI = MIN(minft1scoreI, ft1scoresI[i]);
	  maxft1scoreI = MAX(maxft1scoreI, ft1scoresI[i]);
	}
      cout << "Min FT1 score on exons:   " << minft1scoreE << ";  \t MAX: " << maxft1scoreE << endl;
      cout << " failed " << failedE[0] << ", " << failedE[1] << ", " << failedE[2] << "   all: " << failedAllE << endl;
      cout << "Min FT1 score on introns: " << minft1scoreI << ";  \t MAX: " << maxft1scoreI << endl;
      cout << " failed " << failedI[0] << ", " << failedI[1] << ", " << failedI[2] << "   all: " << failedAllI << endl;
      
      double interval_a = MIN( minft1scoreE, minft1scoreI), interval_b = MAX(maxft1scoreE, maxft1scoreI);
      double interval   = (interval_b - interval_a) / 10000;
      
      cout << "  interval: ( " << interval_a << " , " << interval_b << " )" << endl;
      
      int histE[10002], histI[10002];
      arrayZero(histE, 10002);
      arrayZero(histI, 10002);
      
      histE[0] = failedAllE;
      histI[0] = failedAllI;
      
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft1scoresE[i])) {
	  assert((int) ( (ft1scoresE[i] - interval_a) / interval) >= 0 && (int) ( (ft1scoresE[i] - interval_a) / interval) < 10001);
	  histE[ (int) ( (ft1scoresE[i] - interval_a) / interval) + 1 ]++;
	}
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft1scoresI[i])) {
	  assert((int) ( (ft1scoresI[i] - interval_a) / interval) >= 0 && (int) ( (ft1scoresI[i] - interval_a) / interval) < 10001);
	  histI[ (int) ( (ft1scoresI[i] - interval_a) / interval) + 1 ]++;
	}
      int cumhistE[10002], cumhistI[10002];
      arrayZero(cumhistE, 10001); cumhistE[0] = histE[0];
      arrayZero(cumhistI, 10001); cumhistI[0] = histI[0];
      
      for (i=1; i<10002; ++i) {
	cumhistE[i] = cumhistE[i-1] + histE[i];
	cumhistI[i] = cumhistI[i-1] + histI[i];
      }
      
      int totalE = cumhistE[10001], totalI = cumhistI[10001];
      
      int separation1    = totalE, separation2    = totalI;
      int separationptr1 = 0,      separationptr2 = 0;
      
      for (i=1; i<=10001; ++i) {
	if (separation1 >  ( (totalE - cumhistE[i-1]) + cumhistI[i-1] ) ) {
	  separation1    = ( (totalE - cumhistE[i-1]) + cumhistI[i-1] );
	  separationptr1 = i;
	}
	if (separation2 >  ( (totalI - cumhistI[i-1]) + cumhistE[i-1] ) ) {
	  separation2    = ( (totalI - cumhistI[i-1]) + cumhistE[i-1] );
	  separationptr2 = i;
	}
      }
      double sep1,sep2;
      cout << "separation1: "   << (sep1 = (2*((double)separation1))/ ((double)(totalE+totalI)))
	   << "   separation2 " << (sep2 = (2*((double)separation2))/ ((double)(totalE+totalI))) << endl;
      cout << " Wrong frame guesses: " << ((double)wrongFrameGuesses)/((double)totalE) << endl;
      cout << "sep 1 at:    " << separationptr1 << "   sep 2 at:   " << separationptr2 << endl;
      cout << "total E: " << totalE << "   total I: " << totalI << endl;
      
      avgE /= (totalE-failedAllE);
      avgI /= (totalI-failedAllI);
      
      fout << l << "\t" << 1 << "\t" << MIN(sep1, sep2) << "\t" << ((double)wrongFrameGuesses)/((double)totalE)
	   << "\t" << ((double)wrongFrameGuesses)/((double)totalE) << "\t" << ((double)failedAllI)/((double)totalI)
	   << "\t" << avgE << "\t" << avgI << endl;
      
      delete[] ft1scoresE;
      delete[] ft1scoresI;
    }
    
    if (true) {
      cout << endl;
      cout << "Inverse freqs suns" << endl;
      
      double *ft2scoresE = new double[cptr];
      double *ft2scoresI = new double[iptr]; 
      int failedE[3] = {0, 0, 0}, failedI[3] = {0, 0, 0};
      int failedAllE = 0, failedAllI = 0;
      int wrongFrameGuesses=0;
      
      for (i=1; i<cptr-l; ++i) {
	if (cumStops0[i+l] - cumStops0[i-1]) {
	  failedE[0]++;
	  ft2scoresE[i] = Infinity;
	}
	else ft2scoresE[i] = (cumF0invs[i+l] - cumF0invs[i-1]);
	
	if (cumStops1[i+l] - cumStops1[i-1]) failedE[1]++;
	else ft2scoresE[i] = MIN((cumF1invs[i+l] - cumF1invs[i-1]), ft2scoresE[i]);
	
	if (cumStops2[i+l] - cumStops2[i-1]) failedE[2]++;
	else ft2scoresE[i] = MIN((cumF2invs[i+l] - cumF2invs[i-1]), ft2scoresE[i]);
	
	if (ft2scoresE[i] == Infinity) failedAllE++;
	if (ft2scoresE[i] < (cumF0invs[i+l] - cumF0invs[i-1])) wrongFrameGuesses++;
      }
      ft2scoresE[0] = ft2scoresE[1];
      
      for (i=1; i<iptr-l; ++i) {
	if (IcumStops0[i+l] - IcumStops0[i-1]) {
	  failedI[0]++;
	  ft2scoresI[i] = Infinity;
	}
	else ft2scoresI[i] = (IcumF0invs[i+l] - IcumF0invs[i-1]);
	
	if (IcumStops1[i+l] - IcumStops1[i-1]) failedI[1]++;
	else ft2scoresI[i] = MIN((IcumF1invs[i+l] - IcumF1invs[i-1]), ft2scoresI[i]);
	
	if (IcumStops2[i+l] - IcumStops2[i-1]) failedI[2]++;
	else ft2scoresI[i] = MIN((IcumF2invs[i+l] - IcumF2invs[i-1]), ft2scoresI[i]);
	
	if (ft2scoresI[i] == Infinity) failedAllI++;
      }
      ft2scoresI[0] = ft2scoresI[1];
      
      double minft2scoreE=Infinity, maxft2scoreE=-Infinity, avgE=0;
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft2scoresE[i])) {
	  avgE += ft2scoresE[i];
	  minft2scoreE = MIN(minft2scoreE, ft2scoresE[i]);
	  maxft2scoreE = MAX(maxft2scoreE, ft2scoresE[i]);
	}
      
      double minft2scoreI=Infinity, maxft2scoreI=-Infinity, avgI=0;
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft2scoresI[i])) {
	  avgI += ft2scoresI[i];
	  minft2scoreI = MIN(minft2scoreI, ft2scoresI[i]);
	  maxft2scoreI = MAX(maxft2scoreI, ft2scoresI[i]);
	}
      
      cout << "Min FT2 score on exons:   " << minft2scoreE << ";  \t MAX: " << maxft2scoreE << endl;
      cout << " failed " << failedE[0] << ", " << failedE[1] << ", " << failedE[2] << "   all: " << failedAllE << endl;
      cout << "Min FT2 score on introns: " << minft2scoreI << ";  \t MAX: " << maxft2scoreI << endl;
      cout << " failed " << failedI[0] << ", " << failedI[1] << ", " << failedI[2] << "   all: " << failedAllI << endl;
      
      double interval_a = MIN( minft2scoreE, minft2scoreI), interval_b = MAX(maxft2scoreE, maxft2scoreI);
      double interval   = (interval_b - interval_a) / 10000;
      
      cout << "  interval: ( " << interval_a << " , " << interval_b << " )" << endl;
      
      int histE[10002], histI[10002];
      arrayZero(histE, 10002);
      arrayZero(histI, 10002);
      
      histE[0] = 0;
      histI[0] = 0;
      
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft2scoresE[i])) {
	  assert((int) ( (ft2scoresE[i] - interval_a) / interval) >= 0 && (int) ( (ft2scoresE[i] - interval_a) / interval) < 10001);
	  histE[ (int) ( (ft2scoresE[i] - interval_a) / interval) + 1 ]++;
	}
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft2scoresI[i])) {
	  assert((int) ( (ft2scoresI[i] - interval_a) / interval) >= 0 && (int) ( (ft2scoresI[i] - interval_a) / interval) < 10001);
	  histI[ (int) ( (ft2scoresI[i] - interval_a) / interval) + 1 ]++;
	}
      int cumhistE[10002], cumhistI[10002];
      arrayZero(cumhistE, 10001); cumhistE[0] = histE[0];
      arrayZero(cumhistI, 10001); cumhistI[0] = histI[0];
      
      for (i=1; i<10001; ++i) {
	cumhistE[i] = cumhistE[i-1] + histE[i];
	cumhistI[i] = cumhistI[i-1] + histI[i];
      }
      cumhistE[10001] = cumhistE[10000] + failedAllE;
      cumhistI[10001] = cumhistI[10000] + failedAllI;
      
      int totalE = cumhistE[10001], totalI = cumhistI[10001];
      avgE /= (totalE-failedAllE);
      avgI /= (totalI-failedAllI);
      
      int separation1    = totalE, separation2    = totalI;
      int separationptr1 = 0,      separationptr2 = 0;
      
      for (i=1; i<=10001; ++i) {
	if (separation1 >  ( (totalE - cumhistE[i-1]) + cumhistI[i-1] ) ) {
	  separation1    = ( (totalE - cumhistE[i-1]) + cumhistI[i-1] );
	  separationptr1 = i;
	}
	if (separation2 >  ( (totalI - cumhistI[i-1]) + cumhistE[i-1] ) ) {
	  separation2    = ( (totalI - cumhistI[i-1]) + cumhistE[i-1] );
	  separationptr2 = i;
	}
      }
      double sep1,sep2;
      cout << "separation1: "   << (sep1=MIN(1.0,(2*((double)separation1))/ ((double)(totalE+totalI))))
	   << "   separation2 " << (sep2=MIN(1.0,(2*((double)separation2))/ ((double)(totalE+totalI)))) << endl;
      cout << " Wrong frame guesses: " << ((double)wrongFrameGuesses)/((double)totalE) << endl;
      cout << "sep 1 at:    " << separationptr1 << "   sep 2 at:   " << separationptr2 << endl;
      cout << "total E: " << totalE << "   total I: " << totalI << endl;
      
      fout << l << "\t" << 2 << "\t" << MIN(sep1, sep2) << "\t" << ((double)wrongFrameGuesses)/((double)totalE)
	   << "\t" << ((double)wrongFrameGuesses)/((double)totalE)
	   << "\t" << ((double)failedAllI)/((double)totalI) << "\t" << avgE << "\t" << avgI << endl;
      
      delete[] ft2scoresE;
      delete[] ft2scoresI;
    }
    
    
    if (true) {
      cout << endl;
      cout << "Freqs - FreqsIntron test" << endl;
      
      double *ft3scoresE = new double[cptr];
      double *ft3scoresI = new double[iptr]; 
      double *ft4scoresE = new double[cptr];
      double *ft4scoresI = new double[iptr]; 

      int failedAllE = 0, failedAllI = 0;
      int wrongFrameGuesses=0, wrongFrameGuesses2=0;
      
      for (i=1; i<cptr-l; ++i) {
	ft3scoresE[i] = ftprobs0[i+l] - ftprobs0[i-1];
	ft3scoresE[i] = MAX(ftprobs1[i+l] - ftprobs1[i-1], ft3scoresE[i]);
	ft3scoresE[i] = MAX(ftprobs2[i+l] - ftprobs2[i-1], ft3scoresE[i]);

	if (ft3scoresE[i] > ftprobs0[i+l] - ftprobs0[i-1]) wrongFrameGuesses++;
	
	if      ( (ft3scoresE[i] == ftprobs1[i+l] - ftprobs1[i-1]) && !(cumStops1[i+l]-cumStops1[i-1])) wrongFrameGuesses2++;
	else if ( (ft3scoresE[i] == ftprobs2[i+l] - ftprobs2[i-1]) && !(cumStops2[i+l]-cumStops2[i-1])) wrongFrameGuesses2++;

	if (cumStops0[i+l]-cumStops0[i-1] && cumStops1[i+l]-cumStops1[i-1] && cumStops2[i+l]-cumStops2[i-1]) {
	  ft3scoresE[i] = ft4scoresE[i] = -Infinity;
	  failedAllE++;
	}
	else {
	  ft4scoresE[i] = 3*ft3scoresE[i] - (ftprobs0[i+l] - ftprobs0[i-1]) - (ftprobs1[i+l] - ftprobs1[i-1]) - (ftprobs2[i+l] - ftprobs2[i-1]);
	  
	  ft3scoresE[i] = -Infinity;
	  if (!(cumStops0[i+l]-cumStops0[i-1])) { ft3scoresE[i] = ftprobs0[i+l] - ftprobs0[i-1]; }
	  if (!(cumStops1[i+l]-cumStops1[i-1])) { ft3scoresE[i] = MAX(ftprobs1[i+l] - ftprobs1[i-1], ft3scoresE[i]); }
	  if (!(cumStops2[i+l]-cumStops2[i-1])) { ft3scoresE[i] = MAX(ftprobs2[i+l] - ftprobs2[i-1], ft3scoresE[i]); } 
	  
	  ft3scoresE[i] = 3*ft3scoresE[i] - (ftprobs0[i+l] - ftprobs0[i-1]) - (ftprobs1[i+l] - ftprobs1[i-1]) - (ftprobs2[i+l] - ftprobs2[i-1]);
	}
      }
      ft3scoresE[0] = ft3scoresE[1];
      ft4scoresE[0] = ft4scoresE[1];
      
      for (i=1; i<iptr-l; ++i) {
	ft3scoresI[i] = MAX(MAX(Iftprobs0[i+l]-Iftprobs0[i-1], 
				Iftprobs1[i+l]-Iftprobs1[i-1]), Iftprobs2[i+l] - Iftprobs2[i-1]);

	if (IcumStops0[i+l]-IcumStops0[i-1] && IcumStops1[i+l]-IcumStops1[i-1] && IcumStops2[i+l]-IcumStops2[i-1]) {
	  ft3scoresI[i] = ft4scoresI[i] = -Infinity;
	  failedAllI++;
	}
	else {
	  ft4scoresI[i] = 3*ft3scoresI[i] - (Iftprobs0[i+l] - Iftprobs0[i-1]) - (Iftprobs1[i+l] - Iftprobs1[i-1]) - (Iftprobs2[i+l] - Iftprobs2[i-1]);
	  
	  ft3scoresI[i] = -Infinity;
	  if (!(IcumStops0[i+l]-IcumStops0[i-1])) { ft3scoresI[i] = Iftprobs0[i+l] - Iftprobs0[i-1]; }
	  if (!(IcumStops1[i+l]-IcumStops1[i-1])) { ft3scoresI[i] = MAX(Iftprobs1[i+l] - Iftprobs1[i-1], ft3scoresI[i]); }
	  if (!(IcumStops2[i+l]-IcumStops2[i-1])) { ft3scoresI[i] = MAX(Iftprobs2[i+l] - Iftprobs2[i-1], ft3scoresI[i]); } 
	  
	  ft3scoresI[i] = 3*ft3scoresI[i] - (Iftprobs0[i+l] - Iftprobs0[i-1]) - (Iftprobs1[i+l] - Iftprobs1[i-1]) - (Iftprobs2[i+l] - Iftprobs2[i-1]);
	}
      }
      ft3scoresI[0] = ft3scoresI[1];
      ft4scoresI[0] = ft4scoresI[1];
      
      double minft3scoreE=Infinity, minft3perkE = Infinity, maxft3scoreE=-Infinity, maxft3perkE = -Infinity, avgE=0, avgEperk=0;
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft3scoresE[i])) {
	  avgE += ft3scoresE[i];
	  avgEperk += ft4scoresE[i];
	  minft3scoreE = MIN(minft3scoreE, ft3scoresE[i]);
	  maxft3scoreE = MAX(maxft3scoreE, ft3scoresE[i]);
	  minft3perkE = MIN(minft3perkE, ft4scoresE[i]);
	  maxft3perkE = MAX(maxft3perkE, ft4scoresE[i]);
	}
      double minft3scoreI=Infinity, minft3perkI = Infinity, maxft3scoreI=-Infinity, maxft3perkI = -Infinity, avgI=0, avgIperk=0;
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft3scoresI[i])) {
	  avgI += ft3scoresI[i];
	  avgIperk += ft4scoresI[i];
	  minft3scoreI = MIN(minft3scoreI, ft3scoresI[i]);
	  maxft3scoreI = MAX(maxft3scoreI, ft3scoresI[i]);
	  minft3perkI = MIN(minft3perkI, ft4scoresI[i]);
	  maxft3perkI = MAX(maxft3perkI, ft4scoresI[i]);
	}
      cout << "Min FT3 score on exons:   " << minft3scoreE << ";  \t MAX: " << maxft3scoreE << endl;
      cout << "Min FT3 score on introns: " << minft3scoreI << ";  \t MAX: " << maxft3scoreI << endl;
      cout << "Min FT3 perk on exons:   " << minft3perkE << ";  \t MAX: " << maxft3perkE << endl;
      cout << "Min FT3 perk on introns: " << minft3perkI << ";  \t MAX: " << maxft3perkI << endl;
      
      double interval_a      = MIN( minft3scoreE, minft3scoreI), interval_b      = MAX(maxft3scoreE, maxft3scoreI);
      double interval_a_perk = MIN( minft3perkE,  minft3perkI),  interval_b_perk = MAX(maxft3perkE,  maxft3perkI);
      double interval        = (interval_b - interval_a) / 10000;
      double interval_perk   = (interval_b_perk - interval_a_perk) / 10000;
      
      cout << "  interval: ( " << interval_a << " , " << interval_b << " )" << endl;
      
      int histE[10002], histI[10002];
      arrayZero(histE, 10002);
      arrayZero(histI, 10002);
      int histEperk[10002], histIperk[10002];
      arrayZero(histEperk, 10002);
      arrayZero(histIperk, 10002);
      
      histE[0]=histEperk[0] = failedAllE;
      histI[0]=histIperk[0] = failedAllI;
      
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft3scoresE[i])) {
	  assert((int) ( (ft3scoresE[i] - interval_a) / interval) >= 0 && (int) ( (ft3scoresE[i] - interval_a) / interval) < 10001);
	  histE[ (int) ( (ft3scoresE[i] - interval_a) / interval) + 1 ]++;
	}
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft3scoresI[i])) {
	  assert((int) ( (ft3scoresI[i] - interval_a) / interval) >= 0 && (int) ( (ft3scoresI[i] - interval_a) / interval) < 10001);
	  histI[ (int) ( (ft3scoresI[i] - interval_a) / interval) + 1 ]++;
	}
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft4scoresE[i])) {
	  assert((int) ( (ft4scoresE[i] - interval_a_perk) / interval_perk) >= 0 && (int) ( (ft4scoresE[i] - interval_a_perk) / interval_perk) < 10001);
	  histEperk[ (int) ( (ft4scoresE[i] - interval_a_perk) / interval_perk) + 1 ]++;
	}
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft4scoresI[i])) {
	  assert((int) ( (ft4scoresI[i] - interval_a_perk) / interval_perk) >= 0 && (int) ( (ft4scoresI[i] - interval_a_perk) / interval_perk) < 10001);
	  histIperk[ (int) ( (ft4scoresI[i] - interval_a_perk) / interval_perk) + 1 ]++;
	}
      
      int cumhistE[10002], cumhistI[10002];
      arrayZero(cumhistE, 10001); cumhistE[0] = histE[0];
      arrayZero(cumhistI, 10001); cumhistI[0] = histI[0];
      
      for (i=1; i<10002; ++i) {
	cumhistE[i] = cumhistE[i-1] + histE[i];
	cumhistI[i] = cumhistI[i-1] + histI[i];
      }    
      
      int cumhistEperk[10002], cumhistIperk[10002];
      arrayZero(cumhistEperk, 10001); cumhistEperk[0] = histEperk[0];
      arrayZero(cumhistIperk, 10001); cumhistIperk[0] = histIperk[0];
      
      for (i=1; i<10002; ++i) {
	cumhistEperk[i] = cumhistEperk[i-1] + histEperk[i];
	cumhistIperk[i] = cumhistIperk[i-1] + histIperk[i];
      }
      
      int totalE = cumhistE[10001], totalI = cumhistI[10001];
      avgE /= (totalE); avgEperk /= totalE;
      avgI /= (totalI); avgIperk /= totalE;
      
      int separation1    = totalE, separation2    = totalI;
      int separationptr1 = 0,      separationptr2 = 0;
      
      for (i=1; i<=10001; ++i) {
	if (separation1 >  ( (totalE - cumhistE[i-1]) + cumhistI[i-1] ) ) {
	  separation1    = ( (totalE - cumhistE[i-1]) + cumhistI[i-1] );
	  separationptr1 = i;
	}
	if (separation2 >  ( (totalI - cumhistI[i-1]) + cumhistE[i-1] ) ) {
	  separation2    = ( (totalI - cumhistI[i-1]) + cumhistE[i-1] );
	  separationptr2 = i;
	}
      }

      int separation1perk    = totalE, separation2perk    = totalI;
      int separationptr1perk = 0,      separationptr2perk = 0;
      
      for (i=1; i<=10001; ++i) {
	if (separation1perk >  ( (totalE - cumhistEperk[i-1]) + cumhistIperk[i-1] ) ) {
	  separation1perk    = ( (totalE - cumhistEperk[i-1]) + cumhistIperk[i-1] );
	  separationptr1perk = i;
	}
	if (separation2perk >  ( (totalI - cumhistIperk[i-1]) + cumhistEperk[i-1] ) ) {
	  separation2perk    = ( (totalI - cumhistIperk[i-1]) + cumhistEperk[i-1] );
	  separationptr2perk = i;
	}
      }

      double sep1,sep2, sep1perk, sep2perk;
      cout << "separation1: "   << (sep1=(2*((double)separation1))/ ((double)(totalE+totalI)))
	   << "   separation2 " << (sep2=(2*((double)separation2))/ ((double)(totalE+totalI))) << endl;
      cout << "sep 1 at:    " << separationptr1 << "   sep 2 at:   " << separationptr2 << endl;
      cout << "separation1perk: "   << (sep1perk=(2*((double)separation1perk))/ ((double)(totalE+totalI)))
	   << "   separation2perk " << (sep2perk=(2*((double)separation2perk))/ ((double)(totalE+totalI))) << endl;
      cout << "sep 1 perk at:    " << separationptr1perk << "   sep 2 perkat:   " << separationptr2perk << endl;
      cout << " Wrong frame guesses: " << ((double)wrongFrameGuesses)/((double)totalE) << endl;
      cout << "total E: " << totalE << "   total I: " << totalI << endl;

      
      fout << l << "\t" << 3 << "\t" << MIN(sep1, sep2) << "\t" << ((double)wrongFrameGuesses)/((double)totalE)
	   << "\t" << ((double)wrongFrameGuesses2)/((double)totalE)
	   << "\t" << ((double)failedAllI)/((double)totalI) << "\t" << avgE << "\t" << avgI << endl;

      fout << l << "\t" << 4 << "\t" << MIN(sep1perk, sep2perk) << "\t" << ((double)wrongFrameGuesses)/((double)totalE)
	   << "\t" << ((double)wrongFrameGuesses2)/((double)totalE)
	   << "\t" << ((double)failedAllI)/((double)totalI) << "\t" << avgEperk << "\t" << avgIperk << endl;
      
      delete[] ft3scoresE;
      delete[] ft3scoresI;
      delete[] ft4scoresE;
      delete[] ft4scoresI;
    }
    
    if (true) {
      cout << endl;
      cout << "(Freqs - FreqsIntron test) / (f1 + f2 + f3) test " << endl;
      
      double *ft5scoresE = new double[cptr];
      double *ft5scoresI = new double[iptr];
      double *ft6scoresE = new double[cptr];
      double *ft6scoresI = new double[iptr];
      int failedAllE = 0, failedAllI = 0;
      int wrongFrameGuesses=0, wrongFrameGuesses2=0;
      
      for (i=1; i<cptr-l; ++i) {
	ft5scoresE[i] = ftrels0[i+l] - ftrels0[i-1];
	ft5scoresE[i] = MAX( (ftrels1[i+l] - ftrels1[i-1]), ft5scoresE[i] );
	ft5scoresE[i] = MAX( (ftrels2[i+l] - ftrels2[i-1]), ft5scoresE[i] );

	if (ft5scoresE[i] > ftrels0[i+l] - ftrels0[i-1]) wrongFrameGuesses++;

	if      ( (ft5scoresE[i] == ftrels1[i+l] - ftrels1[i-1]) && !(cumStops1[i+l]-cumStops1[i-1])) wrongFrameGuesses2++;
	else if ( (ft5scoresE[i] == ftrels2[i+l] - ftrels2[i-1]) && !(cumStops2[i+l]-cumStops2[i-1])) wrongFrameGuesses2++;
	
	if (cumStops0[i+l]-cumStops0[i-1] && cumStops1[i+l]-cumStops1[i-1] && cumStops2[i+l]-cumStops2[i-1]) {
	  ft5scoresE[i] = ft6scoresE[i] = -Infinity;
	  failedAllE++;
	}
	else {
	  ft6scoresE[i] = 3*ft5scoresE[i] - (ftrels0[i+l] - ftrels0[i-1]) - (ftrels1[i+l] - ftrels1[i-1]) - (ftrels2[i+l] - ftrels2[i-1]);

	  ft5scoresE[i] = -Infinity;
	  if (!(cumStops0[i+l]-cumStops0[i-1])) { ft5scoresE[i] = ftrels0[i+l] - ftrels0[i-1]; }
	  if (!(cumStops1[i+l]-cumStops1[i-1])) { ft5scoresE[i] = MAX(ftrels1[i+l] - ftrels1[i-1], ft5scoresE[i]); }
	  if (!(cumStops2[i+l]-cumStops2[i-1])) { ft5scoresE[i] = MAX(ftrels2[i+l] - ftrels2[i-1], ft5scoresE[i]); } 
	  
	  ft5scoresE[i] = 3*ft5scoresE[i] - (ftrels0[i+l] - ftrels0[i-1]) - (ftrels1[i+l] - ftrels1[i-1]) - (ftrels2[i+l] - ftrels2[i-1]);
	}
      }
      ft5scoresE[0] = ft5scoresE[1];
      ft6scoresE[0] = ft6scoresE[1];
      
      for (i=1; i<iptr-l; ++i) {
	ft5scoresI[i] = (Iftrels0[i+l] - Iftrels0[i-1]);
	ft5scoresI[i] = MAX( (Iftrels1[i+l] - Iftrels1[i-1]), ft5scoresI[i]);
	ft5scoresI[i] = MAX( (Iftrels2[i+l] - Iftrels2[i-1]), ft5scoresI[i]);
	
	if (IcumStops0[i+l]-IcumStops0[i-1] && IcumStops1[i+l]-IcumStops1[i-1] && IcumStops2[i+l]-IcumStops2[i-1]) {
	  ft5scoresI[i] = ft6scoresI[i] = -Infinity;
	  failedAllI++;
	}
	else {
	  ft6scoresI[i] = 3*ft5scoresI[i] - (Iftrels0[i+l] - Iftrels0[i-1]) - (Iftrels1[i+l] - Iftrels1[i-1]) - (Iftrels2[i+l] - Iftrels2[i-1]);
	  
	  ft5scoresI[i] = -Infinity;
	  if (!(IcumStops0[i+l]-IcumStops0[i-1])) { ft5scoresI[i] = Iftrels0[i+l] - Iftrels0[i-1]; }
	  if (!(IcumStops1[i+l]-IcumStops1[i-1])) { ft5scoresI[i] = MAX(Iftrels1[i+l] - Iftrels1[i-1], ft5scoresI[i]); }
	  if (!(IcumStops2[i+l]-IcumStops2[i-1])) { ft5scoresI[i] = MAX(Iftrels2[i+l] - Iftrels2[i-1], ft5scoresI[i]); } 
	  
	  ft5scoresI[i] = 3*ft5scoresI[i] - (Iftrels0[i+l] - Iftrels0[i-1]) - (Iftrels1[i+l] - Iftrels1[i-1]) - (Iftrels2[i+l] - Iftrels2[i-1]);
	}
      }
      ft5scoresI[0] = ft5scoresI[1];
      ft6scoresI[0] = ft6scoresI[1];
      
      double minft5scoreE=Infinity, minft5perkE = Infinity, maxft5scoreE=-Infinity, maxft5perkE = -Infinity, avgE=0, avgEperk=0;
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft5scoresE[i])) {
	  avgE+= ft5scoresE[i];
	  avgEperk += ft6scoresE[i];
	  minft5scoreE = MIN(minft5scoreE, ft5scoresE[i]);
	  maxft5scoreE = MAX(maxft5scoreE, ft5scoresE[i]);
	  minft5perkE = MIN(minft5perkE, ft6scoresE[i]);
	  maxft5perkE = MAX(maxft5perkE, ft6scoresE[i]);
	}
      
      double minft5scoreI=Infinity, minft5perkI = Infinity, maxft5scoreI=-Infinity, maxft5perkI = -Infinity, avgI=0, avgIperk=0;
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft5scoresI[i])) {
	  avgI += ft5scoresI[i];
	  avgIperk += ft6scoresI[i];
	  minft5scoreI = MIN(minft5scoreI, ft5scoresI[i]);
	  maxft5scoreI = MAX(maxft5scoreI, ft5scoresI[i]);
	  minft5perkI = MIN(minft5perkI, ft6scoresI[i]);
	  maxft5perkI = MAX(maxft5perkI, ft6scoresI[i]);
	}
      
      cout << "Min FT5 score on exons:   " << minft5scoreE << ";  \t MAX: " << maxft5scoreE << endl;
      cout << "Min FT5 score on introns: " << minft5scoreI << ";  \t MAX: " << maxft5scoreI << endl;
      cout << "Min FT5 perk on exons:   " << minft5perkE << ";  \t MAX: " << maxft5perkE << endl;
      cout << "Min FT5 perk on introns: " << minft5perkI << ";  \t MAX: " << maxft5perkI << endl;
      
      double interval_a      = MIN( minft5scoreE, minft5scoreI), interval_b      = MAX(maxft5scoreE, maxft5scoreI);
      double interval_a_perk = MIN( minft5perkE,  minft5perkI),  interval_b_perk = MAX(maxft5perkE,  maxft5perkI);
      double interval        = (interval_b - interval_a) / 10000;
      double interval_perk   = (interval_b_perk - interval_a_perk) / 10000;
            
      cout << "  interval: ( " << interval_a << " , " << interval_b << " )" << endl;    
      
      int histE[10002], histI[10002];
      arrayZero(histE, 10002);
      arrayZero(histI, 10002);
      int histEperk[10002], histIperk[10002];
      arrayZero(histEperk, 10002);
      arrayZero(histIperk, 10002);
      
      histE[0]=histEperk[0] = failedAllE;
      histI[0]=histIperk[0] = failedAllI;
      
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft5scoresE[i])) {
	  assert((int) ( (ft5scoresE[i] - interval_a) / interval) >= 0 && (int) ( (ft5scoresE[i] - interval_a) / interval) < 10001);
	  histE[ (int) ( (ft5scoresE[i] - interval_a) / interval) + 1 ]++;
	}
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft5scoresI[i])) {
	  assert((int) ( (ft5scoresI[i] - interval_a) / interval) >= 0 && (int) ( (ft5scoresI[i] - interval_a) / interval) < 10001);
	  histI[ (int) ( (ft5scoresI[i] - interval_a) / interval) + 1 ]++;
	}
      for (i=1; i<cptr-l; ++i)
	if (isFinite(ft6scoresE[i])) {
	  assert((int) ( (ft6scoresE[i] - interval_a_perk) / interval_perk) >= 0 && (int) ( (ft6scoresE[i] - interval_a_perk) / interval_perk) < 10001);
	  histEperk[ (int) ( (ft6scoresE[i] - interval_a_perk) / interval_perk) + 1 ]++;
	}
      for (i=1; i<iptr-l; ++i)
	if (isFinite(ft6scoresI[i])) {
	  assert((int) ( (ft6scoresI[i] - interval_a_perk) / interval_perk) >= 0 && (int) ( (ft6scoresI[i] - interval_a_perk) / interval_perk) < 10001);
	  histIperk[ (int) ( (ft6scoresI[i] - interval_a_perk) / interval_perk) + 1 ]++;
	}
      
      int cumhistE[10002], cumhistI[10002];
      arrayZero(cumhistE, 10001); cumhistE[0] = histE[0];
      arrayZero(cumhistI, 10001); cumhistI[0] = histI[0];
      
      for (i=1; i<10002; ++i) {
	cumhistE[i] = cumhistE[i-1] + histE[i];
	cumhistI[i] = cumhistI[i-1] + histI[i];
      }
      
      int cumhistEperk[10002], cumhistIperk[10002];
      arrayZero(cumhistEperk, 10001); cumhistEperk[0] = histEperk[0];
      arrayZero(cumhistIperk, 10001); cumhistIperk[0] = histIperk[0];
      
      for (i=1; i<10002; ++i) {
	cumhistEperk[i] = cumhistEperk[i-1] + histEperk[i];
	cumhistIperk[i] = cumhistIperk[i-1] + histIperk[i];
      }
      
      int totalE = cumhistE[10001], totalI = cumhistI[10001];
      avgE /= (totalE); avgEperk /= totalE;
      avgI /= (totalI); avgIperk /= totalI;
      
      int separation1    = totalE, separation2    = totalI;
      int separationptr1 = 0,      separationptr2 = 0;
      
      for (i=1; i<=10001; ++i) {
	if (separation1 >  ( (totalE - cumhistE[i-1]) + cumhistI[i-1] ) ) {
	  separation1    = ( (totalE - cumhistE[i-1]) + cumhistI[i-1] );
	  separationptr1 = i;
	}
	if (separation2 >  ( (totalI - cumhistI[i-1]) + cumhistE[i-1] ) ) {
	  separation2    = ( (totalI - cumhistI[i-1]) + cumhistE[i-1] );
	  separationptr2 = i;
	}
      }

      int separation1perk    = totalE, separation2perk    = totalI;
      int separationptr1perk = 0,      separationptr2perk = 0;
      
      for (i=1; i<=10001; ++i) {
	if (separation1perk >  ( (totalE - cumhistEperk[i-1]) + cumhistIperk[i-1] ) ) {
	  separation1perk    = ( (totalE - cumhistEperk[i-1]) + cumhistIperk[i-1] );
	  separationptr1perk = i;
	}
	if (separation2perk >  ( (totalI - cumhistIperk[i-1]) + cumhistEperk[i-1] ) ) {
	  separation2perk    = ( (totalI - cumhistIperk[i-1]) + cumhistEperk[i-1] );
	  separationptr2perk = i;
	}
      }

      double sep1,sep2, sep1perk, sep2perk;
      cout << "separation1: "   << (sep1=(2*((double)separation1))/ ((double)(totalE+totalI)))
	   << "   separation2 " << (sep2=(2*((double)separation2))/ ((double)(totalE+totalI))) << endl;
      cout << "sep 1 at:    " << separationptr1 << "   sep 2 at:   " << separationptr2 << endl;
      cout << "separation1perk: "   << (sep1perk=(2*((double)separation1perk))/ ((double)(totalE+totalI)))
	   << "   separation2perk " << (sep2perk=(2*((double)separation2perk))/ ((double)(totalE+totalI))) << endl;
      cout << "sep 1 perk at:    " << separationptr1perk << "   sep 2 perkat:   " << separationptr2perk << endl;
      cout << " Wrong frame guesses: " << ((double)wrongFrameGuesses)/((double)totalE) << endl;
      cout << "total E: " << totalE << "   total I: " << totalI << endl;
      
      fout << l << "\t" << 5 << "\t" << MIN(sep1, sep2) << "\t" << ((double)wrongFrameGuesses)/((double)totalE)
	   << "\t" << ((double)wrongFrameGuesses2)/((double)totalE)
	   << "\t" << ((double)failedAllI)/((double)totalI) << "\t" << avgE << "\t" << avgI << endl;

      fout << l << "\t" << 6 << "\t" << MIN(sep1perk, sep2perk) << "\t" << ((double)wrongFrameGuesses)/((double)totalE)
	   << "\t" << ((double)wrongFrameGuesses2)/((double)totalE)
	   << "\t" << ((double)failedAllI)/((double)totalI) << "\t" << avgEperk << "\t" << avgIperk << endl;
      
      delete[] ft5scoresE;
      delete[] ft5scoresI;
      delete[] ft6scoresE;
      delete[] ft6scoresI;
    }
  }
}



