#include <fstream.h>
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "fseq.h"

int main(int argc, char *argv[]) {
  FilterSequence seq;

  int what = 0;
  cout << "0. Sort Database (infile.locus, outfile.seq, database.seq)"          << endl;
  cout << "1. Find Locus (infile.locus, database.seq)"             << endl;
  cout << "2. Accessions to Locuses (infile.acc, outfile.locus, database.seq)"  << endl;
  cout << "3. Find Nth Gene (number, database.seq)"          << endl;
  cout << "4. Filter first N entries (filterfile, outfile.locus, N, database.seq)" << endl;
  cout << "5. Create locus info and filter a database (filterfile, outfile.locus, database.seq)"       << endl;
  cout << "6. Create a new database with the given locusfile (infile.seq, infile.locus, outfile.seq)" << endl;
  cout << "7. Create dictionary out of database (infile.seq, outfile.plain)"             << endl;
  cout << "Enter now: ";
  cin >> what;
  
  switch(what) {
  case 0: 
    seq.SortDatabase(argv[1], argv[2], argv[3]);
    break;
  case 2:
    cout << "Accessions to locuses" << endl;
    seq.AccessionToLocus(argv[1], argv[2], argv[3]);
    break;
  case 1:
    seq.find_locus(argv[2],argv[1]);
    break;
  case 3:
    seq.find_Nth_gene(argv[2],atoi(argv[1]));
    cout << seq;
    break;
  case 5: 
    cout << " Create the locus information and filter a database" << endl;
    seq.Filter_Database(argv[1],argv[3],argv[2]);
    cout << "   called Filter_Database(" << argv[1] << "," << argv[3] << "," << argv[2] << endl;
    break;
  case 4:
    seq.Filter_N_Entries(argv[1],argv[4],argv[2],atoi(argv[3]));
    break;
  case 6: {
    ifstream dbase_in(argv[1]);
    seq.Create_Database(argv[2],argv[3],dbase_in);
    dbase_in.close();
    break;
  }
  case 7: {
    ifstream dbase_in(argv[1]);
    ofstream dict_out(argv[2]);
    while (dbase_in.good()) {
      dbase_in >> seq;
      dict_out << upcase(seq.get_locus()) << endl;
      int i;
      for(i=1;i<=seq.get_length();i++) 
	dict_out << upcase(seq.base2char(seq.get(i)));
      dict_out << endl;
      dict_out << endl;
    }
    dict_out.close();
    dbase_in.close();
    break;
  }
  default: {
    cout << "Usage: " << endl;
    cout << "  Find and display the gene:" << endl;
    cout << "  " << argv[0] << " <gene_num_or_locus> dbase.seq" << endl;
    cout << endl;
    cout << "  Create the locus information and filter a database:" << endl; 
    cout << "  " << argv[0] << " <filterFile> <locusFile> dbase.seq" << endl;
    cout << endl;
    cout << "  Filter the first N entries:" << endl;
    cout << "  " << argv[0] << " <filterFile> <locusFile> <N> dbase.seq" << endl;
    cout << endl;
    cout << "  Create a new database with the given locusFile" << endl;
    cout << "  " << argv[0] << " <dbase_in> <locusFile> <dbase_out>" << endl;
    cout << endl;
    cout << "  Create a dictionary out of the given database:" << endl;
    cout << "  " << argv[0] << " <dbase_in> create dict <dictionary>" << endl;
    cout << endl; }
  }
}
     




