#include "modules.h"

#define CUTOFF_AG -5
#define CUTOFF_GT -5

main(int argc, char* argv[]) {
  
  int i=0,j=0;
  
  FilterSequence seq;

  ifstream fin(argv[1]);

  Registry *reg=new Registry();  // Read in the registry
  ifstream regfile(argv[2]);
  regfile >> *reg;
  regfile.close();

  fstream fout(argv[3], ios::ate|ios::out);

  int trueExons[4]  = { 0,0,0,0 };
  int falseExons[4] = { 0,0,0,0 };

  int counter=0;
  while(fin.good()) {
    cout << "Processing Gene: " << ++counter << endl;
    fin >> seq;
    
    Region *r;
    for (i=1; i<seq.get_region_num(); ++i) {
      r = seq.get_region(i);
      int rlength = r->stop-r->start+1;
      switch (r->type) {
      case REGION_INTRON:
	fout << 1 << '\t' << rlength << endl;
	continue;
      case REGION_NCEXON:
	fout << 2 << '\t' << rlength << endl;
	continue;
      default: continue;
      }
      if (r->type != REGION_CEXON) continue;
      if      (r == seq.firstCExon() && r != seq.lastCExon()) 
	{ fout << 1 << '\t' << 0 << '\t' << rlength << endl; trueExons[0]++; }
      else if (r == seq.firstCExon() && r == seq.lastCExon()) 
	{ fout << 1 << '\t' << 1 << '\t' << rlength << endl; trueExons[1]++; }
      else if (r == seq.lastCExon())                          
	{ fout << 1 << '\t' << 2 << '\t' << rlength << endl; trueExons[2]++; }
      else                                                    
	{ fout << 1 << '\t' << 3 << '\t' << rlength << endl; trueExons[3]++; }
    }
    continue;
    
    if (seq.get_length() > 150000) continue;
    Modules* module=new Modules(&seq,reg);
    double *endpointStartScores   = module->getEndpointStartScore();
    double *endpointStopScores    = module->getEndpointStopScore();
    int    *endpointType          = module->getEndpointType();
    SparseMatrix<int>* stopMatrix = module->getStopMatrix();


    for (i=0; i<stopMatrix->sizeNonZero(); ++i) {
      if (rand()%7) continue;
      int from = stopMatrix->row(i), to = stopMatrix->col(i);
      
      int found=0;
      for (j=1; j<seq.get_region_num(); ++j) 
	if (seq.get_region(j)->start == from && seq.get_region(j)->stop == to) {
	  found=1;
	  break;
	}
      if (found) continue;
      
      if (endpointType[from] & ATG)
	if (!(endpointType[to] & STOP_CODON)) { if (endpointStopScores[to]    >= -6)  { fout << 0 << '\t' << 0 << '\t' << to-from+1 << endl; falseExons[0]++; } }
	else                                                                          { fout << 0 << '\t' << 1 << '\t' << to-from+1 << endl; falseExons[1]++; }
      else
	if (endpointType[to] & STOP_CODON)    { if (endpointStartScores[from] >= -6 &&
						    (!(rand()%3)))                    { fout << 0 << '\t' << 2 << '\t' << to-from+1 << endl; falseExons[2]++; } }
	else                                    if (endpointStartScores[from] >= -6 &&
						    endpointStopScores[to]    >= -6)  { fout << 0 << '\t' << 3 << '\t' << to-from+1 << endl; falseExons[3]++; }
    }
    delete module;
    cout << "SOFAR: " << endl;
    cout << "\t\t\t ATG/GT\t\t ATG/STOP\t\t AG/STOP\t\t << AG/GT" << endl;
    cout << "TRUE  EXONS:\t\t" << trueExons[0]  << "\t\t" << trueExons[1]  << "\t\t" << trueExons[2]  << "\t\t" << trueExons[3]  << endl;
    cout << "FALSE EXONS:\t\t" << falseExons[0] << "\t\t" << falseExons[1] << "\t\t" << falseExons[2] << "\t\t" << falseExons[3] << endl;
  }
  cout << "\t\t\t ATG/GT\t\t ATG/STOP\t\t AG/STOP\t\t << AG/GT" << endl;
  cout << "TRUE  EXONS:\t\t" << trueExons[0]  << "\t\t" << trueExons[1]  << "\t\t" << trueExons[2]  << "\t\t" << trueExons[3]  << endl;
  cout << "FALSE EXONS:\t\t" << falseExons[0] << "\t\t" << falseExons[1] << "\t\t" << falseExons[2] << "\t\t" << falseExons[3] << endl;
}



