#include "dictionary.h"

const char Dictionary::aa_char_num[256] = {
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA, A,AA, C, D, E, F, G, H, I,AA, K, L, M, N,AA,
  P, Q, R, S, T,AA, V, W,AA, Y,AA,AA,AA,AA,AA,AA,
  AA, A,AA, C, D, E, F, G, H, I,AA, K, L, M, N,AA,
  P, Q, R, S, T,AA, V, W,AA, Y,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA};

const char Dictionary::aa_num_char[256] = {
  'A','C','D','E','F','G','H','I','K','L','M','N','P','Q','R','S',
  'T','V','W','Y','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-'};

const char Dictionary::aa_filter[256] = {
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','A','-','C','D','E','F','G','H','I','-','K','L','M','N','-',
  'P','Q','R','S','T','-','V','W','-','Y','-','-','-','-','-','-',
  '-','A','-','C','D','E','F','G','H','I','-','K','L','M','N','-',
  'P','Q','R','S','T','-','V','W','-','Y','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-'};

const char Dictionary::dna_char_num[256] = {
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,DNA_A,AA,DNA_C,   AA,AA,AA,DNA_G,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,DNA_T,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,DNA_A,AA,DNA_C,   AA,AA,AA,DNA_G,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,DNA_T,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA,
  AA,   AA,AA,   AA,   AA,AA,AA,   AA,AA,AA,AA,AA,AA,AA,AA,AA};

const char Dictionary::dna_char_enc[256] = {
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,DNA_A,D_,DNA_C,   D_,D_,D_,DNA_G,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,DNA_T,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,DNA_A,D_,DNA_C,   D_,D_,D_,DNA_G,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,DNA_T,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_,
  D_,   D_,D_,   D_,   D_,D_,D_,   D_,D_,D_,D_,D_,D_,D_,D_,D_};

const char Dictionary::dna_num_char[256] = {
  'A','C','G','T','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-'};

const char Dictionary::dna_filter[256] = {
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','A','-','C','-','-','-','G','-','-','-','-','-','-','-','-',
  '-','-','-','-','T','-','-','-','-','-','-','-','-','-','-','-',
  '-','A','-','C','-','-','-','G','-','-','-','-','-','-','-','-',
  '-','-','-','-','T','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',
  '-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-'};

const char Dictionary::dna_num_aa_num[AA+1][AA+1][AA+1] = {
  { /* A */
    { K, N, K, N,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*AA-*/
    { T, T, T, T,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*AC-*/
    { R, S, R, S,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*AG-*/
    { I, I, M, I,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*AT-*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*A--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*A--*/
  },
  { /* C */
    { Q, H, Q, H,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*CA-*/
    { P, P, P, P,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*CC-*/
    { R, R, R, R,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*CG-*/
    { L, L, L, L,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*CT-*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*C--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*C--*/
  },
  { /* G */
    { E, D, E, D,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*GA-*/
    { A, A, A, A,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*GC-*/
    { G, G, G, G,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*GG-*/
    { V, V, V, V,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*GT-*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*G--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*G--*/
  },
  { /* T */
    {AA, Y,AA, Y,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*TA-*/
    { S, S, S, S,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*TC-*/
    {AA, C, W, C,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*TG-*/
    { L, F, L, F,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*TT-*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*T--*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*T--*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  },
  { /* - */
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}, /*---*/
    {AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA}  /*---*/
  }
};

unsigned long int **Dictionary::tuptr = (unsigned long int **) calloc (DNA_MAX_TUP + 1, 4);
unsigned long int *Dictionary::radix = (unsigned long int *) malloc (RADIXMEM);
char *Dictionary::tuple = (char *)Dictionary::tuptr;

char get_alphabet (FILE *acc_order)
{
  char alphabet;
  fseek (acc_order, -1, SEEK_END);
  fread (&alphabet, 1, 1, acc_order);
  return (alphabet);
}

unsigned long int get_numseq (FILE *seq_index)
{
  fseek (seq_index, 0, SEEK_END);
  return ((ftell (seq_index) >> 2) - 1);
}

Dictionary::Dictionary (const char *stem, char *errormsg)
  : stemlen(strlen (stem)),
    memok(radix && tuptr && memcpy (tuple, stem, stemlen)),
    filesok(memok && open_dict_files (tuple, tuple+stemlen, "r",
				      acc_codes, acc_order, 
				      seq_index, seq_lookup,
				      tup_index, tup_lookup)),
    alphabet(filesok ? get_alphabet(acc_order) : 0),
    num_char(alphabet == AA_ALPHABET ? aa_num_char : dna_num_char),
    char_num(alphabet == AA_ALPHABET ? aa_char_num : dna_char_num),
    TUP_LEN(alphabet == AA_ALPHABET ? AA_TUP_LEN : DNA_TUP_LEN),
    TUP_LEN_SUB_1(TUP_LEN - 1),
    num_seq(filesok ? get_numseq(seq_index) : 0),
    seq_lookup_bits(new iBits (alphabet == AA_ALPHABET ? 5 : 3, seq_lookup)),
    tup_lookup_bits(new iBits (iBits::cap2 (num_seq), tup_lookup))
{  
  if (filesok)
    {
      errormsg[0] = '\0';
      memset (tuple, 0, stemlen + 16);
    }
  else if (memok)
    sprintf (errormsg, "Couldn't open all dictionary files for reading.");
  else
    sprintf (errormsg, "Out of memory.");
}

Dictionary::~Dictionary ()
{
  trydelete (seq_lookup_bits);
  trydelete (tup_lookup_bits);

  tryclose (acc_codes);
  tryclose (acc_order);
  tryclose (seq_index);
  tryclose (seq_lookup);
  tryclose (tup_index);
  tryclose (tup_lookup);
}

/*** info query functions ***/

unsigned long int Dictionary::numSequences (void) const
{
  return (num_seq);
}

inline unsigned long int Dictionary::lenSequenceI (const unsigned long int p) const
{
  unsigned long int se[2];
  fseek (seq_index, p << 2, SEEK_SET);
  fread (se, 4, 2, seq_index);
  return (se[1] - se[0]);
}

unsigned long int Dictionary::lenSequence (const unsigned long int p) const
{
  return (p < num_seq ? lenSequenceI (p) : 0);
}

inline void Dictionary::getSequenceNameI (const unsigned long int p, char* target) const
{
  fseek (acc_codes, p << 5, SEEK_SET);
  memset (target, 0, ACC_CODE_LEN);
  fread (target, ACC_CODE_LEN - 1, 1, acc_codes);  
}

void Dictionary::getSequenceName (const unsigned long int p, char* target) const
{
  if (p < num_seq)
    getSequenceNameI (p, target);
  else
    target[0] = '\0';
}

inline void Dictionary::getSequence_SE_I (const unsigned long int pos,
					  const unsigned long int len,
					  char* target) const
{
#ifdef NOBITS
  fseek (seq_lookup, pos, SEEK_SET);
  fread (target, 1, len, seq_lookup);
#else
  seq_lookup_bits->read8 (len, (unsigned char *)target, pos);
  for (unsigned long i = 0; i < len; i++) target[i] = num_char[target[i]];
#endif
  target[len] = '\0';
}

inline void Dictionary::getSequenceI (const unsigned long int p, char* target) const
{
  unsigned long int se[2];

  fseek (seq_index, p << 2, SEEK_SET);
  fread (se, 4, 2, seq_index);

  getSequence_SE_I (se[0], se[1] - se[0], target);
}

void Dictionary::getSequence (const unsigned long int p, char* target) const
{
  if (p < num_seq) 
    getSequenceI (p, target);
  else
    target[0] = '\0';
}

unsigned long int Dictionary::getSequenceAccCode (const char *p) const
{
  char name[ACC_CODE_LEN];
  unsigned long int l = 0, r = num_seq - 1, m;

  while (l <= r)
    {
      fseek (acc_order, 36 * (m = ((l + 4) >> 1)), SEEK_SET);
      fread (name, ACC_CODE_LEN, 1, acc_order);
      int i = 0;

      while (name[i] == p[i] && name[i]) i++;
      if (name[i] == p[i]) 
	{
	  fread (&m, 4, 1, acc_order);
	  return (m);
	}
      
      if (p[i] > name[i])
	l = m + 1;
      else
	r = m - 1;
    }

  return (num_seq);
}

void Dictionary::Segments (const char *p, 
			   const unsigned long int len, 
			   const unsigned long int cutoff, 
			   ivector<unsigned long int>& segposs, 
			   ivector<unsigned long int>& segposp, 
			   ivector<unsigned long int>& seglen, 
			   ivector<unsigned long int>& segacc) const
{
  if (iMAX (cutoff, len) < TUP_LEN) return;

  const unsigned long int tupcutoff = iMAX (1, cutoff - TUP_LEN_SUB_1);
  unsigned long int i, j, good_count = 0, max_seq_len = 0, *ptr,
    *list = (unsigned long int *) malloc ((1 + len) << 2),
    *tups = (unsigned long int *) malloc ((1 + len) << 2),
    *good = (unsigned long int *) malloc (num_seq << 2),
    *cur_segs = (unsigned long int *) calloc (num_seq, 4);
  long int *len_segs = (long int *) calloc (num_seq, 4);
  char memok;

  if (!(list && tups && good && cur_segs && len_segs)) goto fmem;

  makeTupleList (alphabet, p, len, list); tups[0] = 0;
  cutShorts (list, tupcutoff, TUP_LEN_SUB_1, len);

  tuptr[DNA_MAX_TUP] = (unsigned long int *)(1);
  for (i = TUP_LEN_SUB_1; i <= len; i++)
    if (!tuptr[list[i]])
      tuptr[tups[++tups[0]] = list[i]] = (unsigned long int *)(1);
  tuptr[DNA_MAX_TUP] = 0;

  radixSort (tups + 1, (unsigned long int *)tuptr, tups[0]);
  memset (tuptr, 0, tups[0] << 2);
  {
    const unsigned long int *sent = tups + tups[0];
    unsigned long int se[2];

    for (ptr = tups + (memok = 1); ptr <= sent; ptr++)
      {
	const unsigned long int tup = *ptr;

	fseek (tup_index, tup << 2, SEEK_SET);
	fread (se, 4, 2, tup_index);

	if ((tuptr[tup] = (unsigned long int *) malloc ((1 + iMAX (1, se[1] - se[0])) << 2)))
	  tuptr[tup][0] = se[1] - (tuptr[tup][1] = se[0]);
	else
	  memok = 0;
      }
    if (!memok) goto fmem;

    for (ptr = tups + 1; ptr <= sent; ptr++)
      {
	const unsigned long int tup = *ptr;
#ifdef NOBITS
	fseek (tup_lookup, tuptr[tup][1] << 2, SEEK_SET);
	fread (tuptr[tup] + 1, 4, tuptr[tup][0], tup_lookup);
#else
        tup_lookup_bits->read32 (tuptr[tup][0], tuptr[tup] + 1, tuptr[tup][1]);
#endif
      }
  }

  i = TUP_LEN_SUB_1; for (unsigned long int next_stop = 0; i <= len; i++) 
    {
      const unsigned long int *cur = tuptr[list[i]], *last = tuptr[list[i-1]],
	*sent_c = cur + (cur ? cur[0] : 0), *sent_l = last + (last ? last[0] : 0);
      
      for (ptr = (unsigned long int *)(cur) + 1; ptr <= sent_c; ptr++)
	cur_segs[*ptr] = 1;
      
      for (ptr = (unsigned long int *)(last) + 1; ptr <= sent_l; ptr++)
	if (cur_segs[*ptr] == 0 && len_segs[*ptr] < (long int)tupcutoff)
	  len_segs[*ptr] = 0;
      
      char alive = 0;
      for (ptr = (unsigned long int *)(cur) + 1; ptr <= sent_c; ptr++)
	{
	  cur_segs[*ptr] = 0;
	  if (++len_segs[*ptr] < (long int)tupcutoff)
	    alive = 1;
	  else
	    if (len_segs[*ptr] == (long int)tupcutoff)
	      good[good_count++] = *ptr;
	}

      if (!alive)
	{
	  next_stop = iMAX (i, next_stop);
	  while (next_stop - i < tupcutoff + 1)
	    if ((i = next_stop) < len)
	      while (list[++next_stop] != DNA_MAX_TUP);
	    else
	      break;
	}
    }

  cleanTUPTR (tups);
  if (good_count && setupTUPTR (list, tups, len, TUP_LEN_SUB_1))
    {
      radixSort (good, cur_segs, good_count);
      for (j = 0; j < good_count; j++)
	{
	  const unsigned long int acode = good[j];
	  unsigned long int se[2];

	  fseek (seq_index, acode << 2, SEEK_SET);
	  fread (se, 4, 2, seq_index);

	  len_segs[acode] = se[1] - (cur_segs[acode] = se[0]);
	  if (max_seq_len < (unsigned long int)len_segs[acode]) max_seq_len = len_segs[acode];
	}

      good = (unsigned long int *) realloc (good, good_count << 2);
      unsigned long int *tarlist = (unsigned long int *) malloc ((1 + max_seq_len) << 2);
      char *dbseq = (char *) malloc (1 + max_seq_len);

      if (good && tarlist && dbseq)
	for (unsigned long int count = (i = 0); i < j; i++)
	  {
	    const unsigned long int obj = good[i], slen = len_segs[obj];
	    
	    getSequence_SE_I (cur_segs[obj], slen, dbseq);
	    makeTupleList (alphabet, dbseq, slen, tarlist);		
	    StringSegmentsI (list, tarlist, slen, tupcutoff, TUP_LEN_SUB_1, segposs, segposp, seglen);
	    for (; count < seglen.size (); count++) segacc.push_back (obj);
	  }
      
      tryfree (dbseq);
      tryfree (tarlist);
    }

 fmem:

  tryfree (list);
  tryfree (cur_segs);
  tryfree (len_segs);
  tryfree (good);

  if (tups)
    {
      cleanTUPTR (tups);
      free (tups);
    }

  return;
}

/*** static functions ***/

inline FILE* _local_file_open (const char *name, 
			       char *nameptr, 
			       const char *ext, 
			       const int extlen, 
			       const char *type)
{ 
  memcpy (nameptr, ext, extlen);
  return (fopen (name, type));
}

char Dictionary::open_dict_files (const char *outname, char *outnameptr, const char *type,
				  FILE* &acc_codes, FILE* &acc_order,
				  FILE* &seq_index, FILE* &seq_lookup,
				  FILE* &tup_index, FILE* &tup_lookup)
{
  acc_codes = _local_file_open (outname, outnameptr, ".acc.codes\0", 11, type);
  acc_order = _local_file_open (outname, outnameptr, ".acc.order\0", 11, type);
  seq_index = _local_file_open (outname, outnameptr, ".seq.index\0", 11, type);
  seq_lookup = _local_file_open (outname, outnameptr, ".seq.lookup\0", 12, type);
  tup_index = _local_file_open (outname, outnameptr, ".tup.index\0", 11, type);
  tup_lookup = _local_file_open (outname, outnameptr, ".tup.lookup\0", 12, type);

  if (!(acc_codes && acc_order &&
	seq_index && seq_lookup &&
	tup_index && tup_lookup))
    {
      fprintf (stderr, "\nError opening dictionary %s files for %s.\n", 
	      (type[0] == 'w' ? "target" : "source"), 
	      (type[0] == 'w' ? "writing" : "reading"));
      return (0);
    }

  return (1);
}

inline void Dictionary::makeTupleList (const char alphabet, 
				       const char *p, 
				       const unsigned long int len, 
				       unsigned long int *list)
{
  unsigned long int t = 0, last_bad = 0;

  const unsigned long int 
    TUP_LEN = (alphabet == AA_ALPHABET ? AA_TUP_LEN : DNA_TUP_LEN),
    MASK = (alphabet == AA_ALPHABET ? PCONV_MASK : DNA_MASK),
    SHIFT = (alphabet == AA_ALPHABET ? 5 : 2);

  char *pptr = (char *)p;

  const char* char_num = (alphabet == AA_ALPHABET ? aa_char_num : dna_char_num),
    *sent_1 = p + TUP_LEN - 1, *sent_2 = p + len;

  while (pptr < sent_1)
    {
      const char c = char_num[*(pptr++)];
      
      t = (t << SHIFT) | c;
      last_bad = (last_bad + 1) * (c != AA);
      *(list++) = DNA_MAX_TUP;
    }
  
  while (pptr < sent_2)
    {
      const char c = char_num[*(pptr++)];
      t = ((t << SHIFT) & MASK) | c;
      *(list++) = ((last_bad = (last_bad + 1) * (c != AA)) >= TUP_LEN ? t : DNA_MAX_TUP);
    }

  *list = DNA_MAX_TUP; // just a cap to make sure segments terminate
}

inline void Dictionary::cutShorts (unsigned long int *list,
				   const unsigned long int tupcutoff,
				   const unsigned long int TUP_LEN_SUB_1,
				   const unsigned long int len)
{
  for (unsigned long int slider = (unsigned long int)TUP_LEN_SUB_1; slider <= len; slider++)
    if (list[slider] != DNA_MAX_TUP)
      {
	const unsigned long int start = slider;
	while (list[slider++] != DNA_MAX_TUP);
	if (slider - start < tupcutoff)
	  for (unsigned long int cleanup = start; cleanup < slider; cleanup++)
	    list[cleanup] = DNA_MAX_TUP;
      }
}

inline char Dictionary::setupTUPTR (unsigned long int *list,
				    const unsigned long int *tups,
				    const unsigned long int len,
				    const unsigned long int TUP_LEN_SUB_1)
{
  const unsigned long int *sent_t = tups + tups[0], *sent_l = list + len;
  unsigned long int *ptr;
  char memok = 1;

  for (ptr = (unsigned long int *)tups + 1; ptr <= sent_t; ptr++) 
    tuptr[*ptr] = (unsigned long int *)(1);

  for (ptr = (unsigned long int *)list + TUP_LEN_SUB_1; ptr <= sent_l; ptr++) 
    if (tuptr[*ptr]) tuptr[*ptr]++; 

  for (ptr = (unsigned long int *)tups + 1; ptr <= sent_t; ptr++) 
    if ((tuptr[*ptr] = (unsigned long int *) malloc ((unsigned long int)(tuptr[*ptr]) << 2)))
      tuptr[*ptr][0] = 0;
    else
      memok = 0;

  if (memok)
    {
      for (unsigned long int i = TUP_LEN_SUB_1; i <= len; i++) 
	if ((ptr = tuptr[list[i]])) ptr[++ptr[0]] = i;

      for (unsigned long int i = 0; i <= len; i++)
	if (list[i] == DNA_MAX_TUP) list[i] = DNA_MAX_TUP + 1;
    }
  else 
    return (0);

  return (1);
}

inline void Dictionary::cleanTUPTR (const unsigned long int *tups)
{
  const unsigned long int *sent = tups + tups[0];
  for (unsigned long int *ptr = (unsigned long int *)tups + 1; ptr <= sent; ptr++) 
    if (tuptr[*ptr])
      {
	free (tuptr[*ptr]);
	tuptr[*ptr] = 0;
      }
}

inline void Dictionary::StringSegmentsI (const unsigned long int *srclist,
					 const unsigned long int *list, 
					 const unsigned long int len,
					 const unsigned long int tupcutoff, 
					 const unsigned long int TUP_LEN_SUB_1,
					 ivector<unsigned long int>& segposs, 
					 ivector<unsigned long int>& segposp, 
					 ivector<unsigned long int>& seglen)
{
  unsigned long int *ptr;
  
  for (unsigned long int i = TUP_LEN_SUB_1, next_stop = 0; i <= len; i++)
    {
      const unsigned long int *cur = tuptr[list[i]];
      unsigned long int hits = 0;

      if (cur)
	{
	  const unsigned long int *sent_c = cur + *cur;
	  
	  for (ptr = (unsigned long int *)(cur) + 1; ptr <= sent_c; ptr++)
	    if (list[i-1] != srclist[(*ptr) - 1])
	      {
		unsigned long int 
		  *srcposs = (unsigned long int *)(srclist + *ptr), 
		  *poss = (unsigned long int *)(list + i);

		while (*(poss++) == *(srcposs++));

		if ((unsigned long int)(poss - list) > (tupcutoff + i))
		  {
		    seglen.push_back (poss - list - i - 1 + TUP_LEN_SUB_1);
		    segposs.push_back (*ptr - TUP_LEN_SUB_1);
		    segposp.push_back (i - TUP_LEN_SUB_1);
		    hits++;
		  }
	      }
	}

      if (!hits)
	{
	  next_stop = iMAX (i, next_stop);
	  while (next_stop - i < tupcutoff + 1)
	    if ((i = next_stop) < len)
	      while (tuptr[list[++next_stop]]);
	    else
	      break;
	}
    }
}

void Dictionary::StringSegments (const char alphabet, 
				 const char *p0, 
				 const unsigned long int len0, 
				 const char *p1, 
				 const unsigned long int len1, 
				 const unsigned long int cutoff, 
				 ivector<unsigned long int>& segpos0, 
				 ivector<unsigned long int>& segpos1, 
				 ivector<unsigned long int>& seglen)
{
  unsigned long int *list0 = 0, *list1 = 0, *tups = 0;
  const unsigned long int len = iMAX (len0, len1), lenx4 = len << 2, len0x4 = len0 << 2, len1x4 = len1 << 2, 
    TUP_LEN_SUB_1 = (alphabet == AA_ALPHABET ? AA_TUP_LEN : DNA_TUP_LEN) - 1, tupcutoff = iMAX (1, cutoff - TUP_LEN_SUB_1);
      
  if (cutoff <= TUP_LEN_SUB_1) return;
      
  if ((tups = (unsigned long int *) malloc (lenx4 + 4)) &&
      (list0 = (unsigned long int *) malloc ((len0x4 + 4))) &&
      (list1 = (unsigned long int *) malloc ((len1x4 + 4))))
    {
      const unsigned long int *sent0 = list0 + len0, *sent1 = list1 + len1;
      
      makeTupleList (alphabet, p0, len0, list0);
      makeTupleList (alphabet, p1, len1, list1);

      cutShorts (list0, tupcutoff, TUP_LEN_SUB_1, len0);
      cutShorts (list1, tupcutoff, TUP_LEN_SUB_1, len1);
      
      tups[0] = 0; for (unsigned long int *ptr = list1 + TUP_LEN_SUB_1; ptr <= sent1; ptr++)
	if (!tuptr[*ptr]) tuptr[tups[++tups[0]] = *ptr] = (unsigned long int *)(1);
      
      for (unsigned long int *ptr = list0 + TUP_LEN_SUB_1; ptr <= sent0; ptr++)
	if (!tuptr[*ptr]) *ptr = DNA_MAX_TUP;
  
      { const unsigned long int *s1 = tups + tups[0];
      for (unsigned long int *ptr = tups + 1; ptr <= s1; ptr++) tuptr[*ptr] = 0; }
  
      tups[0] = 0; for (unsigned long int *ptr = list0 + TUP_LEN_SUB_1; ptr <= sent0; ptr++)
	if (!(*ptr == DNA_MAX_TUP || tuptr[*ptr])) tuptr[tups[++tups[0]] = *ptr] = (unsigned long int *)(1);
  
      { const unsigned long int *s0 = tups + tups[0];	
      for (unsigned long int *ptr = tups + 1; ptr <= s0; ptr++) tuptr[*ptr] = 0; }
  
      if (setupTUPTR (list0, tups, len0, TUP_LEN_SUB_1))
	StringSegmentsI (list0, list1, len1, tupcutoff, TUP_LEN_SUB_1, segpos0, segpos1, seglen);
      cleanTUPTR (tups);
    }
  
  tryfree (tups);
  tryfree (list0);
  tryfree (list1);
}

void Dictionary::translateDNAtoAA (const char *dna,
				   const unsigned long int aalen,
				   char *aa)
{
  unsigned long int i, ix3;

  for (i = ix3 = 0; i < aalen; i++, ix3 += 3)
    aa[i] = 
      aa_num_char[dna_num_aa_num
		 [dna_char_num[dna[ix3]]]
		 [dna_char_num[dna[ix3+1]]]
		 [dna_char_num[dna[ix3+2]]]];

  aa[i] = '\0';
}

void Dictionary::reverseComplement (char *dna,
				    const unsigned long int len)
{
  unsigned long int target = len - 1;

  for (unsigned long int i = 0; i <= target; i++, target--)
    {
      const char 
	c = dna_char_num[dna[i]],
	d = dna_char_num[dna[target]];
      
      dna[i] = dna_num_char[(d == AA ? AA : 3 - d)];
      dna[target] = dna_num_char[(c == AA ? AA : 3 - c)];
    }
}

char Dictionary::radixSort (unsigned long int *a,
			    unsigned long int *b,
			    const unsigned long int len)
{
  if (a && b)
    {
      register unsigned long int *ptr;

      /* Pass #1: a->b, last 16 bits. */
      memset (radix, 0, RADIXMEM);
      for (register const unsigned long int *sent = (ptr = a) + len; 
	   ptr != sent; ptr++) radix[(*ptr) & RADIXMASK]++;
      for (register const unsigned long int *sent = (ptr = radix + 1) + (RADIX - 1); 
	   ptr != sent; ptr++) *ptr += *(ptr - 1);
      ptr = a + len; while (ptr-- != a) b[--radix[(*ptr) & RADIXMASK]] = *ptr;

      /* Pass #2: b->a, first 16 bits. */
      memset (radix, 0, RADIXMEM);
      for (register const unsigned long int *sent = (ptr = b) + len; 
	   ptr != sent; ptr++) radix[(*ptr) >> 16]++;
      for (register const unsigned long int *sent = (ptr = radix + 1) + (RADIX - 1); 
	   ptr != sent; ptr++) *ptr += *(ptr - 1);
      ptr = b + len; while (ptr-- != b) a[--radix[(*ptr) >> 16]] = *ptr;

      return (0);
    }

  return (-1);
}

char Dictionary::radixSortFun (unsigned long int *a,
			       unsigned long int *b,
			       const unsigned long int len,
			       const unsigned long int *xform)
{
  if (a && b && xform)
    {
      register unsigned long int *ptr;

      /* Pass #1: a->b, last 16 bits. */
      memset (radix, 0, RADIXMEM);
      for (register const unsigned long int *sent = (ptr = a) + len; 
	   ptr != sent; ptr++) radix[xform[*ptr] & RADIXMASK]++;
      for (register const unsigned long int *sent = (ptr = radix + 1) + (RADIX - 1); 
	   ptr != sent; ptr++) *ptr += *(ptr - 1);
      ptr = a + len; while (ptr-- != a) b[--radix[xform[*ptr] & RADIXMASK]] = *ptr;

      /* Pass #2: b->a, first 16 bits. */
      memset (radix, 0, RADIXMEM);
      for (register const unsigned long int *sent = (ptr = b) + len; 
	   ptr != sent; ptr++) radix[xform[*ptr] >> 16]++;
      for (register const unsigned long int *sent = (ptr = radix + 1) + (RADIX - 1); 
	   ptr != sent; ptr++) *ptr += *(ptr - 1);
      ptr = b + len; while (ptr-- != b) a[--radix[xform[*ptr] >> 16]] = *ptr;

      return (0);
    }

  return (-1);
}
