#ifndef __COUNTTAB_H__
#define __COUNTTAB_H__

#include <fstream.h>

#include "fseq.h"
#include "gseq.h"

#define TUPLESIZE 6

int tup2int(FilterSequence*, long, int);
char num2base(int);
String int2tup(int, int);

class countTable {
  long maxTupNum;
  int *tupCounts, shift, windowSize, total;

public:
  countTable(istream&);
  countTable(int, int);
  ~countTable();

  void makeRanks(char*);

 void incTuples(FilterSequence*, int);
 void store(ofstream&);
 void print(ostream&);

 int getTupCount(int);
 int getMaxTup();
 
 double pctOnes();
 void printCutoff(int, ostream&);
};


class rankTable {

  int windowSize;
  int *ranks;

public:

  rankTable(char*);
  
  int rank(int);
  int rank(FilterSequence*, int);

  ~rankTable();
};


#endif
