#include <fstream.h>
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include <String.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "counttab.h"


/***
  Name: tup2int
  Expects: GeneSequence pointer, long, int
  Returns: integer
  Description: Takes a tuple from the sequence, indexes it in base 4.
  ***/

int tup2int(FilterSequence *seq, long ind, int tup) {
  int index=0;
  
  for(int i=tup-1, mult=1; i>=0; i--, mult*=4) {
    assert ( (ind + i) > 0 && (ind + i) <= seq->get_length());
    index += (mult * seq->get_nucleotide(ind+i));
  }

  return index;
}

String int2tup(int num, int tupSize) {
  String tup;

  for (int i=tupSize-1; i >=0; i--) {
    tup += (String)num2base((num % (int)pow(4,i+1)) / (int)pow(4,i));
  }

  return tup;
}

char num2base(int num) {
  switch(num) {
  case 0:
    {
      return 'a';
      break;
    }
  case 1:
    {
      return 'c';
      break;
    }
  case 2:
    {
      return 'g';
      break;
    }
  case 3:
    {
      return 't';
      break;
    }
  }
return 0;
}

  

countTable::countTable(int windowSize, int shift) {
  this->windowSize = windowSize;
  this->maxTupNum = (long)pow(4, windowSize);
  this->tupCounts = new int[maxTupNum];
  this->shift = shift;
  this->total = 0;
  
  for (int i = 0; i< maxTupNum; i++)
    tupCounts[i] = 0;
}

countTable::countTable(istream& cin) {
  cin.read((char *) &windowSize, sizeof(int));
  cin.read((char *) &maxTupNum, sizeof(long));
  this->tupCounts = new int[maxTupNum];
  cin.read((char *) &shift, sizeof(int));
  cin.read((char *) &total, sizeof(int));

  for (int i = 0; i< maxTupNum; i++) {
    cin.read((char *) &tupCounts[i], sizeof(int));
  }
  
}


countTable::~countTable() {
  delete[] tupCounts;
}

void countTable::incTuples(FilterSequence *seq, int pos) {

  int tupNum = tup2int(seq, pos, windowSize);
  tupCounts[tupNum]++;
  total++;
}  

void countTable::store(ofstream& fout) {
  fout.write((char *) &(windowSize), sizeof(int));
  fout.write((char *) &(maxTupNum), sizeof(long));

  fout.write((char *) &(shift), sizeof(int));
  fout.write((char *) &(total), sizeof(int));
  for (int i = 0; i < maxTupNum; i++) {
    fout.write((char *) &(tupCounts[i]), sizeof(int));
  }
}


void countTable::print(ostream& cout) {
  for (int i = 0; i < maxTupNum; i++) 
    cout << i << "\t" << tupCounts[i] << endl;
}

double countTable::pctOnes() {
  int ones=0;
  for (int i = 0; i < maxTupNum; i++)
    if (tupCounts[i] == 1)
      ones++;
  return (double) ones/total;
}

void countTable::printCutoff(int count, ostream& cout) {
  int above=0;
  for (int i = 0; i < maxTupNum; i++) 
    if (tupCounts[i] > count) {
      cout << int2tup(i, windowSize) << "\t" << tupCounts[i] << endl;
      above += tupCounts[i];
    }
  cout << "Freq. above  " << count << "\t" << (double)above/total << endl;
}

int countTable::getTupCount(int i) {
  return tupCounts[i];
}
  
int countTable::getMaxTup() {
  return maxTupNum;
}


void countTable::makeRanks(char* filename) {

  ofstream fout(filename);
  
  int ranks[maxTupNum];

  fout.write((char *) &maxTupNum, sizeof(long));
  fout.write((char *) &windowSize, sizeof(int));
  
  for (int i=0; i < maxTupNum; i++) {
    ranks[i]=1;
    for (int j=0; j < maxTupNum; j++) {
      if (this->getTupCount(i) < this->getTupCount(j))
	ranks[i]++;
    }
    fout.write((char *) &ranks[i], sizeof(int));
  }

  fout.close();
	
}


rankTable::rankTable(char* filename) {

  ifstream fin(filename);
  
  long maxTup;
  fin.read((char *) &maxTup, sizeof(long));
  fin.read((char *) &windowSize, sizeof(int));
  
  ranks = new int[maxTup];

  for (int i=0; i<maxTup; i++) {
    fin.read((char *) &ranks[i], sizeof(int));
  }

  fin.close();
}


int rankTable::rank(int i) {
  return ranks[i];
}

int rankTable::rank(FilterSequence *seq, int pos) {
  int tup = tup2int(seq, pos, windowSize);
  return ranks[tup];
}


rankTable::~rankTable() {
  delete[] ranks;
}
