#ifndef __CLUSTER_H__
#define __CLUSTER_H__

#include "fseq.h"
#include "gseq.h"


class Cluster {

  double **scores;
  int numPositions, *positionList;
  
public:

  Cluster();
  Cluster(int numPos=8);
  ~Cluster();

  double& score(int, int);
  int& position(int);
  int getNumPositions() {return numPositions;}

  double scoreSequence(FilterSequence*, int);
  
  void print();
  
};


class ClusterSpace {

  Cluster **clusterList;
  int numClusters, lastCluster;

public:

  ClusterSpace();
  ~ClusterSpace();

  void addData();
  void addCluster(double**);

  void printCluster(int);
  void printClusters();

  Cluster* getCluster(int);

  double getMinClusterScore(FilterSequence*, int);
  double getMaxClusterScore(FilterSequence*, int);
  
};


#endif
