#include <fstream.h>
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include <String.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "cluster.h"

Cluster::Cluster(int numPos) {

  this->numPositions = numPos;
  this->positionList = new int[numPositions];
  this->scores = new double*[4];
  for (int i=0; i<4; i++) 
    scores[i] = new double[numPositions];

  for (int n=0; n<4; n++)
    for (int j=0; j<numPositions; j++)
      scores[n][j] = 0;

  positionList[0] = -1;
  positionList[1] = 1;
  positionList[2] = 2;
  positionList[3] = 3;
  positionList[4] = 5;
  positionList[5] = 6;
  positionList[6] = 15;
  positionList[7] = 18;
    
}

Cluster::~Cluster() {
  for (int i=0; i<4; i++)
    delete[] scores[i];
  delete[] scores;
  delete[] positionList;
}


double& Cluster::score(int nuc, int posIndex) {
  assert (posIndex < numPositions);
  if (nuc == BASE_UNKNOWN)
    nuc = BASE_C;
  return scores[nuc][posIndex];
}

int& Cluster::position(int pos) {
  assert (pos < numPositions);
  return positionList[pos];
}

void Cluster::print() {
  for (int j=0; j< numPositions; j++) {
    for (int i=0; i<4; i++) {
      if (!score(i,j))
	cout << i << "/";
    }
    cout << "\t";
  }
  cout << endl;
}


double Cluster::scoreSequence(FilterSequence *seq, int pos) {

  if (position(0) + pos <= 0
      || position(numPositions-1) + pos > seq->get_length())
    return -1;
  else {
    double scr=0.0;

    for (int i=0; i< numPositions; i++) {
      scr += score(seq->get(position(i) + pos),
		   i);
    }
    return scr;
  }
}
    



/************** ClusterSpace Class *************************/

ClusterSpace::ClusterSpace() {
  this->numClusters = 10;
  this->lastCluster = 0;
  clusterList = new Cluster*[numClusters];

  for (int i=0; i<numClusters; i++)
    clusterList[i]=NULL;

  addData();
  
}

ClusterSpace::~ClusterSpace() {
  for(int i=0; i<lastCluster; i++)
    delete clusterList[i];
  delete[] clusterList;
}


void ClusterSpace::addCluster(double **scoreArr) {

  Cluster *newClust = new Cluster(8);

  for (int i=0; i<4; i++)
    for (int j=0; j<newClust->getNumPositions(); j++)
      newClust->score(i,j) = scoreArr[i][j];

  clusterList[lastCluster++] = newClust;
}

void ClusterSpace::printCluster(int i) {
  clusterList[i]->print();
}

void ClusterSpace::printClusters() {
  for (int i=0; i<lastCluster; i++)
    printCluster(i);
}



Cluster* ClusterSpace::getCluster(int i) {
  return clusterList[i];
}



double ClusterSpace::getMinClusterScore(FilterSequence *seq, int pos) {

  double score = getCluster(0)->scoreSequence(seq,pos), minScore = score;

  for (int i=1; i<lastCluster; i++) {
    score = getCluster(i)->scoreSequence(seq,pos);
    if (score < minScore)
      minScore = score;
  }
  
  return minScore;
}



double ClusterSpace::getMaxClusterScore(FilterSequence *seq, int pos) {
  double score = getCluster(0)->scoreSequence(seq,pos), maxScore = score;

  for (int i=1; i<lastCluster; i++) {
    score = getCluster(i)->scoreSequence(seq,pos);
    if (score > maxScore)
      maxScore = score;
  }
  return maxScore;
} 



void ClusterSpace::addData() {

  double** tempScores = new double*[4];
  for (int i=0; i<4; i++) 
    tempScores[i] = new double[8];
  

  /***** Cluster One *****/
  
  tempScores[0][0] = 0;
  tempScores[1][0] = 1;
  tempScores[2][0] = 1;
  tempScores[3][0] = 1;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 0;
  tempScores[1][3] = 1;
  tempScores[2][3] = 1;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 0;
  tempScores[1][5] = 0;
  tempScores[2][5] = 0;
  tempScores[3][5] = 1;
  
  tempScores[0][6] = 0;
  tempScores[1][6] = 0;
  tempScores[2][6] = 1;
  tempScores[3][6] = 0;
  
  tempScores[0][7] = 1;
  tempScores[1][7] = 1;
  tempScores[2][7] = 0;
  tempScores[3][7] = 1;
  
  addCluster(tempScores);



  /***** Cluster Two *****/
  
  tempScores[0][0] = 0;
  tempScores[1][0] = 1;
  tempScores[2][0] = 1;
  tempScores[3][0] = 1;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 0;
  tempScores[1][3] = 1;
  tempScores[2][3] = 1;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 1;
  tempScores[1][5] = 1;
  tempScores[2][5] = 1;
  tempScores[3][5] = 0;
  
  tempScores[0][6] = 0;
  tempScores[1][6] = 1;
  tempScores[2][6] = 1;
  tempScores[3][6] = 0;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 1;
  tempScores[3][7] = 0;
  
  
  addCluster(tempScores);


  /***** Cluster Three *****/
  
  tempScores[0][0] = 0;
  tempScores[1][0] = 1;
  tempScores[2][0] = 1;
  tempScores[3][0] = 1;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 0;
  tempScores[1][3] = 1;
  tempScores[2][3] = 1;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 0;
  tempScores[1][4] = 0;
  tempScores[2][4] = 0;
  tempScores[3][4] = 0;

  tempScores[0][5] = 0;
  tempScores[1][5] = 0;
  tempScores[2][5] = 0;
  tempScores[3][5] = 1;
  
  tempScores[0][6] = 0;
  tempScores[1][6] = 1;
  tempScores[2][6] = 1;
  tempScores[3][6] = 0;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 1;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);


  /***** Cluster Four *****/
  
  tempScores[0][0] = 0;
  tempScores[1][0] = 0;
  tempScores[2][0] = 0;
  tempScores[3][0] = 0;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 0;
  tempScores[1][3] = 1;
  tempScores[2][3] = 1;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 0;
  tempScores[1][5] = 0;
  tempScores[2][5] = 0;
  tempScores[3][5] = 0;
  
  tempScores[0][6] = 1;
  tempScores[1][6] = 1;
  tempScores[2][6] = 0;
  tempScores[3][6] = 1;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 0;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);

  
  /***** Cluster Five *****/
  
  tempScores[0][0] = 1;
  tempScores[1][0] = 0;
  tempScores[2][0] = 0;
  tempScores[3][0] = 0;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 1;
  tempScores[1][3] = 1;
  tempScores[2][3] = 0;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 1;
  tempScores[1][5] = 1;
  tempScores[2][5] = 1;
  tempScores[3][5] = 0;
  
  tempScores[0][6] = 0;
  tempScores[1][6] = 0;
  tempScores[2][6] = 1;
  tempScores[3][6] = 0;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 0;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);


    
  /***** Cluster Six *****/
  
  tempScores[0][0] = 1;
  tempScores[1][0] = 0;
  tempScores[2][0] = 0;
  tempScores[3][0] = 0;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 1;
  tempScores[1][3] = 1;
  tempScores[2][3] = 0;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 1;
  tempScores[1][5] = 1;
  tempScores[2][5] = 1;
  tempScores[3][5] = 0;
  
  tempScores[0][6] = 0;
  tempScores[1][6] = 0;
  tempScores[2][6] = 1;
  tempScores[3][6] = 0;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 0;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);


  
  /***** Cluster Seven *****/
  
  tempScores[0][0] = 1;
  tempScores[1][0] = 0;
  tempScores[2][0] = 0;
  tempScores[3][0] = 0;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 1;
  tempScores[1][3] = 1;
  tempScores[2][3] = 0;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 1;
  tempScores[1][5] = 1;
  tempScores[2][5] = 1;
  tempScores[3][5] = 0;
  
  tempScores[0][6] = 1;
  tempScores[1][6] = 1;
  tempScores[2][6] = 0;
  tempScores[3][6] = 1;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 1;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);
  

  
  /***** Cluster Eight *****/
  
  tempScores[0][0] = 0;
  tempScores[1][0] = 1;
  tempScores[2][0] = 1;
  tempScores[3][0] = 1;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 1;
  tempScores[1][3] = 1;
  tempScores[2][3] = 0;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 0;
  tempScores[1][5] = 0;
  tempScores[2][5] = 0;
  tempScores[3][5] = 1;
  
  tempScores[0][6] = 0;
  tempScores[1][6] = 0;
  tempScores[2][6] = 1;
  tempScores[3][6] = 0;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 0;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);


  /***** Cluster Nine *****/
  
  tempScores[0][0] = 0;
  tempScores[1][0] = 1;
  tempScores[2][0] = 1;
  tempScores[3][0] = 1;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 1;
  tempScores[1][3] = 1;
  tempScores[2][3] = 0;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 0;
  tempScores[1][5] = 0;
  tempScores[2][5] = 0;
  tempScores[3][5] = 1;
  
  tempScores[0][6] = 1;
  tempScores[1][6] = 1;
  tempScores[2][6] = 0;
  tempScores[3][6] = 1;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 1;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);


  
  /***** Cluster Ten *****/
  
  tempScores[0][0] = 0;
  tempScores[1][0] = 1;
  tempScores[2][0] = 1;
  tempScores[3][0] = 1;
  
  tempScores[0][1] = 1;
  tempScores[1][1] = 1;
  tempScores[2][1] = 0;
  tempScores[3][1] = 1;
  
  tempScores[0][2] = 1;
  tempScores[1][2] = 1;
  tempScores[2][2] = 1;
  tempScores[3][2] = 0;
  
  tempScores[0][3] = 1;
  tempScores[1][3] = 1;
  tempScores[2][3] = 0;
  tempScores[3][3] = 1;
  
  tempScores[0][4] = 1;
  tempScores[1][4] = 1;
  tempScores[2][4] = 0;
  tempScores[3][4] = 1;

  tempScores[0][5] = 1;
  tempScores[1][5] = 1;
  tempScores[2][5] = 1;
  tempScores[3][5] = 0;
  
  tempScores[0][6] = 0;
  tempScores[1][6] = 0;
  tempScores[2][6] = 1;
  tempScores[3][6] = 0;
  
  tempScores[0][7] = 0;
  tempScores[1][7] = 0;
  tempScores[2][7] = 1;
  tempScores[3][7] = 0;
  
  addCluster(tempScores);


  
  
  delete tempScores;
  
}
  









